import React from 'react'

import { HeaderWidget } from '../../common/components/HeaderWidget/HeaderWidget.js'
import { GridItemTopMiddleLocation } from '../components/GridItemTopMiddleLocation.js'
import { GridItemUnderLocation } from '../components/GridItemUnderLocation.js'

import '../styles/GridLayout.css'

export function GridContainer( { configState } ) {
  const {
    boxCtaText,
    boxCtaTextColor,
    boxCtaBackgroundColor,
    sectionTitle,
    sectionSubtitle,
    sectionTitlesColor,
  } = configState
  const boxTextLocation = configState.boxTextLocation?.trim().toLowerCase()
  const isNotUnderLocation = boxTextLocation !== 'under'

  return (
    <section
      className={`xw-featured-grid-container xw-featured-anim-${configState.entranceAnimation}`}
      style={{ marginBlock: configState.margins }}
    >
      <HeaderWidget
        sectionSubtitle={sectionSubtitle}
        sectionTitle={sectionTitle}
        sectionTitlesColor={sectionTitlesColor}
      />
      <ul className="xw-featured-grid-list xw-featured-reset-ul xw-featured-grid-list-margin">
        {
          configState.boxes.map( ( item, index ) => (
            isNotUnderLocation
              ? (
                <GridItemTopMiddleLocation
                  key={index}
                  boxAnimation={configState.boxAnimation}
                  boxCtaBackgroundColor={boxCtaBackgroundColor}
                  boxCtaText={boxCtaText}
                  boxCtaTextColor={boxCtaTextColor}
                  boxTextLocation={boxTextLocation}
                  item={item}
                />
              )
              : (
                <GridItemUnderLocation
                  key={index}
                  boxAnimation={configState.boxAnimation}
                  boxCtaBackgroundColor={boxCtaBackgroundColor}
                  boxCtaText={boxCtaText}
                  boxCtaTextColor={boxCtaTextColor}
                  item={item}
                />
              )
          ) )
        }
      </ul>
    </section>
  )
}
