import React, { forwardRef, useState } from 'react'

import { DivButton } from '../../common/components/Buttons/DivButton/DivButton.js'
import PlaceholderIcon from '../../assets/icons/placeholder.svg'

import '../styles/CarouselCommonlItemSlide.css'
import '../styles/CarouselItemSlideTopMiddle.css'

export const CarouselItemSlideTopMiddle = forwardRef( ( props, refLastSlide ) => {
  const {
    slide,
    index,
    boxAnimation,
    lastElement,
    boxTextLocation,
    boxCtaText,
    boxCtaTextColor,
    boxCtaBackgroundColor,
  } = props

  const [isHover, setIsHover] = useState( false )
  const onMouseEnterFigureHoverOn = () => setIsHover( true )
  const onMouseLeaveFigureHoverOff = () => setIsHover( false )

  return (
    <li
      key={index}
      ref={index === lastElement ? refLastSlide : null}
      className={`xw-featured-carousel-item-top-middle-boxTextLocation ${boxAnimation}`}
    >
      <a className="xw-featured-carousel-item-link" href={slide.ctaLink}>
        <div
          className="xw-featured-image-container-top-middle"
          onMouseEnter={onMouseEnterFigureHoverOn}
          onMouseLeave={onMouseLeaveFigureHoverOff}
        >
          {
            slide.boxImage
              ? (
                <img
                  alt={slide.boxText}
                  src={slide.boxImage}
                />
              )
              : (
                <PlaceholderIcon
                  className="xw-featured-carousel-image-placeholder-top-middle-boxTextLocation"
                  height="100%"
                  width="100%"
                />
              )
          }
          <div
            className={`xw-featured-text-container-${boxTextLocation}-boxTextLocation`}
            style={{
              color: isHover ? undefined : slide.boxTextColor,
            }}
          >
            <h2
              className="xw-featured-text-container-boxtext xw-featured-capitalize-first-letter xw-featured-reset-margin"
              style={{
                color: isHover ? undefined : slide.boxTextColor,
              }}
            >
              {slide.boxText}
            </h2>
            <p
              className="xw-featured-text-container-boxsubtext xw-featured-capitalize-first-letter xw-featured-reset-margin"
              style={{
                color: slide.boxSubTextColor,
              }}
            >
              {slide.boxSubtext}
            </p>
          </div>
          {
            boxCtaText && (
              <div className="xw-featured-button-wrapper">
                <DivButton
                  className="xw-featured-position-button-cta"
                  size="xs"
                  style={{
                    color: isHover ? boxCtaTextColor : 'white',
                    backgroundColor: isHover ? boxCtaBackgroundColor : 'black',
                    borderColor: isHover ? boxCtaBackgroundColor : 'black',
                  }}
                >
                  {boxCtaText}
                </DivButton>
              </div>
            )
          }
        </div>
      </a>
    </li>
  )
} )
