import React from 'react'

import './HeaderWidget.css'

export function HeaderWidget( props ) {
  const {
    sectionTitle,
    sectionTitlesColor,
    sectionSubtitle,
  } = props

  if ( !sectionTitle ) return null

  return (
    <header className="xw-featured-header-widget-container xw-featured-header-widget-container-margin">
      {
        sectionTitle
        && (
          <h3
            className="xw-featured-widget-title text-center xw-featured-reset-margin"
            style={{ color: sectionTitlesColor }}
          >
            {sectionTitle}
          </h3>
        )
      }
      {
        sectionSubtitle
        && (
          <p
            className="xw-featured-widget-subtitle xw-featured-text-center xw-featured-reset-margin"
            style={{ color: sectionTitlesColor }}
          >
            {sectionSubtitle}
          </p>
        )
      }
    </header>
  )
}
