import React, { useState } from 'react'
import classNames from 'classnames'

import { DivButton } from '../../common/components/Buttons/DivButton/DivButton.js'
import PlaceholderIcon from '../../assets/icons/placeholder.svg'
import { topMiddleLocationAnimation } from '../constants.js'

import '../styles/GridlItemSlideTopMiddle.css'

export function GridItemTopMiddleLocation( props ) {
  const {
    item,
    boxTextLocation,
    boxAnimation,
    boxCtaTextColor,
    boxCtaBackgroundColor,
    boxCtaText,
  } = props

  const [isHover, setIsHover] = useState( false )
  const onMouseEnterFigureHoverOn = () => setIsHover( true )
  const onMouseLeaveFigureHoverOff = () => setIsHover( false )

  const splittedText = item.boxText.split( ' ' )
  const middleText = Math.floor( splittedText.length / 2 )
  const firstPart = splittedText.slice( 0, middleText )
  const secondPart = splittedText.slice( middleText )

  return (
    <li key={item.id} className="xw-featured-grid xw-featured-grid-item-top-middle-boxTextLocation">
      <a href={item.ctaLink}>
        <figure
          className={classNames( `xw-featured-grid-figure xw-featured-${topMiddleLocationAnimation[boxAnimation]} xw-featured-${boxTextLocation}-boxTextLocation`, {
            'xw-featured-grid-figure-placeholder': !item.boxImage,
          } )}
          onMouseEnter={onMouseEnterFigureHoverOn}
          onMouseLeave={onMouseLeaveFigureHoverOff}
        >
          {
            item.boxImage
              ? (
                <img
                  alt={item.boxText}
                  src={item.boxImage}
                />
              )
              : (
                <PlaceholderIcon
                  className="xw-featured-image-placeholder-top-middle-boxTextLocation"
                  height="100%"
                  width="100%"
                />
              )
          }

          <figcaption
            className={classNames( {
              // TODO: check xw-featured-grid-figcaption-top-boxTextLocation
              'xw-featured-grid-figcaption-top-boxTextLocation': boxTextLocation === 'top',
              'xw-featured-grid-figcaption-middle-boxTextLocation': boxTextLocation === 'middle',
            } )}
            style={{ color: isHover ? undefined : item.boxTextColor }}
          >
            <h2
              className="xw-featured-text-container-boxtext xw-featured-capitalize-first-letter"
              style={{
                color: isHover ? undefined : item.boxTextColor,
              }}
            >
              {firstPart.join( ' ' )}
              {' '}
              <span>{secondPart?.join( ' ' )}</span>
            </h2>
            <p
              className="xw-featured-text-container-boxsubtext"
              style={{ color: item.boxSubTextColor }}
            >
              {item.boxSubtext}
            </p>
            {
              boxCtaText && (
                <div className="xw-featured-grid-button-wrapper">
                  <DivButton
                    className="xw-featured-grid-button-cta xw-featured-grid-cta-button-top-middle-boxTextLocation"
                    style={{
                      color: isHover ? boxCtaTextColor : 'white',
                      backgroundColor: isHover ? boxCtaBackgroundColor : 'black',
                      borderColor: isHover ? boxCtaBackgroundColor : 'black',
                    }}
                  >
                    {boxCtaText}
                  </DivButton>
                </div>
              )
            }
          </figcaption>
        </figure>
      </a>
    </li>
  )
}
