import React, { useState } from 'react'
import classNames from 'classnames'

import { DivButton } from '../../common/components/Buttons/DivButton/DivButton.js'
import PlaceholderIcon from '../../assets/icons/placeholder.svg'
import {
  borderHighlightingEffect, bounceTopEffect, trackingInContractEffect,
} from '../constants.js'

import '../styles/GridlItemSlideUnder.css'

export function GridItemUnderLocation( props ) {
  const {
    item,
    boxAnimation,
    boxCtaTextColor,
    boxCtaBackgroundColor,
    boxCtaText,
  } = props

  const [isHover, setIsHover] = useState( false )
  const onMouseEnterFigureHoverOn = () => setIsHover( true )
  const onMouseLeaveFigureHoverOff = () => setIsHover( false )

  return (
    <li
      className={classNames( 'xw-featured-grid-item-under-boxTextLocation', {
        'xw-featured-border-highlighting-effect': borderHighlightingEffect === boxAnimation,
        'xw-featured-bounce-top-effect': bounceTopEffect === boxAnimation,
      } )}
    >
      <a className="xw-featured-grid-link-under-boxTextLocation" href={item.ctaLink}>
        <figure
          className="xw-featured-grid-figure under-boxTextLocation xw-featured-reset-margin"
          onMouseEnter={onMouseEnterFigureHoverOn}
          onMouseLeave={onMouseLeaveFigureHoverOff}
        >
          <div
            className={classNames( 'xw-featured-grid-image-block-under-boxTextLocation', {
              'xw-featured-tracking-in-contract-effect': trackingInContractEffect === boxAnimation,
              'xw-featured-grid-figure-placeholder': !item.boxImage,
            } )}
          >
            {
              item.boxImage
                ? (
                  <img
                    alt={item.boxText}
                    className="xw-featured-grid-image"
                    src={item.boxImage}
                  />
                )
                : (
                  <PlaceholderIcon
                    className="xw-featured-image-placeholder-under-boxTextLocation"
                    height="100%"
                    width="100%"
                  />
                )
            }
            <p
              className="xw-featured-grid-image-subtext-area xw-featured-text-container-boxsubtext xw-featured-capitalize-first-letter"
              style={{ color: item.boxSubTextColor }}
            >
              {item.boxSubtext}
            </p>
          </div>
          <figcaption
            className="xw-featured-grid-block-text-under-boxTextLocation xw-featured-text-center"
          >
            <h2
              className="xw-featured-text-container-boxtext xw-featured-capitalize-first-letter xw-featured-reset-margin"
              style={{ color: isHover ? undefined : item.boxTextColor }}
            >
              {item.boxText}
            </h2>
            {
              boxCtaText && (
                <DivButton
                  className="xw-featured-button-cta-under-boxTextLocation"
                  style={{
                    color: boxCtaTextColor,
                    backgroundColor: isHover ? 'black' : boxCtaBackgroundColor,
                    borderColor: isHover ? 'black' : boxCtaBackgroundColor,
                  }}
                >
                  {boxCtaText}
                </DivButton>
              )
            }
          </figcaption>
        </figure>
      </a>
    </li>
  )
}
