
# UStore Widgets

The Widgets are small React components that can be shared across different themes, and added to an existing theme in specific slots defined inside each theme.


## Requirements

1. Each Widget must be contained inside a root folder that is named with a **distinctive** name, using `A-Z a-z` and `_` characters only. For example: `sample_widget_1`.
If you mean to keep maintenance and develop further versions, it is best to add the version number to the widgets name, to keep uniqueness.

2. Each Widget project must contain to following files:
```
- config.json
- thumbnail.png
- src/index.widget.js
```
In the sample project folder you'll notice some extra files, which are not mandatory and are there for development/build purposes. It is important not to alter these files, to keep the project's features active.

### Configuration
The `config.json` file includes vital configurations in a JSON format:  
- `engineVersion` The unique version of the widget. Accepted characters: `0-9` and `.`
- `uStoreVersion` The uStore version of which the widget was first built to. Important for backwards compatibility. Accepted characters: `0-9` and `.`
- `uniqueIdentifier` The unique name for the widget. If uploading to uStore a widget with a uniqueIdentifier that already exists, the new one will override the existing one. Accepted characters: `A-Z`, `a-z` and `_`
- `displayName` Display name for the widget, which will be shown in uStore.
- `description` Description for the widget purposes
- `configurationHelpText` Instructions on how to configure the widget
- `defaultConfiguration` Widget's configuration, JSON format works the best

#### Theme Configuration
To support the widgets, the uStore theme must have a `widgets` property under the `customization` property inside its `config.json` file. The config will list all the available Slots in the theme.  
Each slot will have the following configurations:
- `name` unique name for the slot
- `displayName` a display name for the slot
Example:
```
{
  "engineVersion": "1",
  "uStoreVersion": "15.4.10900",
  "name": "AquaBlue",
  "displayName": "XMPie AquaBlue",
  "customization": {
    "widgets": {
      "locations": [
        {
          "name": "header",
          "displayName": "Header"
        }
      ]
    },
    .
    .
    .
```


## Project Structure
```
|-- widget_project_sample
    |-- .babelrc
    |-- .gitignore
    |-- package.json
    |-- webpack.config.js
    |-- scripts
    |   |-- build-user.js
    |   |-- dev.js
    |-- xmpie_Sample_1
        |-- config.json
        |-- thumbnail.png
        |-- public
        |   |-- index.html
        |-- src
        |   |-- index.js
        |   |-- index.widget.js
        |-- styles
            |-- index.widget.css
```
## Features

### Installation
Install with NPM

```bash
cd widget_project_sample
npm Install
```

### Local Development
By running the dev command, you'll be able to see the widget as-is, not inside an existing theme. As each widget is a stand-alone component that must be able to run by its own, the development environment will let you see each change you make to your widget component.

To run the development environment simply run
```bash
npm start
```

By default, the development environment will run a webpack dev server under the port `9000`.

### Publish
The published script will locate every parent folder that contains a `src/index.widget.js` file and will generate a separate zip file for it.

You may publish your widget by running the `build` command, that will generate a zip file compatible to the project requirements. This zip file can be uploaded to UStore as a new widget.

- If the folder contains a `config.json` file, the project will be built according to the configurations inside this file, just by running

    ```bash
    npm run build
    ```

- If you wish to use our built-in widget configuration generator, you may remove the `config.json` file or running the command
    ```bash
    npm run build --config
    ```

### Development with uStore themes
To develop a widget and see it a specific slot/slots inside the theme, you may run the `npm start` command with the `widgetbuild` parameter. The parameter may refer to a location of a folder that contains one Widget/few Widgets.  
The configuration for the widgets will be taken according to the following logic:
1. Widgets that doesn't have local development folder to which `widgetbuild` parameter points, and exist in uStore, will have their configuration taken from uStore server.

2. Widgets that have local development folder and also exist in uStore will have their config from the local `config.json` file. If the widget has local slot configuration(see [`Local Slot Configuration`](#Local-Slot-Configuration)), it will override the configuration set in uStore.

3. Widgets that have local development folder and doesn't exist in uStore, will have their configuration from their local `config.json` file and their location configuration according to how its set (via json config file).

### Local Slot Configuration
Create a JSON file, in any name, and any location, and point to this file using the `json` parameter. For example:
```bash
npm start server=10.0.0.1 widgetbuild=C:\Users\MyBrand\widgets json=C:\Users\MyBrand\Documents\widgets.slot.config.json
```
The widget slot configuration file contains an object, which its keys are locations and values are arrays which contain the widgets unique identifiers.
The widgets unique identifiers you can find in config.json in the field `uniqueIdentifier` of your widget.
```
{
    "footer": ["xmpie_Sample_1", "xmpie_Sample_2", "xmpie_Sample_3"],
}
```
Example where config.json is stored 
```
    |-- xmpie_Sample_1
        |-- config.json
```
### Postcss

You can add prefixes to your css classes. To add some certain prefix you need to go to [postcss.config.mjs](postcss.config.mjs) 
and add a value for a prefix key.

Example:

```javascript
prefix: 'xw-featured-'
```

To start adding prefixes, you need to enter the following code. This code will add prefixes in working files. 
Note depending on the operating system there are cases that a path needs to be enclosed in quotes. 

With quotes:
```
npm run postcss "add/your-path/*.css"
```
Without quotes:
```
npm run postcss add/your-path/*.css
```

