import React, { useEffect, useState } from 'react'

import {
  HomePageBannerContainer,
} from './HomePageBanner/containers/HomePageBannerContainer.js'
import RefreshIcon from './assets/icons/refresh.svg'

import '../styles/index.widget.css'

function IndexWidget( { config } ) {
  const [configState, setConfigState] = useState( null )
  const [isLoading, setIsLoading] = useState( true )

  useEffect( () => {
    if ( config ) {
      try {
        setConfigState( JSON.parse( config ) )
      } catch ( e ) {
        console.error( e )
      } finally {
        setIsLoading( false )
      }
    }
  }, [config] )

  if ( isLoading ) {
    return (
      <div className="xw-homepage-banner-loading">
        <RefreshIcon className="xw-homepage-banner-refresh-icon xw-homepage-banner-rotating-icon" />
      </div>
    )
  }

  return (
    <>
      {
        !!configState && <HomePageBannerContainer configState={configState} />
      }
    </>
  )
}

export default IndexWidget
