import React from 'react'
import { Swiper, SwiperSlide } from 'swiper/react'
import classNames from 'classnames'
import {
  Autoplay, Navigation, Pagination, Keyboard,
} from 'swiper/modules'

import { ctaAnimations, subTitleAnimations, titleAnimations } from '../constants/animations.js'
import { Button } from '../../common/components/Buttons/Button.js'
import ArrowLeftIcon from '../../assets/icons/left_arrow.svg'
import ArrowRightIcon from '../../assets/icons/right_arrow.svg'
import PlaceholderIcon from '../../assets/icons/placeholder.svg'

export function HomePageBanner( props ) {
  const { handleSlideChange, configState, activeSlide } = props

  return (
    <Swiper
      autoplay={{
        delay: configState.timeout || 3500,
        disableOnInteraction: false,
        pauseOnMouseEnter: true,
      }}
      centeredSlides
      className="xw-homepage-banner-swiper"
      keyboard={{
        enabled: true,
        onlyInViewport: false,
      }}
      modules={[Autoplay, Pagination, Navigation, Keyboard]}
      navigation={{
        nextEl: '.xw-homepage-banner-swiper-button-next',
        prevEl: '.xw-homepage-banner-swiper-button-prev',
      }}
      onSlideChange={handleSlideChange}
      pagination={{
        clickable: true,
      }}
      style={{
      marginBlock: configState.margins,
      '--xw-hb-bannerHeightDesktop': configState.bannerHeightDesktop,
      '--xw-hb-bannerHeightMobile': configState.bannerHeightMobile,
      }}
    >
      {configState.imagesContent.length > 0
        && configState.imagesContent.map( ( imageContent, index ) => (
          <SwiperSlide
            key={index}
          >
            {
              imageContent.image
                ? (
                  <img
                    alt={imageContent.title}
                    className="xw-homepage-banner-slide-image"
                    src={imageContent.image}
                  />
                )
                : <PlaceholderIcon className="xw-homepage-banner-placeholder" height="100%" width="100%" />
            }

            <div
              className={`xw-homepage-banner-slide-content xw-homepage-banner-${imageContent.location} xw-homepage-banner-slide-content-${imageContent?.location?.trim()
                .toLowerCase() || 'middle'}`}
            >
              <p
                className={classNames(
                  'xw-homepage-banner-slide-title',
                  { [`xw-homepage-banner-${titleAnimations[imageContent.animation]}`]: index === activeSlide },
                )}
                style={{ color: imageContent.titleColor }}
              >
                {imageContent.title}
              </p>

              <p
                className={classNames(
                  'xw-homepage-banner-slide-subtext',
                  { [`xw-homepage-banner-${subTitleAnimations[imageContent.animation]}`]: index === activeSlide },
                )}
                style={{ color: imageContent.subtextColor, fontSize: imageContent.subtextSize }}
              >
                {imageContent.subtext}
              </p>

              {
                imageContent.ctaText && (
                  <Button
                    className={classNames(
                      `xw-homepage-banner-slide-button xw-homepage-banner-slide-button-${imageContent.location}`,
                      { [`xw-homepage-banner-${ctaAnimations[imageContent.animation]}`]: index === activeSlide },
                    )}
                    style={{
                      color: imageContent.ctaTextColor,
                      borderColor: imageContent.ctaBorderColor,
                      backgroundColor: imageContent.ctaBGColor,
                    }}
                    to={imageContent.ctaLink}
                  >
                    {imageContent.ctaText}
                  </Button>
                )
              }
            </div>
          </SwiperSlide>
        ))}
      {
        configState.imagesContent.length > 1
        && (
          <>
            <ArrowLeftIcon className="xw-homepage-banner-swiper-button-prev" />
            <ArrowRightIcon className="xw-homepage-banner-swiper-button-next" />
          </>
        )
      }
    </Swiper>
  )
}
