' ====================================================================================
' ================================================================= SMBX 中的 2D 伪阴影实验
' x 中的 2d 光影的实验
' 由于 x 中相关图形接口的匮乏 制作很完美的 2d 光影是非常困难的
' 这里只是针对一个非常特殊的定制场景做光影效果
' 									---- xiaodou 202209
' ====================================================================================
' ================================================================= 变量声明
' ---------------------------------- AABB 框四角及中心点坐标
Dim pA_x As Double
Dim pA_y As Double
Dim pB_x As Double
Dim pB_y As Double
Dim pC_x As Double
Dim pC_y As Double
Dim pD_x As Double
Dim pD_y As Double
Dim pCen_x As Double
Dim pCen_y As Double
Dim picSplit As Double
' ---------------------------------- 阴影定位点坐标
Dim pCornerPoint_x As Double
Dim pCornerPoint_y As Double
Dim vAxis_x As Double
Dim vAxis_y As Double
Dim i As Integer
Dim inHorPos As Integer
Dim inVerPos As Integer
' ---------------------------------- 距离参数
Dim diameter As Double
Dim dA As Double
Dim dB As Double
Dim dC As Double
Dim dD As Double
Dim dCen As Double
' ---------------------------------- 阴影夹角和始长计算的中间量
Dim vProj_x As Double
Dim vProj_y As Double
Dim vProj2_x As Double
Dim vProj2_y As Double
Dim dProj2 As Double
Dim dProj As Double
Dim dAxis As Double
Dim dCPL As Double
Dim vNorCPL_x As Double
Dim vNorCPL_y As Double
Dim dPStartFac As Double
Dim pStart_x As Double
Dim pStart_y As Double
Dim dStart As Double
Dim angle As Double
Dim cosTheta As Double
Dim vStart_dx As Double
Dim vStart_dy As Double
Dim dDStart As Double
' ---------------------------------- id 和 透明度管理
Dim bitmapId As Double
Dim new_x As Double
Dim new_y As Double
Dim new_alpha_x As Double
Dim new_alpha_y As Double
Dim new_alpha_dCPL As Double
Dim new_alpha_bgo As Double
' ---------------------------------- 向量计算方法中使用的中间量
Dim vA_x As Double
Dim vB_x As Double
Dim vA_y As Double
Dim vB_y As Double
Dim norA As Double
Dim norB As Double
Dim disA As Double
Dim disB As Double

' ====================================================================================
' ================================================================= 向量计算的相关方法
' 向量的模
Export Script Shadow2D_CalcNorm(v_x As Double, v_y As Double, Return Double)
    Return Sqr(v_x * v_x + v_y * v_y)
End Script

' 向量的叉积
Export Script Shadow2D_CalcCross(vA_x As Double, vA_y As Double, vB_x As Double, vB_y As Double, Return Double)
    Return vA_x * vB_y - vB_x * vA_y
End Script

' 向量的点积
Export Script Shadow2D_CalcDot(vA_x As Double, vA_y As Double, vB_x As Double, vB_y As Double, Return Double)
    Return vA_x * vB_x + vA_y * vB_y
End Script

' 三点所构成角的角平分线 x
Export Script Shadow2D_CalcAxis_x(pCP_x As Double, pCP_y As Double, pCP2_x As Double, pCP2_y As Double, pL_x As Double, pL_y As Double, Return Double)
    vA_x = pCP_x - pL_x
    vB_x = pCP2_x - pL_x

    norA = Shadow2D_CalcNorm(vA_x, pCP_y - pL_y)
    norB = Shadow2D_CalcNorm(vB_x, pCP2_y - pL_y)

    disA = Abs(norA)
    disB = Abs(norB)

    If disA < 0.0000000000000001 And disB < 0.0000000000000001 Then
        return 0
    ElseIf disA < 0.0000000000000001 Then
        return vB_x / norB
    ElseIf disB < 0.0000000000000001 Then
        return vA_x / norA
    Else
        Return vA_x / norA  + vB_x / norB
    End If
End Script

' 三点所构成角的角平分线 y
Export Script Shadow2D_CalcAxis_y(pCP_x As Double, pCP_y As Double, pCP2_x As Double, pCP2_y As Double, pL_x As Double, pL_y As Double, Return Double)
    vA_y = pCP_y - pL_y
    vB_y = pCP2_y - pL_y

    norA = Shadow2D_CalcNorm(pCP_x - pL_x, vA_y)
    norB = Shadow2D_CalcNorm(pCP2_x - pL_x, vB_y)

    disA = Abs(norA)
    disB = Abs(norB)

    If disA < 0.0000000000000001 And disB < 0.0000000000000001 Then
        return 1
    ElseIf disA < 0.0000000000000001 Then
        return vB_y / norB
    ElseIf disB < 0.0000000000000001 Then
        return vA_y / norA
    Else
        Return vA_y / norA  + vB_y / norB
    End If
End Script

' 计算两向量的逆时针夹角
Export Script Shadow2D_CalcAngle(vA_x As Double, vA_y As Double, vB_x As Double, vB_y As Double, Return Double)
    disA = Shadow2D_CalcDot(vA_x, vA_y, vB_x, vB_y)
    disB = Shadow2D_CalcCross(vA_x, vA_y, vB_x, vB_y) 
    If 0.0000000000000001 > Abs(disA) Then
        If 0 < disB Then
            Return Pi / 2
        Else
            Return -Pi / 2
        End If
    End If
    Return Atn(disB / disA)
End Script

' 计算两点距离
Export Script Shadow2D_CalcDistance(pA_x As Double, pA_y As Double, pB_x As Double, pB_y As Double, Return Double)
    Return Shadow2D_CalcNorm(pA_x - pB_x, pA_y - pB_y)
End Script

' 计算四个值中的最小值
Export Script Shadow2D_CalcMin(x As Double, y As Double, z As Double, w As Double, Return Double)
    If y < x Then
        x = y
    End If

    If w < z Then
        z = w
    End If

    If x < z Then
        Return x
    Else
        Return z
    End If
End Script

' 阈值到 0~1 之间
Export Script Shadow2D_CalcClamp01(x As Double, Return Double)
	If x > 1 Then
		Return 1
	ElseIf x < 0 Then
		Return 0
	End If
	
	Return x
End Script

' ====================================================================================
' ================================================================= 资源管理相关
' 位图唯一 id 的计算方法
' 每个参数都为计算 id 的一部分依据
' @return: 计算结果 id
Script Shadow2D_PRIVATE_BmpId(id As Integer, i As Integer, Return Integer)
    Return id + i*2147000
End Script

' 创建阴影图形对象
' @param id: 索引 id
' @param picId: 阴影横纹采样的目标 npcid
' @param count: 阴影横纹条数 其值不能超过 1000
' @param sampleJump: 采样偏移
' @param height: 单条阴影横纹宽度
Export Script Shadow2D_BmpShadowCreate(id As Integer, picId As Integer, count As Integer, sampleJump As Double, height As Integer)
    If count = 0 Or count > 1000 Then
        Return
    End If

    Call BMPCreate(id, count,   1, 0,   0, 0,   1, 1,   0, 0,   1, 1,   0, 0,   0, -1)
    Bitmap(id).hide = 1
    Bitmap(id).rotatang = 1
    Bitmap(id).desty = height
    Bitmap(id).destx = 0
    Bitmap(id).scrwidth = 0

    For i = 1 To count
        Call BMPCreate(Shadow2D_PRIVATE_BmpId(id, i), picId,   1, 0,   0, i * sampleJump,   1, 1,   0, 0,   height, 1,   0, 0,   0, -1)
    Next
End Script

' 隐藏阴影图形对象
' @param id: 索引 id
Export Script Shadow2D_BmpShadowHide(id As Integer)
    picSplit = Fix(Bitmap(id).scrid)
    For i = 1 To picSplit
        Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
    Next
End Script

' 销毁阴影图形对象
' @param id: 索引 id
Export Script Shadow2D_BmpShadowDestroy(id As Integer)
    picSplit = Fix(Bitmap(id).scrid)
    For i = 0 To picSplit
        Call BErase(2, Shadow2D_PRIVATE_BmpId(id, i))
    Next
End Script

' 该阴影是否在屏幕内显示
' @param pSrcX: 屏幕位置 x 坐标
' @param pSrcY: 屏幕位置 y 坐标
' @param pCenX: 物体中心 x 坐标
' @param pCenY: 物体中心 y 坐标
' @param pLightX: 光源中心 x 坐标
' @param pLightY: 光源中心 y 坐标
' @param dLightRadius: 光源半径
' @return: 当显示阴影时返回 1 否则返回 -1
Export Script Shadow2D_CanShadowInScreen(pScrX As Double, pScrY As Double, pCenX As Double, pCenY As Double, pLightX As Double, pLightY As Double, dLightRadius As Double, Return Integer)
    vA_x = pCenX - pScrX
    vA_y = pCenY - pScrY
    vB_x = pCenX - pLightX
    vB_y = pCenY - pLightY

    If dLightRadius = 0 Then
        Return -1
    End If

    If dLightRadius > 0 Then
        If vA_x > 832 + dLightRadius Or vA_x < - dLightRadius - 32 Or vA_y > 832 + dLightRadius Or vA_y < - dLightRadius - 32 Then
            Return -1
        End If
        If Abs(vB_x) > dLightRadius + 32 Or Abs(vB_y) > dLightRadius + 32 Then
            Return -1
        End If
        Return 1
    End If

    If vA_x > 1600 Or vA_x < -800 Or vA_y > 1600 Or vA_y < -800 Then
        Return -1
    End If

    Return 1
End Script

' ====================================================================================
' ================================================================= 阴影的设置
' 设置阴影的光源
' @param id: 阴影 id
' @param pLightSrc_x: 光源的 x 坐标
' @param pLightSrc_y: 光源的 y 坐标
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetLightPos(id As Integer, pLightSrc_x As Integer, pLightSrc_y As Integer, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).rotatx = pLightSrc_x
        Bitmap(id).rotaty = pLightSrc_y
        Return 1
    End If
    Return -1
End Script

' 设置阴影的碰撞箱
' @param id: 阴影 id
' @param pBox_x: 碰撞箱左上角的 x 坐标
' @param pBox_y: 碰撞箱左上角的 y 坐标
' @param pBox_w: 碰撞箱宽
' @param pBox_h: 碰撞箱高
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetBoxPos(id As Integer, pBox_x As Integer, pBox_y As Integer, pBox_w As Integer, pBox_h As Integer, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).scrx = pBox_x
        Bitmap(id).scry = pBox_y
        Bitmap(id).scalex = pBox_w
        Bitmap(id).scaley = pBox_h
        Return 1
    End If
    Return -1
End Script

' 设置阴影的碰撞箱
' @param id: 阴影 id
' @param pBox_x: 碰撞箱左上角的 x 坐标
' @param pBox_y: 碰撞箱左上角的 y 坐标
' @param radius: 碰撞箱半径: 
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetCircle(id As Integer, pBox_x As Integer, pBox_y As Integer, radius As Integer, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).scrx = pBox_x
        Bitmap(id).scry = pBox_y
        Bitmap(id).scalex = radius
        Bitmap(id).scaley = radius
        Return 1
    End If
    Return -1
End Script

' 设置阴影透明度
' @param id: 阴影 id
' @param alpha: 透明度
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetAlpha(id As Integer, alpha As Double, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).rotatang = alpha
        Return 1
    End If
    Return -1
End Script

' 设置阴影的 zPos
' @param id: 阴影 id
' @param zpos: 阴影的 zpos
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetZpos(id As Integer, zpos As Double, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).zpos = zpos
        Return 1
    End If
    Return -1
End Script

' 设置阴影的间距
' @param id: 阴影 id
' @param spacingFac: 阴影横纹间距
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetSpacing(id As Integer, spacingFac As Double, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).desty = spacingFac
        Return 1
    End If
    Return -1
End Script

' 设置阴影衰减参数
' @param id: 阴影 id
' @param attenuateStart: 开始衰减半径
' @param attenuateFac: 衰减速度因子
' @return: 1·设置成功 -1·设置不成功
Export Script Shadow2D_SetAtten(id As Integer, attenuateStart As Double, attenuateFac As Double, Return Integer)
    If Fix(Bitmap(id).scrid) > 0 Then
        Bitmap(id).scrwidth = attenuateStart
        Bitmap(id).destx = attenuateFac
        Return 1
    End If
    Return -1
End Script

' ====================================================================================
' ================================================================= 阴影刷新相关方法
' 碰撞箱为 AABB 矩形的 2D 阴影的刷新
' @param id: 索引 id
' @return: 当前阴影透明度 (不受阴影透明度乘数影响的原始值)
Export Script Shadow2D_AABBRectRefresh(id As Integer, Return Double)
    ' ====================================================================================
    ' ================================================================= 第〇部分: 变量载入
    If Fix(Bitmap(id).scrid) <= 0 Then
        Return 1
    End If
    Dim pBox_x As Double = Bitmap(id).destx
    Dim pBox_y As Double = Bitmap(id).desty
    Dim box_w As Double = Bitmap(id).scalex
    Dim box_h As Double = Bitmap(id).scaley
    Dim pLightSrc_x As Double = Bitmap(id).rotatx
    Dim pLightSrc_y As Double = Bitmap(id).rotaty
    Dim alpha As Double = Bitmap(id).rotatang
    Dim zpos As Double = Bitmap(id).zpos
    Dim spacingFac As Integer = Bitmap(id).scrx
    picSplit = Fix(Bitmap(id).scrid)

    ' ====================================================================================
    ' ================================================================= 第一部分: 状态分析
    ' ---------------------------------- 状态定义:
    pCornerPoint_x  = 0
    pCornerPoint_y = 0
    vAxis_x = 0
    vAxis_y = 0

    ' ---------------------------------- 判断条件:
    '   对于 2d 的 AABB 矩形框来说 一共有 11 个不同的投影状态 这里粗糙地采用 D2Q9 的方式划分
    '   矩形四个角点的坐标和中点坐标:
    pA_x = pBox_x
    pA_y = pBox_y
    pB_x = pBox_x + box_w
    pB_y = pBox_y
    pC_x = pBox_x + box_w
    pC_y = pBox_y + box_h
    pD_x = pBox_x
    pD_y = pBox_y + box_h
    pCen_x = pBox_x + (box_w * 0.5)
    pCen_y = pBox_y + (box_h * 0.5)
	diameter = Shadow2D_CalcNorm(box_w, box_h)
	
    ' ---------------------------------- 光源与矩形框相对位置分析:
    inHorPos = 0
    inVerPos = 0
    ' 与矩形框的水平相对位置: 1 0 3
    If pLightSrc_x > pB_x Then
        inHorPos = 3
    ElseIf pLightSrc_x < pA_x Then
        inHorPos = 1
    End If
    ' 与矩形框的垂直相对位置: 3 0 1
    If pLightSrc_y > pD_y Then
        inVerPos = 3
    ElseIf pLightSrc_y < pA_y Then
        inVerPos = 1
    End If

    ' ---------------------------------- 状态分析:
    ' 状态分析这里分为 11 种情况
    ' ----------------
    ' 在角落的情况:
    If 1 = inHorPos And 3 = inVerPos Then
        ' AC/C
        vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pC_x
        pCornerPoint_y = pC_y
    ElseIf 1 = inHorPos And 1 = inVerPos Then
        ' BD/D
        vAxis_x = Shadow2D_CalcAxis_x(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pD_x
        pCornerPoint_y = pD_y
    ElseIf 3 = inHorPos And 1 = inVerPos Then
        ' AC/C
        vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pC_x
        pCornerPoint_y = pC_y
    ElseIf inHorPos = 3 And inVerPos = 3 Then
        ' BD/D
        vAxis_x = Shadow2D_CalcAxis_x(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pD_x
        pCornerPoint_y = pD_y

    ' ----------------
    ' 在边缘的情况:
    ElseIf 0 = inHorPos And 0 <> inVerPos Then
        If inVerPos = 3 Then
            ' DC
            vAxis_x = Shadow2D_CalcAxis_x(pD_x, pD_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pD_x, pD_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            If pLightSrc_x < pCen_x Then
                ' C
                pCornerPoint_x = pC_x
                pCornerPoint_y = pC_y
            Else
                ' D
                pCornerPoint_x = pD_x
                pCornerPoint_y = pD_y
            End If
        Else
            ' AB
            vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pB_x, pB_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pB_x, pB_y, pLightSrc_x, pLightSrc_y)
            If pLightSrc_x < pCen_x Then
                ' B
                pCornerPoint_x = pA_x
                pCornerPoint_y = pA_y
            Else
                ' A
                pCornerPoint_x = pB_x
                pCornerPoint_y = pB_y
            End If
        End If
    ElseIf 0 = inVerPos And 0 <> inHorPos Then
        If inHorPos = 3 Then
            ' BC/C
            vAxis_x = Shadow2D_CalcAxis_x(pB_x, pB_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pB_x, pB_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            pCornerPoint_x = pC_x
            pCornerPoint_y = pC_y
        Else
            ' AD/D
            vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
            pCornerPoint_x = pD_x
            pCornerPoint_y = pD_y
        End If
        ' ----------------
    ' 在内部的情况
    Else
		For i = 1 To picSplit
			Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
		Next
		dA = Shadow2D_CalcDistance(pA_x, pA_y, pLightSrc_x, pLightSrc_y)
		dB = Shadow2D_CalcDistance(pB_x, pB_y, pLightSrc_x, pLightSrc_y)
		dC = Shadow2D_CalcDistance(pC_x, pC_y, pLightSrc_x, pLightSrc_y)
		dD = Shadow2D_CalcDistance(pD_x, pD_y, pLightSrc_x, pLightSrc_y)
		dCen = Shadow2D_CalcDistance(pCen_x, pCen_y, pLightSrc_x, pLightSrc_y)
		dA = Shadow2D_CalcMin(dA, dB, dC, dD)
		
		If dCen < dA Then
			dA = dCen
		End If

		If dA < (diameter * 1.4) Then
			Return dA / (diameter * 1.4)
		End If

		Return 1
    End If

    ' ====================================================================================
    ' ================================================================= 第二部分: 阴影生成
    ' ---------------------------------- 数据准备:
    ' 归一化中轴线
    dAxis = Shadow2D_CalcNorm(vAxis_x, vAxis_y)
    If 0.0000000000000001 < Abs(dAxis) Then
        vAxis_x = vAxis_x / dAxis
        vAxis_y = vAxis_y / dAxis
    Else
        vAxis_x = 0
        vAxis_y = 1
    End If

    ' 计算中点-光源向量到中轴的投影 vProj 和 角点-光源向量到中轴的投影 vProj2
    vProj_x = (pCen_x - pLightSrc_x) * vAxis_x * vAxis_x + (pCen_y - pLightSrc_y) * vAxis_y * vAxis_x
    vProj_y = (pCen_y - pLightSrc_y) * vAxis_y * vAxis_y + (pCen_x - pLightSrc_x) * vAxis_x * vAxis_y

    vProj2_x = (pCornerPoint_x - pLightSrc_x) * vAxis_x * vAxis_x + (pCornerPoint_y - pLightSrc_y) * vAxis_y * vAxis_x
    vProj2_y = (pCornerPoint_y - pLightSrc_y) * vAxis_y * vAxis_y + (pCornerPoint_x - pLightSrc_x) * vAxis_x * vAxis_y

    dProj2 = Shadow2D_CalcNorm(vProj2_x, vProj2_y)
    dProj = Shadow2D_CalcNorm(vProj_x, vProj_y)

    ' 计算角点-光源向量的单位向量
    dCPL = Shadow2D_CalcNorm(pCornerPoint_x - pLightSrc_x, pCornerPoint_y - pLightSrc_y)
    vNorCPL_x = 0
    vNorCPL_y = 1
    If Abs(dCPL) > 0.0000000000000001 Then
        vNorCPL_x = (pCornerPoint_x - pLightSrc_x) / dCPL
        vNorCPL_y = (pCornerPoint_y - pLightSrc_y) / dCPL
    End If

    dPStartFac = 1
    If Abs(dProj2) > 0.0000000000000001 Then
        dPStartFac = dCPL * dProj / dProj2
    End If

    ' 计算阴影始点和始长
    '   始长是角点-光源向量的模平方减去始点-光源向量的模平方开根号后取两倍
    pStart_x = pLightSrc_x + vNorCPL_x * dPStartFac
    pStart_y = pLightSrc_y + vNorCPL_y * dPStartFac
    dStart = Sqr(dPStartFac * dPStartFac - dProj * dProj) * 2

    ' 计算偏转角度
    angle = Shadow2D_CalcAngle(vAxis_x, vAxis_y, 1, 0)

    ' 计算变位和变长
    cosTheta = Shadow2D_CalcDot(vNorCPL_x, vNorCPL_y, vAxis_x, vAxis_y)
    If Abs(cosTheta) < 0.0000000000000001 Then
        cosTheta = 1
    End If
    vStart_dx = (spacingFac / cosTheta) * vNorCPL_x 
    vStart_dy = (spacingFac / cosTheta) * vNorCPL_y
    dDStart = 0

    If 0.0000000000000001 < Abs(dProj) Then
        dDStart = spacingFac * dStart / dProj
    End If

    ' ---------------------------------- 绘制阴影:
    ' 绘制阴影
    new_x = 0
    new_y = 0
    new_alpha_x = 1
    new_alpha_y = 1
    new_alpha_dCPL = 1
    new_alpha_bgo = 0

    dA = Shadow2D_CalcDistance(pA_x, pA_y, pLightSrc_x, pLightSrc_y)
    dB = Shadow2D_CalcDistance(pB_x, pB_y, pLightSrc_x, pLightSrc_y)
    dC = Shadow2D_CalcDistance(pC_x, pC_y, pLightSrc_x, pLightSrc_y)
    dD = Shadow2D_CalcDistance(pD_x, pD_y, pLightSrc_x, pLightSrc_y)
	dCen = Shadow2D_CalcDistance(pCen_x, pCen_y, pLightSrc_x, pLightSrc_y)
    dA = Shadow2D_CalcMin(dA, dB, dC, dD)
	
	If dCen < dA Then
		dA = dCen
	End If

    If dA < (diameter * 1.4) Then
        new_alpha_dCPL = dA / (diameter * 1.4)
    End If

    new_alpha_bgo = Shadow2D_CalcClamp01(new_alpha_dCPL * 2)
	
    For i = 1 To picSplit
		new_x = pStart_x + i * vStart_dx
		new_y = pStart_y + i * vStart_dy
		new_alpha_x = 1
		new_alpha_y = 1

		If new_x < 200 Then
			new_alpha_x = new_x / 200
		ElseIf new_x > 600 Then
			new_alpha_x = (800 - new_x) / 200
		End If

		If new_y < 200 Then
			new_alpha_y = new_y / 200
		ElseIf new_y > 400 Then
			new_alpha_y = (600 - new_y) / 200
		End If

		new_alpha_x = Shadow2D_CalcClamp01(new_alpha_x)
		new_alpha_y = Shadow2D_CalcClamp01(new_alpha_y)
		
		bitmapId = Shadow2D_PRIVATE_BmpId(id, i)
		Bitmap(bitmapId).hide = 0
		Bitmap(bitmapId).rotatang = angle + Pi
		Bitmap(bitmapId).attscreen = 1
		Bitmap(bitmapId).destx = new_x
		Bitmap(bitmapId).desty = new_y
		Bitmap(bitmapId).forecolor_a = alpha * new_alpha_dCPL * new_alpha_x * new_alpha_y * 255
		Bitmap(bitmapId).scaley = dStart + i * dDStart
		Bitmap(bitmapId).zpos = zpos
    Next
	
	Return new_alpha_bgo
End Script

' 碰撞箱为圆形的 2D 阴影的刷新
' @param id: 索引 id
' @return: 当前阴影透明度 (不受阴影透明度乘数影响的原始值)
Export Script Shadow2D_HalfCircleRefresh(id As Integer, Return Double)
    ' ====================================================================================
    ' ================================================================= 第〇部分: 变量载入
    If Fix(Bitmap(id).scrid) <= 0 Then
        Return 1
    End If
    Dim pBox_x As Double = Bitmap(id).destx
    Dim pBox_y As Double = Bitmap(id).desty
    Dim radius As Double = Abs(Bitmap(id).scalex / 2)
    Dim pLightSrc_x As Double = Bitmap(id).rotatx
    Dim pLightSrc_y As Double = Bitmap(id).rotaty
    Dim alpha As Double = Bitmap(id).rotatang
    Dim zpos As Double = Bitmap(id).zpos
    Dim spacingFac As Integer = Bitmap(id).scrx
    picSplit = Fix(Bitmap(id).scrid)

    If radius < 0.0000000000000001 Then
        For i = 1 To picSplit
            Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
        Next
        Return 1
    End If

    ' ====================================================================================
    ' ================================================================= 第一部分: 状态分析
    ' ---------------------------------- 状态定义:
    vAxis_x = pBox_x + radius - pLightSrc_x
    vAxis_y = pBox_y + radius - pLightSrc_y
    dAxis = Shadow2D_CalcNorm(vAxis_x, vAxis_y)
    If dAxis < radius * 0.66 Then
        For i = 1 To picSplit
            Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
        Next
        Return 0
    End If

    ' 归一化中轴线
    vAxis_x = vAxis_x / dAxis
    vAxis_y = vAxis_y / dAxis

    If vAxis_x < 0 Then
        i = 1
    Else
        i = -1
    End If

    pCornerPoint_x = i * vAxis_y * radius + pBox_x + radius
    pCornerPoint_y = -i *vAxis_x * radius + pBox_y + radius

    ' ====================================================================================
    ' ================================================================= 第二部分: 阴影生成
    ' ---------------------------------- 数据准备:
    ' 计算角点-光源向量的单位向量
    dCPL = Shadow2D_CalcNorm(pCornerPoint_x - pLightSrc_x, pCornerPoint_y - pLightSrc_y)
    vNorCPL_x = 0
    vNorCPL_y = 1
    If Abs(dCPL) > 0.0000000000000001 Then
        vNorCPL_x = (pCornerPoint_x - pLightSrc_x) / dCPL
        vNorCPL_y = (pCornerPoint_y - pLightSrc_y) / dCPL
    End If

    ' 计算阴影始点和始长
    '   始长是角点-光源向量的模平方减去始点-光源向量的模平方开根号后取两倍
    pStart_x = pLightSrc_x + vNorCPL_x * dCPL
    pStart_y = pLightSrc_y + vNorCPL_y * dCPL
    dStart = Sqr(dCPL * dCPL - dAxis * dAxis) * 2

    ' 计算偏转角度
    angle = Shadow2D_CalcAngle(vAxis_x, vAxis_y, 1, 0)

    ' 计算变位和变长
    cosTheta = Shadow2D_CalcDot(vNorCPL_x, vNorCPL_y, vAxis_x, vAxis_y)
    If Abs(cosTheta) < 0.0000000000000001 Then
        cosTheta = 1
    End If
    vStart_dx = (spacingFac / cosTheta) * vNorCPL_x 
    vStart_dy = (spacingFac / cosTheta) * vNorCPL_y
    dDStart = spacingFac * dStart / dAxis

    ' ---------------------------------- 绘制阴影:
    ' 绘制阴影
    new_x = 0
    new_y = 0
    new_alpha_x = 1
    new_alpha_y = 1
    new_alpha_dCPL = 1
    new_alpha_bgo = 0

    If dAxis <= (radius * 6.66) Then
        new_alpha_dCPL = dAxis / (radius * 6.66)
    End If

    new_alpha_bgo = Shadow2D_CalcClamp01(new_alpha_dCPL * 2)
	
    For i = 1 To picSplit
		new_x = pStart_x + i * vStart_dx
		new_y = pStart_y + i * vStart_dy
		new_alpha_x = 1
		new_alpha_y = 1

		If new_x < 200 Then
			new_alpha_x = new_x / 200
		ElseIf new_x > 600 Then
			new_alpha_x = (800 - new_x) / 200
		End If

		If new_y < 200 Then
			new_alpha_y = new_y / 200
		ElseIf new_y > 400 Then
			new_alpha_y = (600 - new_y) / 200
		End If

		new_alpha_x = Shadow2D_CalcClamp01(new_alpha_x)
		new_alpha_y = Shadow2D_CalcClamp01(new_alpha_y)
		
		bitmapId = Shadow2D_PRIVATE_BmpId(id, i)
		Bitmap(bitmapId).hide = 0
		Bitmap(bitmapId).rotatang = angle + Pi
		Bitmap(bitmapId).attscreen = 1
		Bitmap(bitmapId).destx = new_x
		Bitmap(bitmapId).desty = new_y
		Bitmap(bitmapId).forecolor_a = alpha * new_alpha_dCPL * new_alpha_x * new_alpha_y * 255
		Bitmap(bitmapId).scaley = dStart + i * dDStart
		Bitmap(bitmapId).zpos = zpos
    Next
	
	Return new_alpha_bgo
End Script

' 碰撞箱为 AABB 矩形的 2D 阴影 (带衰减) 的刷新
' @param id: 索引 id
' @return: 当前阴影透明度 (不受阴影透明度乘数影响的原始值) 若返回值小于 -1 则说明当前阴影在光源范围外
Export Script Shadow2D_AABBRect_WithAttenRefresh(id As Integer, Return Double)
    ' ====================================================================================
    ' ================================================================= 第〇部分: 变量载入
    If Fix(Bitmap(id).scrid) <= 0 Then
        Return 1
    End If
    Dim pBox_x As Double = Bitmap(id).scrx
    Dim pBox_y As Double = Bitmap(id).scry
    Dim box_w As Double = Bitmap(id).scalex
    Dim box_h As Double = Bitmap(id).scaley
    Dim pLightSrc_x As Double = Bitmap(id).rotatx
    Dim pLightSrc_y As Double = Bitmap(id).rotaty
    Dim alpha As Double = Bitmap(id).rotatang
    Dim zpos As Double = Bitmap(id).zpos
    Dim spacingFac As Integer = Bitmap(id).desty
    Dim attenuateStart As Double = Bitmap(id).scrwidth
    Dim attenuateFac As Double = Bitmap(id).destx
    picSplit = Fix(Bitmap(id).scrid)

    ' ====================================================================================
    ' ================================================================= 第一部分: 状态分析
    ' ---------------------------------- 状态定义:
    pCornerPoint_x = 0
    pCornerPoint_y = 0
    vAxis_x = 0
    vAxis_y = 0

    ' ---------------------------------- 判断条件:
    '   对于 2d 的 AABB 矩形框来说 一共有 11 个不同的投影状态 这里粗糙地采用 D2Q9 的方式划分
    '   矩形四个角点的坐标和中点坐标:
    pA_x = pBox_x
    pA_y = pBox_y
    pB_x = pBox_x + box_w
    pB_y = pBox_y
    pC_x = pBox_x + box_w
    pC_y = pBox_y + box_h
    pD_x = pBox_x
    pD_y = pBox_y + box_h
    pCen_x = pBox_x + (box_w * 0.5)
    pCen_y = pBox_y + (box_h * 0.5)
	diameter = Shadow2D_CalcNorm(box_w, box_h)
	
    ' ---------------------------------- 光源与矩形框相对位置分析:
    inHorPos = 0
    inVerPos = 0
    ' 与矩形框的水平相对位置: 1 0 3
    If pLightSrc_x > pB_x Then
        inHorPos = 3
    ElseIf pLightSrc_x < pA_x Then
        inHorPos = 1
    End If
    ' 与矩形框的垂直相对位置: 3 0 1
    If pLightSrc_y > pD_y Then
        inVerPos = 3
    ElseIf pLightSrc_y < pA_y Then
        inVerPos = 1
    End If

    ' ---------------------------------- 状态分析:
    ' 状态分析这里分为 11 种情况
    ' ----------------
    ' 在角落的情况:
    If 1 = inHorPos And 3 = inVerPos Then
        ' AC/C
        vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pC_x
        pCornerPoint_y = pC_y
    ElseIf 1 = inHorPos And 1 = inVerPos Then
        ' BD/D
        vAxis_x = Shadow2D_CalcAxis_x(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pD_x
        pCornerPoint_y = pD_y
    ElseIf 3 = inHorPos And 1 = inVerPos Then
        ' AC/C
        vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pC_x
        pCornerPoint_y = pC_y
    ElseIf inHorPos = 3 And inVerPos = 3 Then
        ' BD/D
        vAxis_x = Shadow2D_CalcAxis_x(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        vAxis_y = Shadow2D_CalcAxis_y(pB_x, pB_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
        pCornerPoint_x = pD_x
        pCornerPoint_y = pD_y

    ' ----------------
    ' 在边缘的情况:
    ElseIf 0 = inHorPos And 0 <> inVerPos Then
        If inVerPos = 3 Then
            ' DC
            vAxis_x = Shadow2D_CalcAxis_x(pD_x, pD_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pD_x, pD_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            If pLightSrc_x < pCen_x Then
                ' C
                pCornerPoint_x = pC_x
                pCornerPoint_y = pC_y
            Else
                ' D
                pCornerPoint_x = pD_x
                pCornerPoint_y = pD_y
            End If
        Else
            ' AB
            vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pB_x, pB_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pB_x, pB_y, pLightSrc_x, pLightSrc_y)
            If pLightSrc_x < pCen_x Then
                ' B
                pCornerPoint_x = pA_x
                pCornerPoint_y = pA_y
            Else
                ' A
                pCornerPoint_x = pB_x
                pCornerPoint_y = pB_y
            End If
        End If
    ElseIf 0 = inVerPos And 0 <> inHorPos Then
        If inHorPos = 3 Then
            ' BC/C
            vAxis_x = Shadow2D_CalcAxis_x(pB_x, pB_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pB_x, pB_y, pC_x, pC_y, pLightSrc_x, pLightSrc_y)
            pCornerPoint_x = pC_x
            pCornerPoint_y = pC_y
        Else
            ' AD/D
            vAxis_x = Shadow2D_CalcAxis_x(pA_x, pA_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
            vAxis_y = Shadow2D_CalcAxis_y(pA_x, pA_y, pD_x, pD_y, pLightSrc_x, pLightSrc_y)
            pCornerPoint_x = pD_x
            pCornerPoint_y = pD_y
        End If
        ' ----------------
    ' 在内部的情况
    Else
		For i = 1 To picSplit
			Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
		Next
		dA = Shadow2D_CalcDistance(pA_x, pA_y, pLightSrc_x, pLightSrc_y)
		dB = Shadow2D_CalcDistance(pB_x, pB_y, pLightSrc_x, pLightSrc_y)
		dC = Shadow2D_CalcDistance(pC_x, pC_y, pLightSrc_x, pLightSrc_y)
		dD = Shadow2D_CalcDistance(pD_x, pD_y, pLightSrc_x, pLightSrc_y)
		dCen = Shadow2D_CalcDistance(pCen_x, pCen_y, pLightSrc_x, pLightSrc_y)
		dA = Shadow2D_CalcMin(dA, dB, dC, dD)
		
		If dCen < dA Then
			dA = dCen
		End If

		If dA < (diameter * 1.4) Then
			Return dA / (diameter * 1.4)
		End If

		Return 1
    End If

    ' ====================================================================================
    ' ================================================================= 第二部分: 阴影生成
    ' ---------------------------------- 数据准备:
    ' 归一化中轴线
    dAxis = Shadow2D_CalcNorm(vAxis_x, vAxis_y)
    If 0.0000000000000001 < Abs(dAxis) Then
        vAxis_x = vAxis_x / dAxis
        vAxis_y = vAxis_y / dAxis
    Else
        vAxis_x = 0
        vAxis_y = 1
    End If

    ' 计算中点-光源向量到中轴的投影 vProj 和 角点-光源向量到中轴的投影 vProj2
    vProj_x = (pCen_x - pLightSrc_x) * vAxis_x * vAxis_x + (pCen_y - pLightSrc_y) * vAxis_y * vAxis_x
    vProj_y = (pCen_y - pLightSrc_y) * vAxis_y * vAxis_y + (pCen_x - pLightSrc_x) * vAxis_x * vAxis_y

    vProj2_x = (pCornerPoint_x - pLightSrc_x) * vAxis_x * vAxis_x + (pCornerPoint_y - pLightSrc_y) * vAxis_y * vAxis_x
    vProj2_y = (pCornerPoint_y - pLightSrc_y) * vAxis_y * vAxis_y + (pCornerPoint_x - pLightSrc_x) * vAxis_x * vAxis_y

    dProj2 = Shadow2D_CalcNorm(vProj2_x, vProj2_y)
    dProj = Shadow2D_CalcNorm(vProj_x, vProj_y)

    ' 计算角点-光源向量的单位向量
    dCPL = Shadow2D_CalcNorm(pCornerPoint_x - pLightSrc_x, pCornerPoint_y - pLightSrc_y)
    vNorCPL_x = 0
    vNorCPL_y = 1
    If Abs(dCPL) > 0.0000000000000001 Then
        vNorCPL_x = (pCornerPoint_x - pLightSrc_x) / dCPL
        vNorCPL_y = (pCornerPoint_y - pLightSrc_y) / dCPL
    End If

    dPStartFac = 1
    If Abs(dProj2) > 0.0000000000000001 Then
        dPStartFac = dCPL * dProj / dProj2
    End If

    ' 计算阴影始点和始长
    '   始长是角点-光源向量的模平方减去始点-光源向量的模平方开根号后取两倍
    pStart_x = pLightSrc_x + vNorCPL_x * dPStartFac
    pStart_y = pLightSrc_y + vNorCPL_y * dPStartFac
    dStart = Sqr(dPStartFac * dPStartFac - dProj * dProj) * 2

    ' 计算偏转角度
    angle = Shadow2D_CalcAngle(vAxis_x, vAxis_y, 1, 0)

    ' 计算变位和变长
    cosTheta = Shadow2D_CalcDot(vNorCPL_x, vNorCPL_y, vAxis_x, vAxis_y)
    If Abs(cosTheta) < 0.0000000000000001 Then
        cosTheta = 1
    End If
    vStart_dx = (spacingFac / cosTheta) * vNorCPL_x 
    vStart_dy = (spacingFac / cosTheta) * vNorCPL_y
    dDStart = 0

    If 0.0000000000000001 < Abs(dProj) Then
        dDStart = spacingFac * dStart / dProj
    End If

    ' ---------------------------------- 绘制阴影:
    ' 绘制阴影
    new_x = 0
    new_y = 0
    new_alpha_x = 1
    new_alpha_y = 1
    new_alpha_dCPL = 1
    new_alpha_bgo = 0

    dA = Shadow2D_CalcDistance(pA_x, pA_y, pLightSrc_x, pLightSrc_y)
    dB = Shadow2D_CalcDistance(pB_x, pB_y, pLightSrc_x, pLightSrc_y)
    dC = Shadow2D_CalcDistance(pC_x, pC_y, pLightSrc_x, pLightSrc_y)
    dD = Shadow2D_CalcDistance(pD_x, pD_y, pLightSrc_x, pLightSrc_y)
	dCen = Shadow2D_CalcDistance(pCen_x, pCen_y, pLightSrc_x, pLightSrc_y)
    dA = Shadow2D_CalcMin(dA, dB, dC, dD)
	
	If dCen < dA Then
		dA = dCen
	End If

    If dA < (diameter * 1.4) Then
        new_alpha_dCPL = dA / (diameter * 1.4)
    End If

    new_alpha_bgo = Shadow2D_CalcClamp01(new_alpha_dCPL * 2)
	
    For i = 1 To picSplit
		new_x = pStart_x + i * vStart_dx
		new_y = pStart_y + i * vStart_dy
		new_alpha_x = 1
		new_alpha_y = 1

		If new_x < 200 Then
			new_alpha_x = new_x / 200
		ElseIf new_x > 600 Then
			new_alpha_x = (800 - new_x) / 200
		End If

		If new_y < 200 Then
			new_alpha_y = new_y / 200
		ElseIf new_y > 400 Then
			new_alpha_y = (600 - new_y) / 200
		End If

        dCen = -attenuateFac * (spacingFac * i + dProj - attenuateStart) 
        dCen = Shadow2D_CalcClamp01(1 + dCen)

        If i = 0 And dCen < 0.0000000000000001 Then
            For i = 1 To picSplit
                Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
            Next
            Return -10
        End If

		new_alpha_x = Shadow2D_CalcClamp01(new_alpha_x)
		new_alpha_y = Shadow2D_CalcClamp01(new_alpha_y)
		
		bitmapId = Shadow2D_PRIVATE_BmpId(id, i)
		Bitmap(bitmapId).hide = 0
		Bitmap(bitmapId).rotatang = angle + Pi
		Bitmap(bitmapId).attscreen = 1
		Bitmap(bitmapId).destx = new_x
		Bitmap(bitmapId).desty = new_y
		Bitmap(bitmapId).forecolor_a = alpha * new_alpha_dCPL * new_alpha_x * new_alpha_y * dCen * 255
		Bitmap(bitmapId).scaley = dStart + i * dDStart
		Bitmap(bitmapId).zpos = zpos
    Next

	Return new_alpha_bgo
End Script

' 碰撞箱为圆形的 2D 阴影 (带衰减) 的刷新
' @param id: 索引 id
' @return: 当前阴影透明度 (不受阴影透明度乘数影响的原始值) 若返回值小于 -1 则说明当前阴影在光源范围外
Export Script Shadow2D_HalfCircle_WithAttenRefresh(id As Integer, Return Double)
    ' ====================================================================================
    ' ================================================================= 第〇部分: 变量载入
    If Fix(Bitmap(id).scrid) <= 0 Then
        Return 1
    End If
    Dim pBox_x As Double = Bitmap(id).destx
    Dim pBox_y As Double = Bitmap(id).desty
    Dim radius As Double = Abs(Bitmap(id).scalex / 2)
    Dim pLightSrc_x As Double = Bitmap(id).rotatx
    Dim pLightSrc_y As Double = Bitmap(id).rotaty
    Dim alpha As Double = Bitmap(id).rotatang
    Dim zpos As Double = Bitmap(id).zpos
    Dim spacingFac As Integer = Bitmap(id).scrx
    Dim attenuateStart As Double = Bitmap(id).scry
    Dim attenuateFac As Double = Bitmap(id).scrwidth
    picSplit = Fix(Bitmap(id).scrid)

    radius = Abs(radius)
    If radius < 0.0000000000000001 Then
        For i = 1 To picSplit
            Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
        Next
        Return 1
    End If
    ' ====================================================================================
    ' ================================================================= 第一部分: 状态分析
    ' ---------------------------------- 状态定义:
    vAxis_x = pBox_x + radius - pLightSrc_x
    vAxis_y = pBox_y + radius - pLightSrc_y
    dAxis = Shadow2D_CalcNorm(vAxis_x, vAxis_y)
    If dAxis < radius * 0.66 Then
        For i = 1 To picSplit
            Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
        Next
        Return 0
    End If

    ' 归一化中轴线
    vAxis_x = vAxis_x / dAxis
    vAxis_y = vAxis_y / dAxis

    If vAxis_x < 0 Then
        i = 1
    Else
        i = -1
    End If

    pCornerPoint_x = i * vAxis_y * radius + pBox_x + radius
    pCornerPoint_y = -i *vAxis_x * radius + pBox_y + radius

    ' ====================================================================================
    ' ================================================================= 第二部分: 阴影生成
    ' ---------------------------------- 数据准备:
    ' 计算角点-光源向量的单位向量
    dCPL = Shadow2D_CalcNorm(pCornerPoint_x - pLightSrc_x, pCornerPoint_y - pLightSrc_y)
    vNorCPL_x = 0
    vNorCPL_y = 1
    If Abs(dCPL) > 0.0000000000000001 Then
        vNorCPL_x = (pCornerPoint_x - pLightSrc_x) / dCPL
        vNorCPL_y = (pCornerPoint_y - pLightSrc_y) / dCPL
    End If

    ' 计算阴影始点和始长
    '   始长是角点-光源向量的模平方减去始点-光源向量的模平方开根号后取两倍
    pStart_x = pLightSrc_x + vNorCPL_x * dCPL
    pStart_y = pLightSrc_y + vNorCPL_y * dCPL
    dStart = Sqr(dCPL * dCPL - dAxis * dAxis) * 2

    ' 计算偏转角度
    angle = Shadow2D_CalcAngle(vAxis_x, vAxis_y, 1, 0)

    ' 计算变位和变长
    cosTheta = Shadow2D_CalcDot(vNorCPL_x, vNorCPL_y, vAxis_x, vAxis_y)
    If Abs(cosTheta) < 0.0000000000000001 Then
        cosTheta = 1
    End If
    vStart_dx = (spacingFac / cosTheta) * vNorCPL_x 
    vStart_dy = (spacingFac / cosTheta) * vNorCPL_y
    dDStart = spacingFac * dStart / dAxis

    ' ---------------------------------- 绘制阴影:
    ' 绘制阴影
    new_x = 0
    new_y = 0
    new_alpha_x = 1
    new_alpha_y = 1
    new_alpha_dCPL = 1
    new_alpha_bgo = 0

    If dAxis <= (radius * 6.66) Then
        new_alpha_dCPL = dAxis / (radius * 6.66)
    End If

    new_alpha_bgo = Shadow2D_CalcClamp01(new_alpha_dCPL * 2)
	
    For i = 1 To picSplit
		new_x = pStart_x + i * vStart_dx
		new_y = pStart_y + i * vStart_dy
		new_alpha_x = 1
		new_alpha_y = 1

		If new_x < 200 Then
			new_alpha_x = new_x / 200
		ElseIf new_x > 600 Then
			new_alpha_x = (800 - new_x) / 200
		End If

		If new_y < 200 Then
			new_alpha_y = new_y / 200
		ElseIf new_y > 400 Then
			new_alpha_y = (600 - new_y) / 200
		End If

        dAxis = -attenuateFac * (spacingFac * i + dAxis - attenuateStart) 
        dAxis = Shadow2D_CalcClamp01(1 + dAxis)

        If i = 0 And dAxis < 0.0000000000000001 Then
            For i = 1 To picSplit
                Bitmap(Shadow2D_PRIVATE_BmpId(id, i)).hide = 1
            Next
            Return -10
        End If

		new_alpha_x = Shadow2D_CalcClamp01(new_alpha_x)
		new_alpha_y = Shadow2D_CalcClamp01(new_alpha_y)
		
		bitmapId = Shadow2D_PRIVATE_BmpId(id, i)
		Bitmap(bitmapId).hide = 0
		Bitmap(bitmapId).rotatang = angle + Pi
		Bitmap(bitmapId).attscreen = 1
		Bitmap(bitmapId).destx = new_x
		Bitmap(bitmapId).desty = new_y
		Bitmap(bitmapId).forecolor_a = alpha * new_alpha_dCPL * new_alpha_x * new_alpha_y * dAxis * 255
		Bitmap(bitmapId).scaley = dStart + i * dDStart
		Bitmap(bitmapId).zpos = zpos
    Next
	
	Return new_alpha_bgo
End Script
' ====================================================================================