<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/3/9
 * Time: 18:14
 */

namespace CHV;

class Imagecensor extends AipBase
{
    private $imageCensorUserDefinedUrl = 'https://aip.baidubce.com/rest/2.0/solution/v1/img_censor/v2/user_defined';

    public function __construct()
    {
        parent::__construct(Settings::get("baidu_app_id"), Settings::get("baidu_app_key"), Settings::get("baidu_app_secret"));
    }

    /**
     * @param  string $image 图像
     * @return array
     */
    public function imageCensorUserDefined($image)
    {

        $data = array();
        $isUrl = substr(trim($image), 0, 4) === 'http';
        if (!$isUrl) {
            $data['image'] = base64_encode($image);
        } else {
            $data['imgUrl'] = $image;
        }

        return $this->request($this->imageCensorUserDefinedUrl, $data);
    }
}