/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.pathing.goals;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.pathing.goals.GoalYLevel;
import baritone.api.utils.SettingsUtil;
import java.util.Arrays;
import net.minecraft.util.math.BlockPos;

public class GoalRunAway
implements Goal {
    private final BlockPos[] from;
    private final double distanceSq;
    private final Integer maintainY;

    public GoalRunAway(double distance, BlockPos ... from) {
        this(distance, (Integer)null, from);
    }

    public GoalRunAway(double distance, Integer maintainY, BlockPos ... from) {
        if (from.length == 0) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.distanceSq = distance * distance;
        this.maintainY = maintainY;
    }

    @Override
    public boolean isInGoal(int x, int y, int z) {
        if (this.maintainY != null && this.maintainY != y) {
            return false;
        }
        for (BlockPos p : this.from) {
            int diffZ;
            int diffX = x - p.func_177958_n();
            double distSq = diffX * diffX + (diffZ = z - p.func_177952_p()) * diffZ;
            if (!(distSq < this.distanceSq)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        double min = Double.MAX_VALUE;
        for (BlockPos p : this.from) {
            double h = GoalXZ.calculate(p.func_177958_n() - x, p.func_177952_p() - z);
            if (!(h < min)) continue;
            min = h;
        }
        min = -min;
        if (this.maintainY != null) {
            min = min * 0.6 + GoalYLevel.calculate(this.maintainY, y) * 1.5;
        }
        return min;
    }

    public String toString() {
        if (this.maintainY != null) {
            return String.format("GoalRunAwayFromMaintainY y=%s, %s", SettingsUtil.maybeCensor(this.maintainY), Arrays.asList(this.from));
        }
        return "GoalRunAwayFrom" + Arrays.asList(this.from);
    }
}

