/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockUtils;
import baritone.api.utils.accessor.IItemStack;
import com.google.common.collect.ImmutableSet;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public final class BlockOptionalMeta {
    private final Block block;
    private final Set<BlockState> blockstates;
    private final ImmutableSet<Integer> stateHashes;
    private final ImmutableSet<Integer> stackHashes;
    private static final Pattern pattern = Pattern.compile("^(.+?)(?::(\\d+))?$");
    private static LootTableManager manager;
    private static LootPredicateManager predicate;
    private static Map<Block, List<Item>> drops;

    public BlockOptionalMeta(@Nonnull Block block) {
        this.block = block;
        this.blockstates = BlockOptionalMeta.getStates(block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    public BlockOptionalMeta(@Nonnull String selector) {
        Matcher matcher = pattern.matcher(selector);
        if (!matcher.find()) {
            throw new IllegalArgumentException("invalid block selector");
        }
        MatchResult matchResult = matcher.toMatchResult();
        this.block = BlockUtils.stringToBlockRequired(matchResult.group(1));
        this.blockstates = BlockOptionalMeta.getStates(this.block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    private static Set<BlockState> getStates(@Nonnull Block block) {
        return new HashSet<BlockState>((Collection<BlockState>)block.func_176194_O().func_177619_a());
    }

    private static ImmutableSet<Integer> getStateHashes(Set<BlockState> blockstates) {
        return ImmutableSet.copyOf((Object[])blockstates.stream().map(Object::hashCode).toArray(Integer[]::new));
    }

    private static ImmutableSet<Integer> getStackHashes(Set<BlockState> blockstates) {
        return ImmutableSet.copyOf((Object[])blockstates.stream().flatMap(state -> BlockOptionalMeta.drops(state.func_177230_c()).stream().map(item -> new ItemStack((IItemProvider)item, 1))).map(stack -> ((IItemStack)stack).getBaritoneHash()).toArray(Integer[]::new));
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean matches(@Nonnull Block block) {
        return block == this.block;
    }

    public boolean matches(@Nonnull BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return block == this.block && this.stateHashes.contains((Object)blockstate.hashCode());
    }

    public boolean matches(ItemStack stack) {
        int hash = ((IItemStack)stack).getBaritoneHash();
        return this.stackHashes.contains((Object)(hash -= stack.func_77952_i()));
    }

    public String toString() {
        return String.format("BlockOptionalMeta{block=%s}", this.block);
    }

    public BlockState getAnyBlockState() {
        if (this.blockstates.size() > 0) {
            return this.blockstates.iterator().next();
        }
        return null;
    }

    public static LootTableManager getManager() {
        if (manager == null) {
            ResourcePackList rpl = new ResourcePackList(ResourcePackInfo::new, new IPackFinder[]{new ServerPackFinder()});
            rpl.func_198983_a();
            IResourcePack thePack = ((ResourcePackInfo)rpl.func_198978_b().iterator().next()).func_195796_e();
            SimpleReloadableResourceManager resourceManager = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
            manager = new LootTableManager(predicate);
            resourceManager.func_219534_a((IFutureReloadListener)manager);
            try {
                resourceManager.func_219536_a((Executor)new ThreadPerTaskExecutor(Thread::new), (Executor)new ThreadPerTaskExecutor(Thread::new), Collections.singletonList(thePack), CompletableFuture.completedFuture(Unit.INSTANCE)).get();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return manager;
    }

    public static LootPredicateManager getPredicateManager() {
        return predicate;
    }

    private static synchronized List<Item> drops(Block b) {
        return drops.computeIfAbsent(b, block -> {
            ResourceLocation lootTableLocation = block.func_220068_i();
            if (lootTableLocation == LootTables.field_186419_a) {
                return Collections.emptyList();
            }
            ArrayList items = new ArrayList();
            BlockOptionalMeta.getManager().func_186521_a(lootTableLocation).func_216120_b(new LootContext.Builder(null).func_216023_a(new Random()).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237491_b_((Vector3i)BlockPos.field_177959_e)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, null).func_216015_a(LootParameters.field_216287_g, (Object)block.func_176223_P()).func_216022_a(LootParameterSets.field_216267_h), stack -> items.add(stack.func_77973_b()));
            return items;
        });
    }

    static {
        predicate = new LootPredicateManager();
        drops = new HashMap<Block, List<Item>>();
    }
}

