/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.IPlayerContext;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public final class RayTraceUtils {
    private RayTraceUtils() {
    }

    public static RayTraceResult rayTraceTowards(Entity entity, Rotation rotation, double blockReachDistance) {
        return RayTraceUtils.rayTraceTowards(entity, rotation, blockReachDistance, false);
    }

    public static RayTraceResult rayTraceTowards(Entity entity, Rotation rotation, double blockReachDistance, boolean wouldSneak) {
        Vector3d start = wouldSneak ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.func_174824_e(1.0f);
        Vector3d direction = RotationUtils.calcVector3dFromRotation(rotation);
        Vector3d end = start.func_72441_c(direction.field_72450_a * blockReachDistance, direction.field_72448_b * blockReachDistance, direction.field_72449_c * blockReachDistance);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, entity));
    }

    public static Vector3d inferSneakingEyePosition(Entity entity) {
        return new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + IPlayerContext.eyeHeight(true), entity.func_226281_cx_());
    }
}

