/*
 * Decompiled with CFR 0.152.
 */
package baritone.behavior;

import baritone.Baritone;
import baritone.api.cache.IWaypoint;
import baritone.api.cache.Waypoint;
import baritone.api.event.events.BlockInteractEvent;
import baritone.api.utils.BetterBlockPos;
import baritone.behavior.Behavior;
import baritone.cache.ContainerMemory;
import baritone.utils.BlockStateInterface;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BedBlock;
import net.minecraft.item.ItemStack;

public final class MemoryBehavior
extends Behavior {
    public MemoryBehavior(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void onBlockInteract(BlockInteractEvent event) {
        if (event.getType() == BlockInteractEvent.Type.USE && BlockStateInterface.getBlock(this.ctx, event.getPos()) instanceof BedBlock) {
            this.baritone.getWorldProvider().getCurrentWorld().getWaypoints().addWaypoint(new Waypoint("bed", IWaypoint.Tag.BED, BetterBlockPos.from(event.getPos())));
        }
    }

    @Override
    public void onPlayerDeath() {
        this.baritone.getWorldProvider().getCurrentWorld().getWaypoints().addWaypoint(new Waypoint("death", IWaypoint.Tag.DEATH, this.ctx.playerFeet()));
    }

    public EnderChestMemory getCurrent() {
        Path path = this.baritone.getWorldProvider().getCurrentWorld().directory;
        return EnderChestMemory.getByServerAndPlayer(path.getParent(), this.ctx.player().func_110124_au());
    }

    public static class EnderChestMemory {
        private static final Map<Path, EnderChestMemory> memory = new HashMap<Path, EnderChestMemory>();
        private final Path enderChest;
        private List<ItemStack> contents;

        private EnderChestMemory(Path enderChest) {
            this.enderChest = enderChest;
            System.out.println("Echest storing in " + enderChest);
            try {
                this.contents = ContainerMemory.readItemStacks(Files.readAllBytes(enderChest));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("CANNOT read echest =( =(");
                this.contents = null;
            }
        }

        public synchronized void save() {
            System.out.println("Saving");
            if (this.contents != null) {
                try {
                    this.enderChest.getParent().toFile().mkdir();
                    Files.write(this.enderChest, ContainerMemory.writeItemStacks(this.contents), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("CANNOT save echest =( =(");
                }
            }
        }

        private static synchronized EnderChestMemory getByServerAndPlayer(Path serverStorage, UUID player) {
            return memory.computeIfAbsent(serverStorage.resolve("echests").resolve(player.toString()), EnderChestMemory::new);
        }
    }
}

