/*
 * Decompiled with CFR 0.152.
 */
package baritone.cache;

import baritone.api.utils.BlockUtils;
import baritone.cache.ChunkPacker;
import baritone.utils.pathing.PathingBlockType;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class CachedChunk {
    public static final ImmutableSet<Block> BLOCKS_TO_KEEP_TRACK_OF = ImmutableSet.of((Object)Blocks.field_150477_bB, (Object)Blocks.field_150460_al, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150447_bR, (Object)Blocks.field_150384_bq, (Object)Blocks.field_150378_br, (Object[])new Block[]{Blocks.field_150474_ac, Blocks.field_180401_cv, Blocks.field_190976_dk, Blocks.field_190977_dl, Blocks.field_190978_dm, Blocks.field_190979_dn, Blocks.field_190980_do, Blocks.field_190981_dp, Blocks.field_190982_dq, Blocks.field_190983_dr, Blocks.field_190984_ds, Blocks.field_196875_ie, Blocks.field_190986_du, Blocks.field_190987_dv, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190990_dy, Blocks.field_190991_dz, Blocks.field_190975_dA, Blocks.field_150427_aO, Blocks.field_150438_bZ, Blocks.field_150461_bJ, Blocks.field_150382_bo, Blocks.field_196714_eU, Blocks.field_196712_eT, Blocks.field_196716_eW, Blocks.field_196715_eV, Blocks.field_196710_eS, Blocks.field_196709_eR, Blocks.field_196708_eQ, Blocks.field_196707_eP, Blocks.field_196703_eM, Blocks.field_196701_eL, Blocks.field_196705_eO, Blocks.field_196704_eN, Blocks.field_150381_bn, Blocks.field_150467_bQ, Blocks.field_196587_am, Blocks.field_196588_an, Blocks.field_196589_ao, Blocks.field_196590_ap, Blocks.field_196592_aq, Blocks.field_196593_ar, Blocks.field_196594_as, Blocks.field_196595_at, Blocks.field_196596_au, Blocks.field_196597_av, Blocks.field_196598_aw, Blocks.field_196599_ax, Blocks.field_196600_ay, Blocks.field_196601_az, Blocks.field_196550_aA, Blocks.field_196551_aB, Blocks.field_150380_bt, Blocks.field_150421_aI, Blocks.field_185775_db, Blocks.field_196553_aF, Blocks.field_150388_bm, Blocks.field_150468_ap, Blocks.field_150395_bd});
    public static final int SIZE = 131072;
    public static final int SIZE_IN_BYTES = 16384;
    public final int x;
    public final int z;
    private final BitSet data;
    private final Int2ObjectOpenHashMap<String> special;
    private final BlockState[] overview;
    private final int[] heightMap;
    private final Map<String, List<BlockPos>> specialBlockLocations;
    public final long cacheTimestamp;

    CachedChunk(int x, int z, BitSet data, BlockState[] overview, Map<String, List<BlockPos>> specialBlockLocations, long cacheTimestamp) {
        CachedChunk.validateSize(data);
        this.x = x;
        this.z = z;
        this.data = data;
        this.overview = overview;
        this.heightMap = new int[256];
        this.specialBlockLocations = specialBlockLocations;
        this.cacheTimestamp = cacheTimestamp;
        if (specialBlockLocations.isEmpty()) {
            this.special = null;
        } else {
            this.special = new Int2ObjectOpenHashMap();
            this.setSpecial();
        }
        this.calculateHeightMap();
    }

    private final void setSpecial() {
        for (Map.Entry<String, List<BlockPos>> entry : this.specialBlockLocations.entrySet()) {
            for (BlockPos pos : entry.getValue()) {
                this.special.put(CachedChunk.getPositionIndex(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (Object)entry.getKey());
            }
        }
    }

    public final BlockState getBlock(int x, int y, int z, RegistryKey<World> dimension) {
        String str;
        int index = CachedChunk.getPositionIndex(x, y, z);
        PathingBlockType type = this.getType(index);
        int internalPos = z << 4 | x;
        if (this.heightMap[internalPos] == y && type != PathingBlockType.AVOID) {
            return this.overview[internalPos];
        }
        if (this.special != null && (str = (String)this.special.get(index)) != null) {
            return BlockUtils.stringToBlockRequired(str).func_176223_P();
        }
        if (type == PathingBlockType.SOLID) {
            if (y == 127 && dimension == World.field_234919_h_) {
                return Blocks.field_150357_h.func_176223_P();
            }
            if (y < 5 && dimension == World.field_234918_g_) {
                return Blocks.field_150343_Z.func_176223_P();
            }
        }
        return ChunkPacker.pathingTypeToBlock(type, dimension);
    }

    private PathingBlockType getType(int index) {
        return PathingBlockType.fromBits(this.data.get(index), this.data.get(index + 1));
    }

    private void calculateHeightMap() {
        for (int z = 0; z < 16; ++z) {
            block1: for (int x = 0; x < 16; ++x) {
                int index = z << 4 | x;
                this.heightMap[index] = 0;
                for (int y = 256; y >= 0; --y) {
                    int i = CachedChunk.getPositionIndex(x, y, z);
                    if (!this.data.get(i) && !this.data.get(i + 1)) continue;
                    this.heightMap[index] = y;
                    continue block1;
                }
            }
        }
    }

    public final BlockState[] getOverview() {
        return this.overview;
    }

    public final Map<String, List<BlockPos>> getRelativeBlocks() {
        return this.specialBlockLocations;
    }

    public final ArrayList<BlockPos> getAbsoluteBlocks(String blockType) {
        if (this.specialBlockLocations.get(blockType) == null) {
            return null;
        }
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        for (BlockPos pos : this.specialBlockLocations.get(blockType)) {
            res.add(new BlockPos(pos.func_177958_n() + this.x * 16, pos.func_177956_o(), pos.func_177952_p() + this.z * 16));
        }
        return res;
    }

    public final byte[] toByteArray() {
        return this.data.toByteArray();
    }

    public static int getPositionIndex(int x, int y, int z) {
        return x << 1 | z << 5 | y << 9;
    }

    private static void validateSize(BitSet data) {
        if (data.size() > 131072) {
            throw new IllegalArgumentException("BitSet of invalid length provided");
        }
    }
}

