/*
 * Decompiled with CFR 0.152.
 */
package baritone.cache;

import baritone.api.utils.BlockUtils;
import baritone.cache.CachedChunk;
import baritone.pathing.movement.MovementHelper;
import baritone.utils.BlockStateInterface;
import baritone.utils.pathing.PathingBlockType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public final class ChunkPacker {
    private ChunkPacker() {
    }

    public static CachedChunk pack(Chunk chunk) {
        HashMap<String, List<BlockPos>> specialBlocks = new HashMap<String, List<BlockPos>>();
        BitSet bitSet = new BitSet(131072);
        try {
            ChunkSection[] chunkInternalStorageArray = chunk.func_76587_i();
            for (int y0 = 0; y0 < 16; ++y0) {
                ChunkSection extendedblockstorage = chunkInternalStorageArray[y0];
                if (extendedblockstorage == null) continue;
                PalettedContainer bsc = extendedblockstorage.func_186049_g();
                int yReal = y0 << 4;
                for (int y1 = 0; y1 < 16; ++y1) {
                    int y = y1 | yReal;
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            int index = CachedChunk.getPositionIndex(x, y, z);
                            BlockState state = (BlockState)bsc.func_186016_a(x, y1, z);
                            boolean[] bits = ChunkPacker.getPathingBlockType(state, chunk, x, y, z).getBits();
                            bitSet.set(index, bits[0]);
                            bitSet.set(index + 1, bits[1]);
                            Block block = state.func_177230_c();
                            if (!CachedChunk.BLOCKS_TO_KEEP_TRACK_OF.contains((Object)block)) continue;
                            String name = BlockUtils.blockToString(block);
                            specialBlocks.computeIfAbsent(name, b -> new ArrayList()).add(new BlockPos(x, y, z));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BlockState[] blocks = new BlockState[256];
        for (int z = 0; z < 16; ++z) {
            block7: for (int x = 0; x < 16; ++x) {
                for (int y = 255; y >= 0; --y) {
                    int index = CachedChunk.getPositionIndex(x, y, z);
                    if (!bitSet.get(index) && !bitSet.get(index + 1)) continue;
                    blocks[z << 4 | x] = BlockStateInterface.getFromChunk(chunk, x, y, z);
                    continue block7;
                }
                blocks[z << 4 | x] = Blocks.field_150350_a.func_176223_P();
            }
        }
        return new CachedChunk(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, bitSet, blocks, specialBlocks, System.currentTimeMillis());
    }

    private static PathingBlockType getPathingBlockType(BlockState state, Chunk chunk, int x, int y, int z) {
        Block block = state.func_177230_c();
        if (MovementHelper.isWater(state)) {
            if (MovementHelper.possiblyFlowing(state)) {
                return PathingBlockType.AVOID;
            }
            if (x != 15 && MovementHelper.possiblyFlowing(BlockStateInterface.getFromChunk(chunk, x + 1, y, z)) || x != 0 && MovementHelper.possiblyFlowing(BlockStateInterface.getFromChunk(chunk, x - 1, y, z)) || z != 15 && MovementHelper.possiblyFlowing(BlockStateInterface.getFromChunk(chunk, x, y, z + 1)) || z != 0 && MovementHelper.possiblyFlowing(BlockStateInterface.getFromChunk(chunk, x, y, z - 1))) {
                return PathingBlockType.AVOID;
            }
            if (x == 0 || x == 15 || z == 0 || z == 15) {
                Vector3d flow = state.func_204520_s().func_215673_c((IBlockReader)chunk.func_177412_p(), new BlockPos(x + chunk.func_76632_l().field_77276_a << 4, y, z + chunk.func_76632_l().field_77275_b << 4));
                if (flow.field_72450_a != 0.0 || flow.field_72449_c != 0.0) {
                    return PathingBlockType.WATER;
                }
                return PathingBlockType.AVOID;
            }
            return PathingBlockType.WATER;
        }
        if (MovementHelper.avoidWalkingInto(state) || MovementHelper.isBottomSlab(state)) {
            return PathingBlockType.AVOID;
        }
        if (block instanceof AirBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock) {
            return PathingBlockType.AIR;
        }
        return PathingBlockType.SOLID;
    }

    public static BlockState pathingTypeToBlock(PathingBlockType type, RegistryKey<World> dimension) {
        switch (type) {
            case AIR: {
                return Blocks.field_150350_a.func_176223_P();
            }
            case WATER: {
                return Blocks.field_150355_j.func_176223_P();
            }
            case AVOID: {
                return Blocks.field_150353_l.func_176223_P();
            }
            case SOLID: {
                if (dimension == World.field_234918_g_) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                if (dimension == World.field_234919_h_) {
                    return Blocks.field_150424_aL.func_176223_P();
                }
                if (dimension != World.field_234920_i_) break;
                return Blocks.field_150377_bs.func_176223_P();
            }
        }
        return null;
    }
}

