/*
 * Decompiled with CFR 0.152.
 */
package baritone.cache;

import baritone.api.cache.ICachedWorld;
import baritone.api.cache.IWorldScanner;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.BlockOptionalMetaLookup;
import baritone.api.utils.IPlayerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public enum WorldScanner implements IWorldScanner
{
    INSTANCE;

    private static final int[] DEFAULT_COORDINATE_ITERATION_ORDER;

    @Override
    public List<BlockPos> scanChunkRadius(IPlayerContext ctx, BlockOptionalMetaLookup filter, int max, int yLevelThreshold, int maxSearchRadius) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        if (filter.blocks().isEmpty()) {
            return res;
        }
        ClientChunkProvider chunkProvider = (ClientChunkProvider)ctx.world().func_72863_F();
        int maxSearchRadiusSq = maxSearchRadius * maxSearchRadius;
        int playerChunkX = ctx.playerFeet().func_177958_n() >> 4;
        int playerChunkZ = ctx.playerFeet().func_177952_p() >> 4;
        int playerY = ctx.playerFeet().func_177956_o();
        int playerYBlockStateContainerIndex = playerY >> 4;
        int[] coordinateIterationOrder = IntStream.range(0, 16).boxed().sorted(Comparator.comparingInt(y -> Math.abs(y - playerYBlockStateContainerIndex))).mapToInt(x -> x).toArray();
        int searchRadiusSq = 0;
        boolean foundWithinY = false;
        while (true) {
            boolean allUnloaded = true;
            boolean foundChunks = false;
            for (int xoff = -searchRadiusSq; xoff <= searchRadiusSq; ++xoff) {
                for (int zoff = -searchRadiusSq; zoff <= searchRadiusSq; ++zoff) {
                    int distance = xoff * xoff + zoff * zoff;
                    if (distance != searchRadiusSq) continue;
                    foundChunks = true;
                    int chunkX = xoff + playerChunkX;
                    int chunkZ = zoff + playerChunkZ;
                    Chunk chunk = chunkProvider.func_212849_a_(chunkX, chunkZ, null, false);
                    if (chunk == null) continue;
                    allUnloaded = false;
                    if (!this.scanChunkInto(chunkX << 4, chunkZ << 4, chunk, filter, res, max, yLevelThreshold, playerY, coordinateIterationOrder)) continue;
                    foundWithinY = true;
                }
            }
            if (allUnloaded && foundChunks || res.size() >= max && (searchRadiusSq > maxSearchRadiusSq || searchRadiusSq > 1 && foundWithinY)) {
                return res;
            }
            ++searchRadiusSq;
        }
    }

    @Override
    public List<BlockPos> scanChunk(IPlayerContext ctx, BlockOptionalMetaLookup filter, ChunkPos pos, int max, int yLevelThreshold) {
        if (filter.blocks().isEmpty()) {
            return Collections.emptyList();
        }
        ClientChunkProvider chunkProvider = (ClientChunkProvider)ctx.world().func_72863_F();
        Chunk chunk = chunkProvider.func_212849_a_(pos.field_77276_a, pos.field_77275_b, null, false);
        int playerY = ctx.playerFeet().func_177956_o();
        if (chunk == null || chunk.func_76621_g()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        this.scanChunkInto(pos.field_77276_a << 4, pos.field_77275_b << 4, chunk, filter, res, max, yLevelThreshold, playerY, DEFAULT_COORDINATE_ITERATION_ORDER);
        return res;
    }

    @Override
    public int repack(IPlayerContext ctx) {
        return this.repack(ctx, 40);
    }

    @Override
    public int repack(IPlayerContext ctx, int range) {
        AbstractChunkProvider chunkProvider = ctx.world().func_72863_F();
        ICachedWorld cachedWorld = ctx.worldData().getCachedWorld();
        BetterBlockPos playerPos = ctx.playerFeet();
        int playerChunkX = playerPos.func_177958_n() >> 4;
        int playerChunkZ = playerPos.func_177952_p() >> 4;
        int minX = playerChunkX - range;
        int minZ = playerChunkZ - range;
        int maxX = playerChunkX + range;
        int maxZ = playerChunkZ + range;
        int queued = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Chunk chunk = chunkProvider.func_217205_a(x, z, false);
                if (chunk == null || chunk.func_76621_g()) continue;
                ++queued;
                cachedWorld.queueForPacking(chunk);
            }
        }
        return queued;
    }

    private boolean scanChunkInto(int chunkX, int chunkZ, Chunk chunk, BlockOptionalMetaLookup filter, Collection<BlockPos> result, int max, int yLevelThreshold, int playerY, int[] coordinateIterationOrder) {
        ChunkSection[] chunkInternalStorageArray = chunk.func_76587_i();
        boolean foundWithinY = false;
        for (int yIndex = 0; yIndex < 16; ++yIndex) {
            int y0 = coordinateIterationOrder[yIndex];
            ChunkSection section = chunkInternalStorageArray[y0];
            if (section == null || ChunkSection.func_222628_a((ChunkSection)section)) continue;
            int yReal = y0 << 4;
            PalettedContainer bsc = section.func_186049_g();
            for (int yy = 0; yy < 16; ++yy) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        BlockState state = (BlockState)bsc.func_186016_a(x, yy, z);
                        if (!filter.has(state)) continue;
                        int y = yReal | yy;
                        if (result.size() >= max) {
                            if (Math.abs(y - playerY) < yLevelThreshold) {
                                foundWithinY = true;
                            } else if (foundWithinY) {
                                return true;
                            }
                        }
                        result.add(new BlockPos(chunkX | x, y, chunkZ | z));
                    }
                }
            }
        }
        return foundWithinY;
    }

    static {
        DEFAULT_COORDINATE_ITERATION_ORDER = IntStream.range(0, 16).toArray();
    }
}

