/*
 * Decompiled with CFR 0.152.
 */
package baritone.launch.mixins;

import baritone.Baritone;
import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.ChunkEvent;
import baritone.api.event.events.type.EventState;
import baritone.cache.CachedChunk;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.util.math.ChunkPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayNetHandler.class})
public class MixinClientPlayNetHandler {
    @Inject(method={"handleChunkData"}, at={@At(value="RETURN")})
    private void postHandleChunkData(SChunkDataPacket packetIn, CallbackInfo ci) {
        for (IBaritone ibaritone : BaritoneAPI.getProvider().getAllBaritones()) {
            ClientPlayerEntity player = ibaritone.getPlayerContext().player();
            if (player == null || player.field_71174_a != (ClientPlayNetHandler)this) continue;
            ibaritone.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.POST, packetIn.func_149274_i() ? ChunkEvent.Type.POPULATE_FULL : ChunkEvent.Type.POPULATE_PARTIAL, packetIn.func_149273_e(), packetIn.func_149271_f()));
        }
    }

    @Inject(method={"handleBlockChange"}, at={@At(value="RETURN")})
    private void postHandleBlockChange(SChangeBlockPacket packetIn, CallbackInfo ci) {
        if (!((Boolean)Baritone.settings().repackOnAnyBlockChange.value).booleanValue()) {
            return;
        }
        if (!CachedChunk.BLOCKS_TO_KEEP_TRACK_OF.contains((Object)packetIn.func_197685_a().func_177230_c())) {
            return;
        }
        for (IBaritone ibaritone : BaritoneAPI.getProvider().getAllBaritones()) {
            ClientPlayerEntity player = ibaritone.getPlayerContext().player();
            if (player == null || player.field_71174_a != (ClientPlayNetHandler)this) continue;
            ibaritone.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.POST, ChunkEvent.Type.POPULATE_FULL, packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4));
        }
    }

    @Inject(method={"handleMultiBlockChange"}, at={@At(value="RETURN")})
    private void postHandleMultiBlockChange(SMultiBlockChangePacket packetIn, CallbackInfo ci) {
        if (!((Boolean)Baritone.settings().repackOnAnyBlockChange.value).booleanValue()) {
            return;
        }
        ChunkPos[] chunkPos = new ChunkPos[1];
        packetIn.func_244310_a((pos, state) -> {
            if (CachedChunk.BLOCKS_TO_KEEP_TRACK_OF.contains((Object)state.func_177230_c())) {
                chunkPos[0] = new ChunkPos(pos);
            }
        });
        if (chunkPos[0] == null) {
            return;
        }
        for (IBaritone ibaritone : BaritoneAPI.getProvider().getAllBaritones()) {
            ClientPlayerEntity player = ibaritone.getPlayerContext().player();
            if (player == null || player.field_71174_a != (ClientPlayNetHandler)this) continue;
            ibaritone.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.POST, ChunkEvent.Type.POPULATE_FULL, chunkPos[0].field_77276_a, chunkPos[0].field_77275_b));
        }
    }

    @Inject(method={"handleCombatEvent"}, at={@At(value="INVOKE", target="net/minecraft/client/Minecraft.displayGuiScreen(Lnet/minecraft/client/gui/screen/Screen;)V")})
    private void onPlayerDeath(SCombatPacket packetIn, CallbackInfo ci) {
        for (IBaritone ibaritone : BaritoneAPI.getProvider().getAllBaritones()) {
            ClientPlayerEntity player = ibaritone.getPlayerContext().player();
            if (player == null || player.field_71174_a != (ClientPlayNetHandler)this) continue;
            ibaritone.getGameEventHandler().onPlayerDeath();
        }
    }
}

