/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement;

import baritone.Baritone;
import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.pathing.movement.ActionCosts;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.Helper;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.VecUtils;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementState;
import baritone.utils.BlockStateInterface;
import baritone.utils.ToolSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.EndPortalBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.ScaffoldingBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public interface MovementHelper
extends ActionCosts,
Helper {
    public static boolean avoidBreaking(BlockStateInterface bsi, int x, int y, int z, BlockState state) {
        Block b = state.func_177230_c();
        return b == Blocks.field_150432_aD || b instanceof SilverfishBlock || MovementHelper.avoidAdjacentBreaking(bsi, x, y + 1, z, true) || MovementHelper.avoidAdjacentBreaking(bsi, x + 1, y, z, false) || MovementHelper.avoidAdjacentBreaking(bsi, x - 1, y, z, false) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z + 1, false) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z - 1, false);
    }

    public static boolean avoidAdjacentBreaking(BlockStateInterface bsi, int x, int y, int z, boolean directlyAbove) {
        BlockState state = bsi.get0(x, y, z);
        Block block = state.func_177230_c();
        if (!directlyAbove && block instanceof FallingBlock && ((Boolean)Baritone.settings().avoidUpdatingFallingBlocks.value).booleanValue() && FallingBlock.func_185759_i((BlockState)bsi.get0(x, y - 1, z))) {
            return true;
        }
        return !state.func_204520_s().func_206888_e();
    }

    public static boolean canWalkThrough(IPlayerContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkThrough(new BlockStateInterface(ctx), pos.field_177962_a, pos.field_177960_b, pos.field_177961_c);
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z) {
        return MovementHelper.canWalkThrough(bsi, x, y, z, bsi.get0(x, y, z));
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof AirBlock) {
            return true;
        }
        if (block == Blocks.field_150480_ab || block == Blocks.field_150473_bD || block == Blocks.field_196553_aF || block == Blocks.field_150384_bq || block == Blocks.field_150375_by || block instanceof AbstractSkullBlock || block == Blocks.field_203203_C || block instanceof ShulkerBoxBlock || block instanceof SlabBlock || block instanceof TrapDoorBlock || block == Blocks.field_226907_mc_ || block == Blocks.field_185764_cQ) {
            return false;
        }
        if (((List)Baritone.settings().blocksToAvoid.value).contains(block)) {
            return false;
        }
        if (block instanceof DoorBlock || block instanceof FenceGateBlock) {
            return block != Blocks.field_150454_av;
        }
        if (block instanceof CarpetBlock) {
            return MovementHelper.canWalkOn(bsi, x, y - 1, z);
        }
        if (block instanceof SnowBlock) {
            if (!bsi.worldContainsLoadedChunk(x, z)) {
                return true;
            }
            if ((Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) >= 3) {
                return false;
            }
            return MovementHelper.canWalkOn(bsi, x, y - 1, z);
        }
        if (MovementHelper.isFlowing(x, y, z, state, bsi)) {
            return false;
        }
        FluidState fluidState = state.func_204520_s();
        if (fluidState.func_206886_c() instanceof WaterFluid) {
            if (((Boolean)Baritone.settings().assumeWalkOnWater.value).booleanValue()) {
                return false;
            }
            BlockState up = bsi.get0(x, y + 1, z);
            return up.func_204520_s().func_206888_e() && !(up.func_177230_c() instanceof LilyPadBlock);
        }
        return state.func_196957_g(bsi.access, BlockPos.field_177992_a, PathType.LAND);
    }

    public static boolean fullyPassable(CalculationContext context, int x, int y, int z) {
        return MovementHelper.fullyPassable(context.bsi.access, (BlockPos)context.bsi.isPassableBlockPos.func_181079_c(x, y, z), context.bsi.get0(x, y, z));
    }

    public static boolean fullyPassable(IPlayerContext ctx, BlockPos pos) {
        return MovementHelper.fullyPassable((IBlockReader)ctx.world(), pos, ctx.world().func_180495_p(pos));
    }

    public static boolean fullyPassable(IBlockReader access, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof AirBlock) {
            return true;
        }
        if (block == Blocks.field_150480_ab || block == Blocks.field_150473_bD || block == Blocks.field_196553_aF || block == Blocks.field_150395_bd || block == Blocks.field_150468_ap || block == Blocks.field_150375_by || block instanceof DoorBlock || block instanceof FenceGateBlock || block instanceof SnowBlock || !state.func_204520_s().func_206888_e() || block instanceof TrapDoorBlock || block instanceof EndPortalBlock || block instanceof SkullBlock || block instanceof ShulkerBoxBlock) {
            return false;
        }
        return state.func_196957_g(access, pos, PathType.LAND);
    }

    public static boolean isReplaceable(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        Block block = state.func_177230_c();
        if (block instanceof AirBlock) {
            return true;
        }
        if (block instanceof SnowBlock) {
            if (!bsi.worldContainsLoadedChunk(x, z)) {
                return true;
            }
            return (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) == 1;
        }
        if (block == Blocks.field_196805_gi || block == Blocks.field_196804_gh) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    }

    @Deprecated
    public static boolean isReplacable(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        return MovementHelper.isReplaceable(x, y, z, state, bsi);
    }

    public static boolean isDoorPassable(IPlayerContext ctx, BlockPos doorPos, BlockPos playerPos) {
        if (playerPos.equals((Object)doorPos)) {
            return false;
        }
        BlockState state = BlockStateInterface.get(ctx, doorPos);
        if (!(state.func_177230_c() instanceof DoorBlock)) {
            return true;
        }
        return MovementHelper.isHorizontalBlockPassable(doorPos, state, playerPos, DoorBlock.field_176519_b);
    }

    public static boolean isGatePassable(IPlayerContext ctx, BlockPos gatePos, BlockPos playerPos) {
        if (playerPos.equals((Object)gatePos)) {
            return false;
        }
        BlockState state = BlockStateInterface.get(ctx, gatePos);
        if (!(state.func_177230_c() instanceof FenceGateBlock)) {
            return true;
        }
        return (Boolean)state.func_177229_b((Property)FenceGateBlock.field_176466_a);
    }

    public static boolean isHorizontalBlockPassable(BlockPos blockPos, BlockState blockState, BlockPos playerPos, BooleanProperty propertyOpen) {
        Direction.Axis playerFacing;
        if (playerPos.equals((Object)blockPos)) {
            return false;
        }
        Direction.Axis facing = ((Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176740_k();
        boolean open = (Boolean)blockState.func_177229_b((Property)propertyOpen);
        if (playerPos.func_177978_c().equals((Object)blockPos) || playerPos.func_177968_d().equals((Object)blockPos)) {
            playerFacing = Direction.Axis.Z;
        } else if (playerPos.func_177974_f().equals((Object)blockPos) || playerPos.func_177976_e().equals((Object)blockPos)) {
            playerFacing = Direction.Axis.X;
        } else {
            return true;
        }
        return facing == playerFacing == open;
    }

    public static boolean avoidWalkingInto(BlockState state) {
        Block block = state.func_177230_c();
        return !state.func_204520_s().func_206888_e() || block == Blocks.field_196814_hQ || block == Blocks.field_150434_aF || block == Blocks.field_150480_ab || block == Blocks.field_150384_bq || block == Blocks.field_196553_aF || block == Blocks.field_203203_C;
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof AirBlock || block == Blocks.field_196814_hQ || block == Blocks.field_203203_C || block == Blocks.field_226907_mc_) {
            return false;
        }
        if (MovementHelper.isBlockNormalCube(state)) {
            return true;
        }
        if (block == Blocks.field_150468_ap || block == Blocks.field_150395_bd && ((Boolean)Baritone.settings().allowVines.value).booleanValue()) {
            return true;
        }
        if (block == Blocks.field_150458_ak || block == Blocks.field_185774_da) {
            return true;
        }
        if (block == Blocks.field_150477_bB || block == Blocks.field_150486_ae || block == Blocks.field_150447_bR) {
            return true;
        }
        if (MovementHelper.isWater(state)) {
            BlockState upState = bsi.get0(x, y + 1, z);
            Block up = upState.func_177230_c();
            if (up == Blocks.field_196651_dG || up instanceof CarpetBlock) {
                return true;
            }
            if (MovementHelper.isFlowing(x, y, z, state, bsi) || upState.func_204520_s().func_206886_c() == Fluids.field_207212_b) {
                return MovementHelper.isWater(upState) && (Boolean)Baritone.settings().assumeWalkOnWater.value == false;
            }
            return MovementHelper.isWater(upState) ^ (Boolean)Baritone.settings().assumeWalkOnWater.value;
        }
        if (((Boolean)Baritone.settings().assumeWalkOnLava.value).booleanValue() && MovementHelper.isLava(state) && !MovementHelper.isFlowing(x, y, z, state, bsi)) {
            return true;
        }
        if (block == Blocks.field_150359_w || block instanceof StainedGlassBlock) {
            return true;
        }
        if (block instanceof SlabBlock) {
            if (!((Boolean)Baritone.settings().allowWalkOnBottomSlab.value).booleanValue()) {
                return state.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.BOTTOM;
            }
            return true;
        }
        return block instanceof StairsBlock;
    }

    public static boolean canWalkOn(IPlayerContext ctx, BetterBlockPos pos, BlockState state) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.field_177962_a, pos.field_177960_b, pos.field_177961_c, state);
    }

    public static boolean canWalkOn(IPlayerContext ctx, BlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static boolean canWalkOn(IPlayerContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.field_177962_a, pos.field_177960_b, pos.field_177961_c);
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z) {
        return MovementHelper.canWalkOn(bsi, x, y, z, bsi.get0(x, y, z));
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z) {
        return MovementHelper.canPlaceAgainst(bsi, x, y, z, bsi.get0(x, y, z));
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, BlockPos pos) {
        return MovementHelper.canPlaceAgainst(bsi, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static boolean canPlaceAgainst(IPlayerContext ctx, BlockPos pos) {
        return MovementHelper.canPlaceAgainst(new BlockStateInterface(ctx), pos);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z, BlockState state) {
        return MovementHelper.isBlockNormalCube(state) || state.func_177230_c() == Blocks.field_150359_w || state.func_177230_c() instanceof StainedGlassBlock;
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, boolean includeFalling) {
        return MovementHelper.getMiningDurationTicks(context, x, y, z, context.get(x, y, z), includeFalling);
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, BlockState state, boolean includeFalling) {
        Block block = state.func_177230_c();
        if (!MovementHelper.canWalkThrough(context.bsi, x, y, z, state)) {
            BlockState above;
            if (!state.func_204520_s().func_206888_e()) {
                return 1000000.0;
            }
            double mult = context.breakCostMultiplierAt(x, y, z, state);
            if (mult >= 1000000.0) {
                return 1000000.0;
            }
            if (MovementHelper.avoidBreaking(context.bsi, x, y, z, state)) {
                return 1000000.0;
            }
            double strVsBlock = context.toolSet.getStrVsBlock(state);
            if (strVsBlock <= 0.0) {
                return 1000000.0;
            }
            double result = 1.0 / strVsBlock;
            result += context.breakBlockAdditionalCost;
            result *= mult;
            if (includeFalling && (above = context.get(x, y + 1, z)).func_177230_c() instanceof FallingBlock) {
                result += MovementHelper.getMiningDurationTicks(context, x, y + 1, z, above, true);
            }
            return result;
        }
        return 0.0;
    }

    public static boolean isBottomSlab(BlockState state) {
        return state.func_177230_c() instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM;
    }

    public static void switchToBestToolFor(IPlayerContext ctx, BlockState b) {
        MovementHelper.switchToBestToolFor(ctx, b, new ToolSet(ctx.player()), (Boolean)BaritoneAPI.getSettings().preferSilkTouch.value);
    }

    public static void switchToBestToolFor(IPlayerContext ctx, BlockState b, ToolSet ts, boolean preferSilkTouch) {
        if (!((Boolean)Baritone.settings().disableAutoTool.value).booleanValue() && !((Boolean)Baritone.settings().assumeExternalAutoTool.value).booleanValue()) {
            ctx.player().field_71071_by.field_70461_c = ts.getBestSlot(b.func_177230_c(), preferSilkTouch);
        }
    }

    public static void moveTowards(IPlayerContext ctx, MovementState state, BlockPos pos) {
        state.setTarget(new MovementState.MovementTarget(new Rotation(RotationUtils.calcRotationFromVec3d(ctx.playerHead(), VecUtils.getBlockPosCenter(pos), ctx.playerRotations()).getYaw(), ctx.player().field_70125_A), false)).setInput(Input.MOVE_FORWARD, true);
    }

    public static boolean isWater(BlockState state) {
        Fluid f = state.func_204520_s().func_206886_c();
        return f == Fluids.field_204546_a || f == Fluids.field_207212_b;
    }

    public static boolean isWater(IPlayerContext ctx, BlockPos bp) {
        return MovementHelper.isWater(BlockStateInterface.get(ctx, bp));
    }

    public static boolean isLava(BlockState state) {
        Fluid f = state.func_204520_s().func_206886_c();
        return f == Fluids.field_204547_b || f == Fluids.field_207213_d;
    }

    public static boolean isLiquid(IPlayerContext ctx, BlockPos p) {
        return MovementHelper.isLiquid(BlockStateInterface.get(ctx, p));
    }

    public static boolean isLiquid(BlockState blockState) {
        return !blockState.func_204520_s().func_206888_e();
    }

    public static boolean possiblyFlowing(BlockState state) {
        FluidState fluidState = state.func_204520_s();
        return fluidState.func_206886_c() instanceof FlowingFluid && fluidState.func_206886_c().func_207192_d(fluidState) != 8;
    }

    public static boolean isFlowing(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        FluidState fluidState = state.func_204520_s();
        if (!(fluidState.func_206886_c() instanceof FlowingFluid)) {
            return false;
        }
        if (fluidState.func_206886_c().func_207192_d(fluidState) != 8) {
            return true;
        }
        return MovementHelper.possiblyFlowing(bsi.get0(x + 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x - 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z + 1)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z - 1));
    }

    public static boolean isBlockNormalCube(BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BambooBlock || block instanceof MovingPistonBlock || block instanceof ScaffoldingBlock || block instanceof ShulkerBoxBlock) {
            return false;
        }
        return Block.func_208062_a((VoxelShape)state.func_196952_d(null, null));
    }

    public static PlaceResult attemptToPlaceABlock(MovementState state, IBaritone baritone, BlockPos placeAt, boolean preferDown, boolean wouldSneak) {
        IPlayerContext ctx = baritone.getPlayerContext();
        Optional<Rotation> direct = RotationUtils.reachable(ctx, placeAt, wouldSneak);
        boolean found = false;
        if (direct.isPresent()) {
            state.setTarget(new MovementState.MovementTarget(direct.get(), true));
            found = true;
        }
        for (int i = 0; i < 5; ++i) {
            BlockPos against1 = placeAt.func_177972_a(Movement.HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i]);
            if (!MovementHelper.canPlaceAgainst(ctx, against1)) continue;
            if (!((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(false, placeAt.func_177958_n(), placeAt.func_177956_o(), placeAt.func_177952_p())) {
                Helper.HELPER.logDebug("bb pls get me some blocks. dirt, netherrack, cobble");
                state.setStatus(MovementStatus.UNREACHABLE);
                return PlaceResult.NO_OPTION;
            }
            double faceX = ((double)(placeAt.func_177958_n() + against1.func_177958_n()) + 1.0) * 0.5;
            double faceY = ((double)(placeAt.func_177956_o() + against1.func_177956_o()) + 0.5) * 0.5;
            double faceZ = ((double)(placeAt.func_177952_p() + against1.func_177952_p()) + 1.0) * 0.5;
            Rotation place = RotationUtils.calcRotationFromVec3d(wouldSneak ? RayTraceUtils.inferSneakingEyePosition((Entity)ctx.player()) : ctx.playerHead(), new Vector3d(faceX, faceY, faceZ), ctx.playerRotations());
            RayTraceResult res = RayTraceUtils.rayTraceTowards((Entity)ctx.player(), place, ctx.playerController().getBlockReachDistance(), wouldSneak);
            if (res == null || res.func_216346_c() != RayTraceResult.Type.BLOCK || !((BlockRayTraceResult)res).func_216350_a().equals((Object)against1) || !((BlockRayTraceResult)res).func_216350_a().func_177972_a(((BlockRayTraceResult)res).func_216354_b()).equals((Object)placeAt)) continue;
            state.setTarget(new MovementState.MovementTarget(place, true));
            found = true;
            if (!preferDown) break;
        }
        if (ctx.getSelectedBlock().isPresent()) {
            BlockPos selectedBlock = ctx.getSelectedBlock().get();
            Direction side = ((BlockRayTraceResult)ctx.objectMouseOver()).func_216354_b();
            if (selectedBlock.equals((Object)placeAt) || MovementHelper.canPlaceAgainst(ctx, selectedBlock) && selectedBlock.func_177972_a(side).equals((Object)placeAt)) {
                if (wouldSneak) {
                    state.setInput(Input.SNEAK, true);
                }
                ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.func_177958_n(), placeAt.func_177956_o(), placeAt.func_177952_p());
                return PlaceResult.READY_TO_PLACE;
            }
        }
        if (found) {
            if (wouldSneak) {
                state.setInput(Input.SNEAK, true);
            }
            ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.func_177958_n(), placeAt.func_177956_o(), placeAt.func_177952_p());
            return PlaceResult.ATTEMPTING;
        }
        return PlaceResult.NO_OPTION;
    }

    public static boolean isTransparent(Block b) {
        return b == Blocks.field_150350_a || b == Blocks.field_150353_l || b == Blocks.field_150355_j;
    }

    public static enum PlaceResult {
        READY_TO_PLACE,
        ATTEMPTING,
        NO_OPTION;

    }
}

