/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import baritone.utils.BlockStateInterface;
import baritone.utils.pathing.MutableMoveResult;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class MovementDiagonal
extends Movement {
    private static final double SQRT_2 = Math.sqrt(2.0);

    public MovementDiagonal(IBaritone baritone, BetterBlockPos start, Direction dir1, Direction dir2, int dy) {
        this(baritone, start, start.offset(dir1), start.offset(dir2), dir2, dy);
    }

    private MovementDiagonal(IBaritone baritone, BetterBlockPos start, BetterBlockPos dir1, BetterBlockPos dir2, Direction drr2, int dy) {
        this(baritone, start, dir1.offset(drr2).up(dy), dir1, dir2);
    }

    private MovementDiagonal(IBaritone baritone, BetterBlockPos start, BetterBlockPos end, BetterBlockPos dir1, BetterBlockPos dir2) {
        super(baritone, start, end, new BetterBlockPos[]{dir1, dir1.up(), dir2, dir2.up(), end, end.up()});
    }

    @Override
    protected boolean safeToCancel(MovementState state) {
        ClientPlayerEntity player = this.ctx.player();
        double offset = 0.25;
        double x = player.func_213303_ch().field_72450_a;
        double y = player.func_213303_ch().field_72448_b - 1.0;
        double z = player.func_213303_ch().field_72449_c;
        if (this.ctx.playerFeet().equals((Object)this.src)) {
            return true;
        }
        if (MovementHelper.canWalkOn(this.ctx, new BlockPos(this.src.field_177962_a, this.src.field_177960_b - 1, this.dest.field_177961_c)) && MovementHelper.canWalkOn(this.ctx, new BlockPos(this.dest.field_177962_a, this.src.field_177960_b - 1, this.src.field_177961_c))) {
            return true;
        }
        if (this.ctx.playerFeet().equals((Object)new BetterBlockPos(this.src.field_177962_a, this.src.field_177960_b, this.dest.field_177961_c)) || this.ctx.playerFeet().equals((Object)new BetterBlockPos(this.dest.field_177962_a, this.src.field_177960_b, this.src.field_177961_c))) {
            return MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x + offset, y, z + offset)) || MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x + offset, y, z - offset)) || MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x - offset, y, z + offset)) || MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x - offset, y, z - offset));
        }
        return true;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDiagonal.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c, this.dest.field_177962_a, this.dest.field_177961_c, result);
        if (result.y != this.dest.field_177960_b) {
            return 1000000.0;
        }
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        BetterBlockPos diagA = new BetterBlockPos(this.src.field_177962_a, this.src.field_177960_b, this.dest.field_177961_c);
        BetterBlockPos diagB = new BetterBlockPos(this.dest.field_177962_a, this.src.field_177960_b, this.src.field_177961_c);
        if (this.dest.field_177960_b < this.src.field_177960_b) {
            return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest.up()), (Object)((Object)diagA), (Object)((Object)diagB), (Object)((Object)this.dest), (Object)((Object)diagA.down()), (Object[])new BetterBlockPos[]{diagB.down()});
        }
        if (this.dest.field_177960_b > this.src.field_177960_b) {
            return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.src.up()), (Object)((Object)diagA), (Object)((Object)diagB), (Object)((Object)this.dest), (Object)((Object)diagA.up()), (Object[])new BetterBlockPos[]{diagB.up()});
        }
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest), (Object)((Object)diagA), (Object)((Object)diagB));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult res) {
        BlockState cuttingOver1;
        BlockState destWalkOn;
        if (!MovementHelper.canWalkThrough(context.bsi, destX, y + 1, destZ)) {
            return;
        }
        BlockState destInto = context.get(destX, y, destZ);
        boolean ascend = false;
        boolean descend = false;
        if (!MovementHelper.canWalkThrough(context.bsi, destX, y, destZ, destInto)) {
            ascend = true;
            if (!(context.allowDiagonalAscend && MovementHelper.canWalkThrough(context.bsi, x, y + 2, z) && MovementHelper.canWalkOn(context.bsi, destX, y, destZ, destInto) && MovementHelper.canWalkThrough(context.bsi, destX, y + 2, destZ))) {
                return;
            }
            destWalkOn = destInto;
        } else {
            destWalkOn = context.get(destX, y - 1, destZ);
            if (!MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, destWalkOn)) {
                descend = true;
                if (!(context.allowDiagonalDescend && MovementHelper.canWalkOn(context.bsi, destX, y - 2, destZ) && MovementHelper.canWalkThrough(context.bsi, destX, y - 1, destZ, destWalkOn))) {
                    return;
                }
            }
        }
        double multiplier = 4.63284688441047;
        if (destWalkOn.func_177230_c() == Blocks.field_150425_aM) {
            multiplier += 2.316423442205235;
        } else if (destWalkOn.func_177230_c() == Blocks.field_150355_j) {
            multiplier += context.walkOnWaterOnePenalty * SQRT_2;
        }
        Block fromDown = context.get(x, y - 1, z).func_177230_c();
        if (fromDown == Blocks.field_150468_ap || fromDown == Blocks.field_150395_bd) {
            return;
        }
        if (fromDown == Blocks.field_150425_aM) {
            multiplier += 2.316423442205235;
        }
        if ((cuttingOver1 = context.get(x, y - 1, destZ)).func_177230_c() == Blocks.field_196814_hQ || MovementHelper.isLava(cuttingOver1)) {
            return;
        }
        BlockState cuttingOver2 = context.get(destX, y - 1, z);
        if (cuttingOver2.func_177230_c() == Blocks.field_196814_hQ || MovementHelper.isLava(cuttingOver2)) {
            return;
        }
        boolean water = false;
        BlockState startState = context.get(x, y, z);
        Block startIn = startState.func_177230_c();
        if (MovementHelper.isWater(startState) || MovementHelper.isWater(destInto)) {
            if (ascend) {
                return;
            }
            multiplier = context.waterWalkSpeed;
            water = true;
        }
        BlockState pb0 = context.get(x, y, destZ);
        BlockState pb2 = context.get(destX, y, z);
        if (ascend) {
            boolean ATop = MovementHelper.canWalkThrough(context.bsi, x, y + 2, destZ);
            boolean AMid = MovementHelper.canWalkThrough(context.bsi, x, y + 1, destZ);
            boolean ALow = MovementHelper.canWalkThrough(context.bsi, x, y, destZ, pb0);
            boolean BTop = MovementHelper.canWalkThrough(context.bsi, destX, y + 2, z);
            boolean BMid = MovementHelper.canWalkThrough(context.bsi, destX, y + 1, z);
            boolean BLow = MovementHelper.canWalkThrough(context.bsi, destX, y, z, pb2);
            if ((!ATop || !AMid || !ALow) && (!BTop || !BMid || !BLow) || MovementHelper.avoidWalkingInto(pb0) || MovementHelper.avoidWalkingInto(pb2) || ATop && AMid && MovementHelper.canWalkOn(context.bsi, x, y, destZ, pb0) || BTop && BMid && MovementHelper.canWalkOn(context.bsi, destX, y, z, pb2) || !ATop && AMid && ALow || !BTop && BMid && BLow) {
                return;
            }
            res.cost = multiplier * SQRT_2 + JUMP_ONE_BLOCK_COST;
            res.x = destX;
            res.z = destZ;
            res.y = y + 1;
            return;
        }
        double optionA = MovementHelper.getMiningDurationTicks(context, x, y, destZ, pb0, false);
        double optionB = MovementHelper.getMiningDurationTicks(context, destX, y, z, pb2, false);
        if (optionA != 0.0 && optionB != 0.0) {
            return;
        }
        BlockState pb1 = context.get(x, y + 1, destZ);
        if ((optionA += MovementHelper.getMiningDurationTicks(context, x, y + 1, destZ, pb1, true)) != 0.0 && optionB != 0.0) {
            return;
        }
        BlockState pb3 = context.get(destX, y + 1, z);
        if (optionA == 0.0 && (MovementHelper.avoidWalkingInto(pb2) && pb2.func_177230_c() != Blocks.field_150355_j || MovementHelper.avoidWalkingInto(pb3))) {
            return;
        }
        if (optionA != 0.0 && (optionB += MovementHelper.getMiningDurationTicks(context, destX, y + 1, z, pb3, true)) != 0.0) {
            return;
        }
        if (optionB == 0.0 && (MovementHelper.avoidWalkingInto(pb0) && pb0.func_177230_c() != Blocks.field_150355_j || MovementHelper.avoidWalkingInto(pb1))) {
            return;
        }
        if (optionA != 0.0 || optionB != 0.0) {
            multiplier *= SQRT_2 - 0.001;
            if (startIn == Blocks.field_150468_ap || startIn == Blocks.field_150395_bd) {
                return;
            }
        } else if (context.canSprint && !water) {
            multiplier *= 0.7692444761225944;
        }
        res.cost = multiplier * SQRT_2;
        if (descend) {
            res.cost += Math.max(FALL_N_BLOCKS_COST[1], 0.9265693768820937);
            res.y = y - 1;
        } else {
            res.y = y;
        }
        res.x = destX;
        res.z = destZ;
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.playerFeet().equals((Object)this.dest)) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        if (!(this.playerInValidPosition() || MovementHelper.isLiquid(this.ctx, this.src) && this.getValidPositions().contains((Object)this.ctx.playerFeet().up()))) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        if (this.dest.field_177960_b > this.src.field_177960_b && this.ctx.player().func_213303_ch().field_72448_b < (double)this.src.field_177960_b + 0.1 && this.ctx.player().field_70123_F) {
            state.setInput(Input.JUMP, true);
        }
        if (this.sprint()) {
            state.setInput(Input.SPRINT, true);
        }
        MovementHelper.moveTowards(this.ctx, state, this.dest);
        return state;
    }

    private boolean sprint() {
        if (MovementHelper.isLiquid(this.ctx, this.ctx.playerFeet()) && !((Boolean)Baritone.settings().sprintInWater.value).booleanValue()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (MovementHelper.canWalkThrough(this.ctx, this.positionsToBreak[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean prepared(MovementState state) {
        return true;
    }

    @Override
    public List<BlockPos> toBreak(BlockStateInterface bsi) {
        if (this.toBreakCached != null) {
            return this.toBreakCached;
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int i = 4; i < 6; ++i) {
            if (MovementHelper.canWalkThrough(bsi, this.positionsToBreak[i].field_177962_a, this.positionsToBreak[i].field_177960_b, this.positionsToBreak[i].field_177961_c)) continue;
            result.add(this.positionsToBreak[i]);
        }
        this.toBreakCached = result;
        return result;
    }

    @Override
    public List<BlockPos> toWalkInto(BlockStateInterface bsi) {
        if (this.toWalkIntoCached == null) {
            this.toWalkIntoCached = new ArrayList();
        }
        ArrayList<BetterBlockPos> result = new ArrayList<BetterBlockPos>();
        for (int i = 0; i < 4; ++i) {
            if (MovementHelper.canWalkThrough(bsi, this.positionsToBreak[i].field_177962_a, this.positionsToBreak[i].field_177960_b, this.positionsToBreak[i].field_177961_c)) continue;
            result.add(this.positionsToBreak[i]);
        }
        this.toWalkIntoCached = result;
        return this.toWalkIntoCached;
    }
}

