/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.VecUtils;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import baritone.pathing.movement.movements.MovementDescend;
import baritone.utils.pathing.MutableMoveResult;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class MovementFall
extends Movement {
    private static final ItemStack STACK_BUCKET_WATER = new ItemStack((IItemProvider)Items.field_151131_as);
    private static final ItemStack STACK_BUCKET_EMPTY = new ItemStack((IItemProvider)Items.field_151133_ar);

    public MovementFall(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, MovementFall.buildPositionsToBreak(src, dest));
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c, this.dest.field_177962_a, this.dest.field_177961_c, result);
        if (result.y != this.dest.field_177960_b) {
            return 1000000.0;
        }
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        HashSet<BetterBlockPos> set = new HashSet<BetterBlockPos>();
        set.add(this.src);
        for (int y = this.src.field_177960_b - this.dest.field_177960_b; y >= 0; --y) {
            set.add(this.dest.up(y));
        }
        return set;
    }

    private boolean willPlaceBucket() {
        CalculationContext context = new CalculationContext(this.baritone);
        MutableMoveResult result = new MutableMoveResult();
        return MovementDescend.dynamicFallCost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c, this.dest.field_177962_a, this.dest.field_177961_c, 0.0, context.get(this.dest.field_177962_a, this.src.field_177960_b - 2, this.dest.field_177961_c), result);
    }

    @Override
    public MovementState updateState(MovementState state) {
        Vector3i avoid;
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        BetterBlockPos playerFeet = this.ctx.playerFeet();
        Rotation toDest = RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), VecUtils.getBlockPosCenter(this.dest), this.ctx.playerRotations());
        Rotation targetRotation = null;
        BlockState destState = this.ctx.world().func_180495_p((BlockPos)this.dest);
        Block destBlock = destState.func_177230_c();
        boolean isWater = destState.func_204520_s().func_206886_c() instanceof WaterFluid;
        if (!isWater && this.willPlaceBucket() && !playerFeet.equals((Object)this.dest)) {
            if (!PlayerInventory.func_184435_e((int)this.ctx.player().field_71071_by.func_184429_b(STACK_BUCKET_WATER)) || this.ctx.world().func_234923_W_() == World.field_234919_h_) {
                return state.setStatus(MovementStatus.UNREACHABLE);
            }
            if (this.ctx.player().func_213303_ch().field_72448_b - (double)this.dest.func_177956_o() < this.ctx.playerController().getBlockReachDistance() && !this.ctx.player().func_233570_aj_()) {
                this.ctx.player().field_71071_by.field_70461_c = this.ctx.player().field_71071_by.func_184429_b(STACK_BUCKET_WATER);
                targetRotation = new Rotation(toDest.getYaw(), 90.0f);
                if (this.ctx.isLookingAt(this.dest) || this.ctx.isLookingAt(this.dest.down())) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
            }
        }
        if (targetRotation != null) {
            state.setTarget(new MovementState.MovementTarget(targetRotation, true));
        } else {
            state.setTarget(new MovementState.MovementTarget(toDest, false));
        }
        if (playerFeet.equals((Object)this.dest) && (this.ctx.player().func_213303_ch().field_72448_b - (double)playerFeet.func_177956_o() < 0.094 || isWater)) {
            if (isWater) {
                if (PlayerInventory.func_184435_e((int)this.ctx.player().field_71071_by.func_184429_b(STACK_BUCKET_EMPTY))) {
                    this.ctx.player().field_71071_by.field_70461_c = this.ctx.player().field_71071_by.func_184429_b(STACK_BUCKET_EMPTY);
                    if (this.ctx.player().func_213322_ci().field_72448_b >= 0.0) {
                        return state.setInput(Input.CLICK_RIGHT, true);
                    }
                    return state;
                }
                if (this.ctx.player().func_213322_ci().field_72448_b >= 0.0) {
                    return state.setStatus(MovementStatus.SUCCESS);
                }
            } else {
                return state.setStatus(MovementStatus.SUCCESS);
            }
        }
        Vector3d destCenter = VecUtils.getBlockPosCenter(this.dest);
        if (Math.abs(this.ctx.player().func_213303_ch().field_72450_a + this.ctx.player().func_213322_ci().field_72450_a - destCenter.field_72450_a) > 0.1 || Math.abs(this.ctx.player().func_213303_ch().field_72449_c + this.ctx.player().func_213322_ci().field_72449_c - destCenter.field_72449_c) > 0.1) {
            if (!this.ctx.player().func_233570_aj_() && Math.abs(this.ctx.player().func_213322_ci().field_72448_b) > 0.4) {
                state.setInput(Input.SNEAK, true);
            }
            state.setInput(Input.MOVE_FORWARD, true);
        }
        if ((avoid = (Vector3i)Optional.ofNullable(this.avoid()).map(Direction::func_176730_m).orElse(null)) == null) {
            avoid = this.src.func_177973_b((Vector3i)this.dest);
        } else {
            double dist = Math.abs((double)avoid.func_177958_n() * (destCenter.field_72450_a - (double)avoid.func_177958_n() / 2.0 - this.ctx.player().func_213303_ch().field_72450_a)) + Math.abs((double)avoid.func_177952_p() * (destCenter.field_72449_c - (double)avoid.func_177952_p() / 2.0 - this.ctx.player().func_213303_ch().field_72449_c));
            if (dist < 0.6) {
                state.setInput(Input.MOVE_FORWARD, true);
            } else if (!this.ctx.player().func_233570_aj_()) {
                state.setInput(Input.SNEAK, false);
            }
        }
        if (targetRotation == null) {
            Vector3d destCenterOffset = new Vector3d(destCenter.field_72450_a + 0.125 * (double)avoid.func_177958_n(), destCenter.field_72448_b, destCenter.field_72449_c + 0.125 * (double)avoid.func_177952_p());
            state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), destCenterOffset, this.ctx.playerRotations()), false));
        }
        return state;
    }

    private Direction avoid() {
        for (int i = 0; i < 15; ++i) {
            BlockState state = this.ctx.world().func_180495_p((BlockPos)this.ctx.playerFeet().down(i));
            if (state.func_177230_c() != Blocks.field_150468_ap) continue;
            return (Direction)state.func_177229_b((Property)LadderBlock.field_176382_a);
        }
        return null;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return this.ctx.playerFeet().equals((Object)this.src) || state.getStatus() != MovementStatus.RUNNING;
    }

    private static BetterBlockPos[] buildPositionsToBreak(BetterBlockPos src, BetterBlockPos dest) {
        int diffX = src.func_177958_n() - dest.func_177958_n();
        int diffZ = src.func_177952_p() - dest.func_177952_p();
        int diffY = src.func_177956_o() - dest.func_177956_o();
        BetterBlockPos[] toBreak = new BetterBlockPos[diffY + 2];
        for (int i = 0; i < toBreak.length; ++i) {
            toBreak[i] = new BetterBlockPos(src.func_177958_n() - diffX, src.func_177956_o() + 1 - i, src.func_177952_p() - diffZ);
        }
        return toBreak;
    }

    @Override
    protected boolean prepared(MovementState state) {
        if (state.getStatus() == MovementStatus.WAITING) {
            return true;
        }
        for (int i = 0; i < 4 && i < this.positionsToBreak.length; ++i) {
            if (MovementHelper.canWalkThrough(this.ctx, this.positionsToBreak[i])) continue;
            return super.prepared(state);
        }
        return true;
    }
}

