/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.VecUtils;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import baritone.utils.BlockStateInterface;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class MovementPillar
extends Movement {
    public MovementPillar(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, new BetterBlockPos[]{start.up(2)}, start);
    }

    @Override
    public double calculateCost(CalculationContext context) {
        return MovementPillar.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c);
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static double cost(CalculationContext context, int x, int y, int z) {
        BlockState fromState = context.get(x, y, z);
        Block from = fromState.func_177230_c();
        boolean ladder = from == Blocks.field_150468_ap || from == Blocks.field_150395_bd;
        BlockState fromDown = context.get(x, y - 1, z);
        if (!ladder) {
            if (fromDown.func_177230_c() == Blocks.field_150468_ap || fromDown.func_177230_c() == Blocks.field_150395_bd) {
                return 1000000.0;
            }
            if (fromDown.func_177230_c() instanceof SlabBlock && fromDown.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
                return 1000000.0;
            }
        }
        if (from == Blocks.field_150395_bd && !MovementPillar.hasAgainst(context, x, y, z)) {
            return 1000000.0;
        }
        BlockState toBreak = context.get(x, y + 2, z);
        Block toBreakBlock = toBreak.func_177230_c();
        if (toBreakBlock instanceof FenceGateBlock) {
            return 1000000.0;
        }
        BlockState srcUp = null;
        if (MovementHelper.isWater(toBreak) && MovementHelper.isWater(fromState) && MovementHelper.isWater(srcUp = context.get(x, y + 1, z))) {
            return 8.51063829787234;
        }
        double placeCost = 0.0;
        if (!ladder) {
            placeCost = context.costOfPlacingAt(x, y, z, fromState);
            if (placeCost >= 1000000.0) {
                return 1000000.0;
            }
            if (fromDown.func_177230_c() instanceof AirBlock) {
                placeCost += 0.1;
            }
        }
        if (MovementHelper.isLiquid(fromState) && !MovementHelper.canPlaceAgainst(context.bsi, x, y - 1, z, fromDown) || MovementHelper.isLiquid(fromDown) && context.assumeWalkOnWater) {
            return 1000000.0;
        }
        double hardness = MovementHelper.getMiningDurationTicks(context, x, y + 2, z, toBreak, true);
        if (hardness >= 1000000.0) {
            return 1000000.0;
        }
        if (hardness != 0.0) {
            if (toBreakBlock == Blocks.field_150468_ap || toBreakBlock == Blocks.field_150395_bd) {
                hardness = 0.0;
            } else {
                BlockState check = context.get(x, y + 3, z);
                if (check.func_177230_c() instanceof FallingBlock) {
                    if (srcUp == null) {
                        srcUp = context.get(x, y + 1, z);
                    }
                    if (!(toBreakBlock instanceof FallingBlock) || !(srcUp.func_177230_c() instanceof FallingBlock)) {
                        return 1000000.0;
                    }
                }
            }
        }
        if (ladder) {
            return 8.51063829787234 + hardness * 5.0;
        }
        return JUMP_ONE_BLOCK_COST + placeCost + context.jumpPenalty + hardness;
    }

    public static boolean hasAgainst(CalculationContext context, int x, int y, int z) {
        return MovementHelper.isBlockNormalCube(context.get(x + 1, y, z)) || MovementHelper.isBlockNormalCube(context.get(x - 1, y, z)) || MovementHelper.isBlockNormalCube(context.get(x, y, z + 1)) || MovementHelper.isBlockNormalCube(context.get(x, y, z - 1));
    }

    public static BlockPos getAgainst(CalculationContext context, BetterBlockPos vine) {
        if (MovementHelper.isBlockNormalCube(context.get(vine.north()))) {
            return vine.north();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.south()))) {
            return vine.south();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.east()))) {
            return vine.east();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.west()))) {
            return vine.west();
        }
        return null;
    }

    @Override
    public MovementState updateState(MovementState state) {
        boolean blockIsThere;
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.playerFeet().field_177960_b < this.src.field_177960_b) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        BlockState fromDown = BlockStateInterface.get(this.ctx, this.src);
        if (MovementHelper.isWater(fromDown) && MovementHelper.isWater(this.ctx, this.dest)) {
            state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), VecUtils.getBlockPosCenter(this.dest), this.ctx.playerRotations()), false));
            Vector3d destCenter = VecUtils.getBlockPosCenter(this.dest);
            if (Math.abs(this.ctx.player().func_213303_ch().field_72450_a - destCenter.field_72450_a) > 0.2 || Math.abs(this.ctx.player().func_213303_ch().field_72449_c - destCenter.field_72449_c) > 0.2) {
                state.setInput(Input.MOVE_FORWARD, true);
            }
            if (this.ctx.playerFeet().equals((Object)this.dest)) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            return state;
        }
        boolean ladder = fromDown.func_177230_c() == Blocks.field_150468_ap || fromDown.func_177230_c() == Blocks.field_150395_bd;
        boolean vine = fromDown.func_177230_c() == Blocks.field_150395_bd;
        Rotation rotation = RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), VecUtils.getBlockPosCenter(this.positionToPlace), new Rotation(this.ctx.player().field_70177_z, this.ctx.player().field_70125_A));
        if (!ladder) {
            state.setTarget(new MovementState.MovementTarget(new Rotation(this.ctx.player().field_70177_z, rotation.getPitch()), true));
        }
        boolean bl = blockIsThere = MovementHelper.canWalkOn(this.ctx, this.src) || ladder;
        if (ladder) {
            BlockPos against;
            Object object = against = vine ? MovementPillar.getAgainst(new CalculationContext(this.baritone), this.src) : this.src.offset(((Direction)fromDown.func_177229_b((Property)LadderBlock.field_176382_a)).func_176734_d());
            if (against == null) {
                this.logDirect("Unable to climb vines. Consider disabling allowVines.");
                return state.setStatus(MovementStatus.UNREACHABLE);
            }
            if (this.ctx.playerFeet().equals(against.func_177984_a()) || this.ctx.playerFeet().equals((Object)this.dest)) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (MovementHelper.isBottomSlab(BlockStateInterface.get(this.ctx, this.src.down()))) {
                state.setInput(Input.JUMP, true);
            }
            MovementHelper.moveTowards(this.ctx, state, against);
            return state;
        }
        if (!((Baritone)this.baritone).getInventoryBehavior().selectThrowawayForLocation(true, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c)) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        state.setInput(Input.SNEAK, this.ctx.player().func_213303_ch().field_72448_b > (double)this.dest.func_177956_o() || this.ctx.player().func_213303_ch().field_72448_b < (double)this.src.func_177956_o() + 0.2);
        double diffX = this.ctx.player().func_213303_ch().field_72450_a - ((double)this.dest.func_177958_n() + 0.5);
        double diffZ = this.ctx.player().func_213303_ch().field_72449_c - ((double)this.dest.func_177952_p() + 0.5);
        double dist = Math.sqrt(diffX * diffX + diffZ * diffZ);
        double flatMotion = Math.sqrt(this.ctx.player().func_213322_ci().field_72450_a * this.ctx.player().func_213322_ci().field_72450_a + this.ctx.player().func_213322_ci().field_72449_c * this.ctx.player().func_213322_ci().field_72449_c);
        if (dist > 0.17) {
            state.setInput(Input.MOVE_FORWARD, true);
            state.setTarget(new MovementState.MovementTarget(rotation, true));
        } else if (flatMotion < 0.05) {
            state.setInput(Input.JUMP, this.ctx.player().func_213303_ch().field_72448_b < (double)this.dest.func_177956_o());
        }
        if (!blockIsThere) {
            BlockState frState = BlockStateInterface.get(this.ctx, this.src);
            Block fr = frState.func_177230_c();
            if (!(fr instanceof AirBlock) && !frState.func_185904_a().func_76222_j()) {
                RotationUtils.reachable(this.ctx.player(), (BlockPos)this.src, this.ctx.playerController().getBlockReachDistance()).map(rot -> new MovementState.MovementTarget((Rotation)rot, true)).ifPresent(state::setTarget);
                state.setInput(Input.JUMP, false);
                state.setInput(Input.CLICK_LEFT, true);
                blockIsThere = false;
            } else if (this.ctx.player().func_213453_ef() && (this.ctx.isLookingAt(this.src.down()) || this.ctx.isLookingAt(this.src)) && this.ctx.player().func_213303_ch().field_72448_b > (double)this.dest.func_177956_o() + 0.1) {
                state.setInput(Input.CLICK_RIGHT, true);
            }
        }
        if (this.ctx.playerFeet().equals((Object)this.dest) && blockIsThere) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        return state;
    }

    @Override
    protected boolean prepared(MovementState state) {
        Block block;
        if ((this.ctx.playerFeet().equals((Object)this.src) || this.ctx.playerFeet().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == Blocks.field_150468_ap || block == Blocks.field_150395_bd)) {
            state.setInput(Input.SNEAK, true);
        }
        if (MovementHelper.isWater(this.ctx, this.dest.up())) {
            return true;
        }
        return super.prepared(state);
    }
}

