/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.VecUtils;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import baritone.pathing.movement.movements.MovementPillar;
import baritone.utils.BlockStateInterface;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class MovementTraverse
extends Movement {
    private boolean wasTheBridgeBlockAlwaysThere = true;

    public MovementTraverse(IBaritone baritone, BetterBlockPos from, BetterBlockPos to) {
        super(baritone, from, to, new BetterBlockPos[]{to.up(), to}, to.down());
    }

    @Override
    public void reset() {
        super.reset();
        this.wasTheBridgeBlockAlwaysThere = true;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        return MovementTraverse.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c, this.dest.field_177962_a, this.dest.field_177961_c);
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static double cost(CalculationContext context, int x, int y, int z, int destX, int destZ) {
        BlockState pb0 = context.get(destX, y + 1, destZ);
        BlockState pb1 = context.get(destX, y, destZ);
        BlockState destOn = context.get(destX, y - 1, destZ);
        BlockState down = context.get(x, y - 1, z);
        Block srcDown = down.func_177230_c();
        if (MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, destOn)) {
            double WC = 4.63284688441047;
            boolean water = false;
            if (MovementHelper.isWater(pb0) || MovementHelper.isWater(pb1)) {
                WC = context.waterWalkSpeed;
                water = true;
            } else {
                if (destOn.func_177230_c() == Blocks.field_150425_aM) {
                    WC += 2.316423442205235;
                } else if (destOn.func_177230_c() == Blocks.field_150355_j) {
                    WC += context.walkOnWaterOnePenalty;
                }
                if (srcDown == Blocks.field_150425_aM) {
                    WC += 2.316423442205235;
                }
            }
            double hardness1 = MovementHelper.getMiningDurationTicks(context, destX, y, destZ, pb1, false);
            if (hardness1 >= 1000000.0) {
                return 1000000.0;
            }
            double hardness2 = MovementHelper.getMiningDurationTicks(context, destX, y + 1, destZ, pb0, true);
            if (hardness1 == 0.0 && hardness2 == 0.0) {
                if (!water && context.canSprint) {
                    WC *= 0.7692444761225944;
                }
                return WC;
            }
            if (srcDown == Blocks.field_150468_ap || srcDown == Blocks.field_150395_bd) {
                hardness1 *= 5.0;
                hardness2 *= 5.0;
            }
            return WC + hardness1 + hardness2;
        }
        if (srcDown == Blocks.field_150468_ap || srcDown == Blocks.field_150395_bd) {
            return 1000000.0;
        }
        if (MovementHelper.isReplaceable(destX, y - 1, destZ, destOn, context.bsi)) {
            boolean throughWater;
            boolean bl = throughWater = MovementHelper.isWater(pb0) || MovementHelper.isWater(pb1);
            if (MovementHelper.isWater(destOn) && throughWater) {
                return 1000000.0;
            }
            double placeCost = context.costOfPlacingAt(destX, y - 1, destZ, destOn);
            if (placeCost >= 1000000.0) {
                return 1000000.0;
            }
            double hardness1 = MovementHelper.getMiningDurationTicks(context, destX, y, destZ, pb1, false);
            if (hardness1 >= 1000000.0) {
                return 1000000.0;
            }
            double hardness2 = MovementHelper.getMiningDurationTicks(context, destX, y + 1, destZ, pb0, true);
            double WC = throughWater ? context.waterWalkSpeed : 4.63284688441047;
            for (int i = 0; i < 5; ++i) {
                int againstX = destX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].func_82601_c();
                int againstY = y - 1 + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].func_96559_d();
                int againstZ = destZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].func_82599_e();
                if (againstX == x && againstZ == z || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
                return WC + placeCost + hardness1 + hardness2;
            }
            if (srcDown == Blocks.field_150425_aM || srcDown instanceof SlabBlock && down.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
                return 1000000.0;
            }
            if (down.func_204520_s().func_206886_c() instanceof WaterFluid) {
                return 1000000.0;
            }
            return (WC *= 3.3207692307692307) + placeCost + hardness1 + hardness2;
        }
        return 1000000.0;
    }

    @Override
    public MovementState updateState(MovementState state) {
        double dist;
        boolean ladder;
        super.updateState(state);
        BlockState pb0 = BlockStateInterface.get(this.ctx, this.positionsToBreak[0]);
        BlockState pb1 = BlockStateInterface.get(this.ctx, this.positionsToBreak[1]);
        if (state.getStatus() != MovementStatus.RUNNING) {
            if (!((Boolean)Baritone.settings().walkWhileBreaking.value).booleanValue()) {
                return state;
            }
            if (state.getStatus() != MovementStatus.PREPPING) {
                return state;
            }
            if (MovementHelper.avoidWalkingInto(pb0)) {
                return state;
            }
            if (MovementHelper.avoidWalkingInto(pb1)) {
                return state;
            }
            double dist2 = Math.max(Math.abs(this.ctx.player().func_213303_ch().field_72450_a - ((double)this.dest.func_177958_n() + 0.5)), Math.abs(this.ctx.player().func_213303_ch().field_72449_c - ((double)this.dest.func_177952_p() + 0.5)));
            if (dist2 < 0.83) {
                return state;
            }
            if (!state.getTarget().getRotation().isPresent()) {
                return state;
            }
            float yawToDest = RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), VecUtils.calculateBlockCenter(this.ctx.world(), this.dest), this.ctx.playerRotations()).getYaw();
            float pitchToBreak = state.getTarget().getRotation().get().getPitch();
            if (MovementHelper.isBlockNormalCube(pb0) || pb0.func_177230_c() instanceof AirBlock && (MovementHelper.isBlockNormalCube(pb1) || pb1.func_177230_c() instanceof AirBlock)) {
                pitchToBreak = 26.0f;
            }
            return state.setTarget(new MovementState.MovementTarget(new Rotation(yawToDest, pitchToBreak), true)).setInput(Input.MOVE_FORWARD, true).setInput(Input.SPRINT, true);
        }
        state.setInput(Input.SNEAK, false);
        Block fd = BlockStateInterface.get(this.ctx, this.src.down()).func_177230_c();
        boolean bl = ladder = fd == Blocks.field_150468_ap || fd == Blocks.field_150395_bd;
        if (pb0.func_177230_c() instanceof DoorBlock || pb1.func_177230_c() instanceof DoorBlock) {
            boolean canOpen;
            boolean notPassable = pb0.func_177230_c() instanceof DoorBlock && !MovementHelper.isDoorPassable(this.ctx, this.src, this.dest) || pb1.func_177230_c() instanceof DoorBlock && !MovementHelper.isDoorPassable(this.ctx, this.dest, this.src);
            boolean bl2 = canOpen = !Blocks.field_150454_av.equals(pb0.func_177230_c()) && !Blocks.field_150454_av.equals(pb1.func_177230_c());
            if (notPassable && canOpen) {
                return state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), VecUtils.calculateBlockCenter(this.ctx.world(), this.positionsToBreak[0]), this.ctx.playerRotations()), true)).setInput(Input.CLICK_RIGHT, true);
            }
        }
        if (pb0.func_177230_c() instanceof FenceGateBlock || pb1.func_177230_c() instanceof FenceGateBlock) {
            Optional<Rotation> rotation;
            BetterBlockPos blocked;
            BetterBlockPos betterBlockPos = !MovementHelper.isGatePassable(this.ctx, this.positionsToBreak[0], this.src.up()) ? this.positionsToBreak[0] : (blocked = !MovementHelper.isGatePassable(this.ctx, this.positionsToBreak[1], this.src) ? this.positionsToBreak[1] : null);
            if (blocked != null && (rotation = RotationUtils.reachable(this.ctx, blocked)).isPresent()) {
                return state.setTarget(new MovementState.MovementTarget(rotation.get(), true)).setInput(Input.CLICK_RIGHT, true);
            }
        }
        boolean isTheBridgeBlockThere = MovementHelper.canWalkOn(this.ctx, this.positionToPlace) || ladder;
        BetterBlockPos feet = this.ctx.playerFeet();
        if (feet.func_177956_o() != this.dest.func_177956_o() && !ladder) {
            this.logDebug("Wrong Y coordinate");
            if (feet.func_177956_o() < this.dest.func_177956_o()) {
                return state.setInput(Input.JUMP, true);
            }
            return state;
        }
        if (isTheBridgeBlockThere) {
            if (feet.equals((Object)this.dest)) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (((Boolean)Baritone.settings().overshootTraverse.value).booleanValue() && (feet.equals(this.dest.func_177971_a((Vector3i)this.getDirection())) || feet.equals(this.dest.func_177971_a((Vector3i)this.getDirection()).func_177971_a((Vector3i)this.getDirection())))) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            Block low = BlockStateInterface.get(this.ctx, this.src).func_177230_c();
            Block high = BlockStateInterface.get(this.ctx, this.src.up()).func_177230_c();
            if (this.ctx.player().func_213303_ch().field_72448_b > (double)this.src.field_177960_b + 0.1 && !this.ctx.player().func_233570_aj_() && (low == Blocks.field_150395_bd || low == Blocks.field_150468_ap || high == Blocks.field_150395_bd || high == Blocks.field_150468_ap)) {
                return state;
            }
            BlockPos into = this.dest.func_177973_b((Vector3i)this.src).func_177971_a((Vector3i)this.dest);
            BlockState intoBelow = BlockStateInterface.get(this.ctx, into);
            BlockState intoAbove = BlockStateInterface.get(this.ctx, into.func_177984_a());
            if (!(!this.wasTheBridgeBlockAlwaysThere || MovementHelper.isLiquid(this.ctx, feet) && !((Boolean)Baritone.settings().sprintInWater.value).booleanValue() || MovementHelper.avoidWalkingInto(intoBelow) && !MovementHelper.isWater(intoBelow) || MovementHelper.avoidWalkingInto(intoAbove))) {
                state.setInput(Input.SPRINT, true);
            }
            BlockState destDown = BlockStateInterface.get(this.ctx, this.dest.down());
            BetterBlockPos against = this.positionsToBreak[0];
            if (feet.func_177956_o() != this.dest.func_177956_o() && ladder && (destDown.func_177230_c() == Blocks.field_150395_bd || destDown.func_177230_c() == Blocks.field_150468_ap)) {
                BetterBlockPos betterBlockPos = against = destDown.func_177230_c() == Blocks.field_150395_bd ? MovementPillar.getAgainst(new CalculationContext(this.baritone), this.dest.down()) : this.dest.offset(((Direction)destDown.func_177229_b((Property)LadderBlock.field_176382_a)).func_176734_d());
                if (against == null) {
                    this.logDirect("Unable to climb vines. Consider disabling allowVines.");
                    return state.setStatus(MovementStatus.UNREACHABLE);
                }
            }
            MovementHelper.moveTowards(this.ctx, state, against);
            return state;
        }
        this.wasTheBridgeBlockAlwaysThere = false;
        Block standingOn = BlockStateInterface.get(this.ctx, feet.func_177977_b()).func_177230_c();
        if ((standingOn.equals(Blocks.field_150425_aM) || standingOn instanceof SlabBlock) && (dist = Math.max(Math.abs((double)this.dest.func_177958_n() + 0.5 - this.ctx.player().func_213303_ch().field_72450_a), Math.abs((double)this.dest.func_177952_p() + 0.5 - this.ctx.player().func_213303_ch().field_72449_c))) < 0.85) {
            MovementHelper.moveTowards(this.ctx, state, this.dest);
            return state.setInput(Input.MOVE_FORWARD, false).setInput(Input.MOVE_BACK, true);
        }
        double dist1 = Math.max(Math.abs(this.ctx.player().func_213303_ch().field_72450_a - ((double)this.dest.func_177958_n() + 0.5)), Math.abs(this.ctx.player().func_213303_ch().field_72449_c - ((double)this.dest.func_177952_p() + 0.5)));
        MovementHelper.PlaceResult p = MovementHelper.attemptToPlaceABlock(state, this.baritone, this.dest.down(), false, true);
        if ((p == MovementHelper.PlaceResult.READY_TO_PLACE || dist1 < 0.6) && !((Boolean)Baritone.settings().assumeSafeWalk.value).booleanValue()) {
            state.setInput(Input.SNEAK, true);
        }
        switch (p) {
            case READY_TO_PLACE: {
                if (this.ctx.player().func_213453_ef() || ((Boolean)Baritone.settings().assumeSafeWalk.value).booleanValue()) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
                return state;
            }
            case ATTEMPTING: {
                if (dist1 > 0.83) {
                    float yaw = RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), VecUtils.getBlockPosCenter(this.dest), this.ctx.playerRotations()).getYaw();
                    if ((double)Math.abs(state.getTarget().rotation.getYaw() - yaw) < 0.1) {
                        return state.setInput(Input.MOVE_FORWARD, true);
                    }
                } else if (this.ctx.playerRotations().isReallyCloseTo(state.getTarget().rotation)) {
                    return state.setInput(Input.CLICK_LEFT, true);
                }
                return state;
            }
        }
        if (feet.equals((Object)this.dest)) {
            double faceX = ((double)(this.dest.func_177958_n() + this.src.func_177958_n()) + 1.0) * 0.5;
            double faceY = ((double)(this.dest.func_177956_o() + this.src.func_177956_o()) - 1.0) * 0.5;
            double faceZ = ((double)(this.dest.func_177952_p() + this.src.func_177952_p()) + 1.0) * 0.5;
            BetterBlockPos goalLook = this.src.down();
            Rotation backToFace = RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), new Vector3d(faceX, faceY, faceZ), this.ctx.playerRotations());
            float pitch = backToFace.getPitch();
            double dist2 = Math.max(Math.abs(this.ctx.player().func_213303_ch().field_72450_a - faceX), Math.abs(this.ctx.player().func_213303_ch().field_72449_c - faceZ));
            if (dist2 < 0.29) {
                float yaw = RotationUtils.calcRotationFromVec3d(VecUtils.getBlockPosCenter(this.dest), this.ctx.playerHead(), this.ctx.playerRotations()).getYaw();
                state.setTarget(new MovementState.MovementTarget(new Rotation(yaw, pitch), true));
                state.setInput(Input.MOVE_BACK, true);
            } else {
                state.setTarget(new MovementState.MovementTarget(backToFace, true));
            }
            if (this.ctx.isLookingAt(goalLook)) {
                return state.setInput(Input.CLICK_RIGHT, true);
            }
            if (this.ctx.playerRotations().isReallyCloseTo(state.getTarget().rotation)) {
                state.setInput(Input.CLICK_LEFT, true);
            }
            return state;
        }
        MovementHelper.moveTowards(this.ctx, state, this.positionsToBreak[0]);
        return state;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || MovementHelper.canWalkOn(this.ctx, this.dest.down());
    }

    @Override
    protected boolean prepared(MovementState state) {
        Block block;
        if ((this.ctx.playerFeet().equals((Object)this.src) || this.ctx.playerFeet().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == Blocks.field_150468_ap || block == Blocks.field_150395_bd)) {
            state.setInput(Input.SNEAK, true);
        }
        return super.prepared(state);
    }
}

