/*
 * Decompiled with CFR 0.152.
 */
package baritone.process;

import baritone.Baritone;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.pathing.goals.GoalComposite;
import baritone.api.pathing.goals.GoalGetToBlock;
import baritone.api.process.IBuilderProcess;
import baritone.api.process.PathingCommand;
import baritone.api.process.PathingCommandType;
import baritone.api.schematic.FillSchematic;
import baritone.api.schematic.ISchematic;
import baritone.api.schematic.IStaticSchematic;
import baritone.api.schematic.format.ISchematicFormat;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.utils.BaritoneProcessHelper;
import baritone.utils.BlockStateInterface;
import baritone.utils.NotificationHelper;
import baritone.utils.PathingCommandContext;
import baritone.utils.schematic.MapArtSchematic;
import baritone.utils.schematic.SchematicSystem;
import baritone.utils.schematic.schematica.SchematicaHelper;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public final class BuilderProcess
extends BaritoneProcessHelper
implements IBuilderProcess {
    private HashSet<BetterBlockPos> incorrectPositions;
    private LongOpenHashSet observedCompleted;
    private String name;
    private ISchematic realSchematic;
    private ISchematic schematic;
    private Vector3i origin;
    private int ticks;
    private boolean paused;
    private int layer;
    private int numRepeats;
    private List<BlockState> approxPlaceable;

    public BuilderProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void build(String name, ISchematic schematic, Vector3i origin) {
        this.name = name;
        this.schematic = schematic;
        this.realSchematic = null;
        int x = origin.func_177958_n();
        int y = origin.func_177956_o();
        int z = origin.func_177952_p();
        if (((Boolean)Baritone.settings().schematicOrientationX.value).booleanValue()) {
            x += schematic.widthX();
        }
        if (((Boolean)Baritone.settings().schematicOrientationY.value).booleanValue()) {
            y += schematic.heightY();
        }
        if (((Boolean)Baritone.settings().schematicOrientationZ.value).booleanValue()) {
            z += schematic.lengthZ();
        }
        this.origin = new Vector3i(x, y, z);
        this.paused = false;
        this.layer = (Integer)Baritone.settings().startAtLayer.value;
        this.numRepeats = 0;
        this.observedCompleted = new LongOpenHashSet();
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean build(String name, File schematic, Vector3i origin) {
        ISchematic parsed;
        Optional<ISchematicFormat> format = SchematicSystem.INSTANCE.getByFile(schematic);
        if (!format.isPresent()) {
            return false;
        }
        try {
            parsed = format.get().parse(new FileInputStream(schematic));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (((Boolean)Baritone.settings().mapArtMode.value).booleanValue()) {
            parsed = new MapArtSchematic((IStaticSchematic)parsed);
        }
        this.build(name, parsed, origin);
        return true;
    }

    @Override
    public void buildOpenSchematic() {
        if (SchematicaHelper.isSchematicaPresent()) {
            Optional<Tuple<IStaticSchematic, BlockPos>> schematic = SchematicaHelper.getOpenSchematic();
            if (schematic.isPresent()) {
                IStaticSchematic s = (IStaticSchematic)schematic.get().func_76341_a();
                this.build(((IStaticSchematic)schematic.get().func_76341_a()).toString(), (Boolean)Baritone.settings().mapArtMode.value != false ? new MapArtSchematic(s) : s, (Vector3i)schematic.get().func_76340_b());
            } else {
                this.logDirect("No schematic currently open");
            }
        } else {
            this.logDirect("Schematica is not present");
        }
    }

    @Override
    public void clearArea(BlockPos corner1, BlockPos corner2) {
        BlockPos origin = new BlockPos(Math.min(corner1.func_177958_n(), corner2.func_177958_n()), Math.min(corner1.func_177956_o(), corner2.func_177956_o()), Math.min(corner1.func_177952_p(), corner2.func_177952_p()));
        int widthX = Math.abs(corner1.func_177958_n() - corner2.func_177958_n()) + 1;
        int heightY = Math.abs(corner1.func_177956_o() - corner2.func_177956_o()) + 1;
        int lengthZ = Math.abs(corner1.func_177952_p() - corner2.func_177952_p()) + 1;
        this.build("clear area", new FillSchematic(widthX, heightY, lengthZ, Blocks.field_150350_a.func_176223_P()), (Vector3i)origin);
    }

    @Override
    public List<BlockState> getApproxPlaceable() {
        return new ArrayList<BlockState>(this.approxPlaceable);
    }

    @Override
    public boolean isActive() {
        return this.schematic != null;
    }

    public BlockState placeAt(int x, int y, int z, BlockState current) {
        if (!this.isActive()) {
            return null;
        }
        if (!this.schematic.inSchematic(x - this.origin.func_177958_n(), y - this.origin.func_177956_o(), z - this.origin.func_177952_p(), current)) {
            return null;
        }
        BlockState state = this.schematic.desiredState(x - this.origin.func_177958_n(), y - this.origin.func_177956_o(), z - this.origin.func_177952_p(), current, this.approxPlaceable);
        if (state.func_177230_c() instanceof AirBlock) {
            return null;
        }
        return state;
    }

    private Optional<Tuple<BetterBlockPos, Rotation>> toBreakNearPlayer(BuilderCalculationContext bcc) {
        BetterBlockPos center = this.ctx.playerFeet();
        BetterBlockPos pathStart = this.baritone.getPathingBehavior().pathStart();
        for (int dx = -5; dx <= 5; ++dx) {
            int dy;
            int n = dy = (Boolean)Baritone.settings().breakFromAbove.value != false ? -1 : 0;
            while (dy <= 5) {
                for (int dz = -5; dz <= 5; ++dz) {
                    BlockState curr;
                    BlockState desired;
                    int x = center.field_177962_a + dx;
                    int y = center.field_177960_b + dy;
                    int z = center.field_177961_c + dz;
                    if (dy == -1 && x == pathStart.field_177962_a && z == pathStart.field_177961_c || (desired = bcc.getSchematic(x, y, z, bcc.bsi.get0(x, y, z))) == null || (curr = bcc.bsi.get0(x, y, z)).func_177230_c() instanceof AirBlock || curr.func_177230_c() == Blocks.field_150355_j || curr.func_177230_c() == Blocks.field_150353_l || this.valid(curr, desired, false)) continue;
                    BetterBlockPos pos = new BetterBlockPos(x, y, z);
                    Optional<Rotation> rot = RotationUtils.reachable(this.ctx.player(), (BlockPos)pos, this.ctx.playerController().getBlockReachDistance());
                    if (!rot.isPresent()) continue;
                    return Optional.of(new Tuple((Object)pos, (Object)rot.get()));
                }
                ++dy;
            }
        }
        return Optional.empty();
    }

    private Optional<Placement> searchForPlacables(BuilderCalculationContext bcc, List<BlockState> desirableOnHotbar) {
        BetterBlockPos center = this.ctx.playerFeet();
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 1; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    BlockState curr;
                    int x = center.field_177962_a + dx;
                    int y = center.field_177960_b + dy;
                    int z = center.field_177961_c + dz;
                    BlockState desired = bcc.getSchematic(x, y, z, bcc.bsi.get0(x, y, z));
                    if (desired == null || !MovementHelper.isReplaceable(x, y, z, curr = bcc.bsi.get0(x, y, z), bcc.bsi) || this.valid(curr, desired, false) || dy == 1 && bcc.bsi.get0(x, y + 1, z).func_177230_c() instanceof AirBlock) continue;
                    desirableOnHotbar.add(desired);
                    Optional<Placement> opt = this.possibleToPlace(desired, x, y, z, bcc.bsi);
                    if (!opt.isPresent()) continue;
                    return opt;
                }
            }
        }
        return Optional.empty();
    }

    public boolean placementPlausible(BlockPos pos, BlockState state) {
        VoxelShape voxelshape = state.func_196952_d((IBlockReader)this.ctx.world(), pos);
        return voxelshape.func_197766_b() || this.ctx.world().func_195585_a(null, voxelshape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    private Optional<Placement> possibleToPlace(BlockState toPlace, int x, int y, int z, BlockStateInterface bsi) {
        for (Direction against : Direction.values()) {
            BetterBlockPos placeAgainstPos = new BetterBlockPos(x, y, z).offset(against);
            BlockState placeAgainstState = bsi.get0(placeAgainstPos);
            if (MovementHelper.isReplaceable(placeAgainstPos.field_177962_a, placeAgainstPos.field_177960_b, placeAgainstPos.field_177961_c, placeAgainstState, bsi) || !toPlace.func_196955_c((IWorldReader)this.ctx.world(), (BlockPos)new BetterBlockPos(x, y, z)) || !this.placementPlausible(new BetterBlockPos(x, y, z), toPlace)) continue;
            AxisAlignedBB aabb = placeAgainstState.func_196954_c((IBlockReader)this.ctx.world(), (BlockPos)placeAgainstPos).func_197752_a();
            for (Vector3d placementMultiplier : BuilderProcess.aabbSideMultipliers(against)) {
                OptionalInt hotbar;
                double placeX = (double)placeAgainstPos.field_177962_a + aabb.field_72340_a * placementMultiplier.field_72450_a + aabb.field_72336_d * (1.0 - placementMultiplier.field_72450_a);
                double placeY = (double)placeAgainstPos.field_177960_b + aabb.field_72338_b * placementMultiplier.field_72448_b + aabb.field_72337_e * (1.0 - placementMultiplier.field_72448_b);
                double placeZ = (double)placeAgainstPos.field_177961_c + aabb.field_72339_c * placementMultiplier.field_72449_c + aabb.field_72334_f * (1.0 - placementMultiplier.field_72449_c);
                Rotation rot = RotationUtils.calcRotationFromVec3d(RayTraceUtils.inferSneakingEyePosition((Entity)this.ctx.player()), new Vector3d(placeX, placeY, placeZ), this.ctx.playerRotations());
                RayTraceResult result = RayTraceUtils.rayTraceTowards((Entity)this.ctx.player(), rot, this.ctx.playerController().getBlockReachDistance(), true);
                if (result == null || result.func_216346_c() != RayTraceResult.Type.BLOCK || !((BlockRayTraceResult)result).func_216350_a().equals((Object)placeAgainstPos) || ((BlockRayTraceResult)result).func_216354_b() != against.func_176734_d() || !(hotbar = this.hasAnyItemThatWouldPlace(toPlace, result, rot)).isPresent()) continue;
                return Optional.of(new Placement(hotbar.getAsInt(), placeAgainstPos, against.func_176734_d(), rot));
            }
        }
        return Optional.empty();
    }

    private OptionalInt hasAnyItemThatWouldPlace(BlockState desired, RayTraceResult result, Rotation rot) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)this.ctx.player().field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) continue;
            float originalYaw = this.ctx.player().field_70177_z;
            float originalPitch = this.ctx.player().field_70125_A;
            this.ctx.player().field_70177_z = rot.getYaw();
            this.ctx.player().field_70125_A = rot.getPitch();
            BlockItemUseContext meme = new BlockItemUseContext(new ItemUseContext(this.ctx.world(), (PlayerEntity)this.ctx.player(), Hand.MAIN_HAND, stack, (BlockRayTraceResult)result){});
            BlockState wouldBePlaced = ((BlockItem)stack.func_77973_b()).func_179223_d().func_196258_a(meme);
            this.ctx.player().field_70177_z = originalYaw;
            this.ctx.player().field_70125_A = originalPitch;
            if (wouldBePlaced == null || !meme.func_196011_b() || !this.valid(wouldBePlaced, desired, true)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static Vector3d[] aabbSideMultipliers(Direction side) {
        switch (side) {
            case UP: {
                return new Vector3d[]{new Vector3d(0.5, 1.0, 0.5), new Vector3d(0.1, 1.0, 0.5), new Vector3d(0.9, 1.0, 0.5), new Vector3d(0.5, 1.0, 0.1), new Vector3d(0.5, 1.0, 0.9)};
            }
            case DOWN: {
                return new Vector3d[]{new Vector3d(0.5, 0.0, 0.5), new Vector3d(0.1, 0.0, 0.5), new Vector3d(0.9, 0.0, 0.5), new Vector3d(0.5, 0.0, 0.1), new Vector3d(0.5, 0.0, 0.9)};
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                double x = side.func_82601_c() == 0 ? 0.5 : (double)(1 + side.func_82601_c()) / 2.0;
                double z = side.func_82599_e() == 0 ? 0.5 : (double)(1 + side.func_82599_e()) / 2.0;
                return new Vector3d[]{new Vector3d(x, 0.25, z), new Vector3d(x, 0.75, z)};
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        Goal goal;
        Optional<Tuple<BetterBlockPos, Rotation>> toBreak;
        BuilderCalculationContext bcc;
        this.approxPlaceable = this.approxPlaceable(36);
        this.ticks = this.baritone.getInputOverrideHandler().isInputForcedDown(Input.CLICK_LEFT) ? 5 : --this.ticks;
        this.baritone.getInputOverrideHandler().clearAllKeys();
        if (this.paused) {
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        if (((Boolean)Baritone.settings().buildInLayers.value).booleanValue()) {
            int minYInclusive;
            int maxYInclusive;
            if (this.realSchematic == null) {
                this.realSchematic = this.schematic;
            }
            final ISchematic realSchematic = this.realSchematic;
            if (((Boolean)Baritone.settings().layerOrder.value).booleanValue()) {
                maxYInclusive = realSchematic.heightY() - 1;
                minYInclusive = realSchematic.heightY() - this.layer;
            } else {
                maxYInclusive = this.layer - 1;
                minYInclusive = 0;
            }
            this.schematic = new ISchematic(){

                @Override
                public BlockState desiredState(int x, int y, int z, BlockState current, List<BlockState> approxPlaceable) {
                    return realSchematic.desiredState(x, y, z, current, BuilderProcess.this.approxPlaceable);
                }

                @Override
                public boolean inSchematic(int x, int y, int z, BlockState currentState) {
                    return ISchematic.super.inSchematic(x, y, z, currentState) && y >= minYInclusive && y <= maxYInclusive && realSchematic.inSchematic(x, y, z, currentState);
                }

                @Override
                public int widthX() {
                    return realSchematic.widthX();
                }

                @Override
                public int heightY() {
                    return realSchematic.heightY();
                }

                @Override
                public int lengthZ() {
                    return realSchematic.lengthZ();
                }
            };
        }
        if (!this.recalc(bcc = new BuilderCalculationContext())) {
            if (((Boolean)Baritone.settings().buildInLayers.value).booleanValue() && this.layer < this.realSchematic.heightY()) {
                this.logDirect("Starting layer " + this.layer);
                ++this.layer;
                return this.onTick(calcFailed, isSafeToCancel);
            }
            Vector3i repeat = (Vector3i)Baritone.settings().buildRepeat.value;
            int max = (Integer)Baritone.settings().buildRepeatCount.value;
            ++this.numRepeats;
            if (repeat.equals((Object)new Vector3i(0, 0, 0)) || max != -1 && this.numRepeats >= max) {
                this.logDirect("Done building");
                if (((Boolean)Baritone.settings().desktopNotifications.value).booleanValue() && ((Boolean)Baritone.settings().notificationOnBuildFinished.value).booleanValue()) {
                    NotificationHelper.notify("Done building", false);
                }
                this.onLostControl();
                return null;
            }
            this.layer = 0;
            this.origin = new BlockPos(this.origin).func_177971_a(repeat);
            this.logDirect("Repeating build in vector " + repeat + ", new origin is " + this.origin);
            return this.onTick(calcFailed, isSafeToCancel);
        }
        if (((Boolean)Baritone.settings().distanceTrim.value).booleanValue()) {
            this.trim();
        }
        if ((toBreak = this.toBreakNearPlayer(bcc)).isPresent() && isSafeToCancel && this.ctx.player().func_233570_aj_()) {
            Rotation rot = (Rotation)toBreak.get().func_76340_b();
            BetterBlockPos pos = (BetterBlockPos)((Object)toBreak.get().func_76341_a());
            this.baritone.getLookBehavior().updateTarget(rot, true);
            MovementHelper.switchToBestToolFor(this.ctx, bcc.get(pos));
            if (this.ctx.player().func_213453_ef()) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.SNEAK, true);
            }
            if (this.ctx.isLookingAt(pos) || this.ctx.playerRotations().isReallyCloseTo(rot)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        ArrayList<BlockState> desirableOnHotbar = new ArrayList<BlockState>();
        Optional<Placement> toPlace = this.searchForPlacables(bcc, desirableOnHotbar);
        if (toPlace.isPresent() && isSafeToCancel && this.ctx.player().func_233570_aj_() && this.ticks <= 0) {
            Rotation rot = toPlace.get().rot;
            this.baritone.getLookBehavior().updateTarget(rot, true);
            this.ctx.player().field_71071_by.field_70461_c = toPlace.get().hotbarSelection;
            this.baritone.getInputOverrideHandler().setInputForceState(Input.SNEAK, true);
            if (this.ctx.isLookingAt(toPlace.get().placeAgainst) && ((BlockRayTraceResult)this.ctx.objectMouseOver()).func_216354_b().equals((Object)toPlace.get().side) || this.ctx.playerRotations().isReallyCloseTo(rot)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        if (((Boolean)Baritone.settings().allowInventory.value).booleanValue()) {
            ArrayList<Integer> usefulSlots = new ArrayList<Integer>();
            ArrayList<BlockState> noValidHotbarOption = new ArrayList<BlockState>();
            block0: for (BlockState desired : desirableOnHotbar) {
                for (int i = 0; i < 9; ++i) {
                    if (!this.valid(this.approxPlaceable.get(i), desired, true)) continue;
                    usefulSlots.add(i);
                    continue block0;
                }
                noValidHotbarOption.add(desired);
            }
            block2: for (int i = 9; i < 36; ++i) {
                for (BlockState desired : noValidHotbarOption) {
                    if (!this.valid(this.approxPlaceable.get(i), desired, true)) continue;
                    this.baritone.getInventoryBehavior().attemptToPutOnHotbar(i, usefulSlots::contains);
                    break block2;
                }
            }
        }
        if ((goal = this.assemble(bcc, this.approxPlaceable.subList(0, 9))) == null && (goal = this.assemble(bcc, this.approxPlaceable)) == null) {
            this.logDirect("Unable to do it. Pausing. resume to resume, cancel to cancel");
            this.paused = true;
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        return new PathingCommandContext(goal, PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH, bcc);
    }

    private boolean recalc(BuilderCalculationContext bcc) {
        if (this.incorrectPositions == null) {
            this.incorrectPositions = new HashSet();
            this.fullRecalc(bcc);
            if (this.incorrectPositions.isEmpty()) {
                return false;
            }
        }
        this.recalcNearby(bcc);
        if (this.incorrectPositions.isEmpty()) {
            this.fullRecalc(bcc);
        }
        return !this.incorrectPositions.isEmpty();
    }

    private void trim() {
        HashSet<BetterBlockPos> copy = new HashSet<BetterBlockPos>(this.incorrectPositions);
        copy.removeIf(pos -> pos.func_177951_i((Vector3i)this.ctx.player().func_233580_cy_()) > 200.0);
        if (!copy.isEmpty()) {
            this.incorrectPositions = copy;
        }
    }

    private void recalcNearby(BuilderCalculationContext bcc) {
        BetterBlockPos center = this.ctx.playerFeet();
        int radius = (Integer)Baritone.settings().builderTickScanRadius.value;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = center.field_177962_a + dx;
                    int y = center.field_177960_b + dy;
                    int z = center.field_177961_c + dz;
                    BlockState desired = bcc.getSchematic(x, y, z, bcc.bsi.get0(x, y, z));
                    if (desired == null) continue;
                    BetterBlockPos pos = new BetterBlockPos(x, y, z);
                    if (this.valid(bcc.bsi.get0(x, y, z), desired, false)) {
                        this.incorrectPositions.remove((Object)pos);
                        this.observedCompleted.add(BetterBlockPos.longHash(pos));
                        continue;
                    }
                    this.incorrectPositions.add(pos);
                    this.observedCompleted.remove(BetterBlockPos.longHash(pos));
                }
            }
        }
    }

    private void fullRecalc(BuilderCalculationContext bcc) {
        this.incorrectPositions = new HashSet();
        for (int y = 0; y < this.schematic.heightY(); ++y) {
            for (int z = 0; z < this.schematic.lengthZ(); ++z) {
                for (int x = 0; x < this.schematic.widthX(); ++x) {
                    int blockZ;
                    int blockY;
                    int blockX = x + this.origin.func_177958_n();
                    BlockState current = bcc.bsi.get0(blockX, blockY = y + this.origin.func_177956_o(), blockZ = z + this.origin.func_177952_p());
                    if (!this.schematic.inSchematic(x, y, z, current)) continue;
                    if (bcc.bsi.worldContainsLoadedChunk(blockX, blockZ)) {
                        if (this.valid(bcc.bsi.get0(blockX, blockY, blockZ), this.schematic.desiredState(x, y, z, current, this.approxPlaceable), false)) {
                            this.observedCompleted.add(BetterBlockPos.longHash(blockX, blockY, blockZ));
                            continue;
                        }
                        this.incorrectPositions.add(new BetterBlockPos(blockX, blockY, blockZ));
                        this.observedCompleted.remove(BetterBlockPos.longHash(blockX, blockY, blockZ));
                        if (this.incorrectPositions.size() <= (Integer)Baritone.settings().incorrectSize.value) continue;
                        return;
                    }
                    if (this.observedCompleted.contains(BetterBlockPos.longHash(blockX, blockY, blockZ))) continue;
                    this.incorrectPositions.add(new BetterBlockPos(blockX, blockY, blockZ));
                    if (this.incorrectPositions.size() <= (Integer)Baritone.settings().incorrectSize.value) continue;
                    return;
                }
            }
        }
    }

    private Goal assemble(BuilderCalculationContext bcc, List<BlockState> approxPlaceable) {
        ArrayList placeable = new ArrayList();
        ArrayList breakable = new ArrayList();
        ArrayList sourceLiquids = new ArrayList();
        this.incorrectPositions.forEach(pos -> {
            BlockState state = bcc.bsi.get0((BlockPos)pos);
            if (state.func_177230_c() instanceof AirBlock) {
                if (approxPlaceable.contains(bcc.getSchematic(pos.field_177962_a, pos.field_177960_b, pos.field_177961_c, state))) {
                    placeable.add(pos);
                }
            } else if (state.func_177230_c() instanceof FlowingFluidBlock) {
                if (!MovementHelper.possiblyFlowing(state)) {
                    sourceLiquids.add(pos);
                }
            } else {
                breakable.add(pos);
            }
        });
        ArrayList toBreak = new ArrayList();
        breakable.forEach(pos -> toBreak.add(this.breakGoal((BlockPos)pos, bcc)));
        ArrayList toPlace = new ArrayList();
        placeable.forEach(pos -> {
            if (!placeable.contains((Object)pos.down()) && !placeable.contains((Object)pos.down(2))) {
                toPlace.add(this.placementGoal((BlockPos)pos, bcc));
            }
        });
        sourceLiquids.forEach(pos -> toPlace.add(new GoalBlock(pos.up())));
        if (!toPlace.isEmpty()) {
            return new JankyGoalComposite(new GoalComposite(toPlace.toArray(new Goal[0])), new GoalComposite(toBreak.toArray(new Goal[0])));
        }
        if (toBreak.isEmpty()) {
            return null;
        }
        return new GoalComposite(toBreak.toArray(new Goal[0]));
    }

    private Goal placementGoal(BlockPos pos, BuilderCalculationContext bcc) {
        if (!(this.ctx.world().func_180495_p(pos).func_177230_c() instanceof AirBlock)) {
            return new GoalPlace(pos);
        }
        boolean allowSameLevel = !(this.ctx.world().func_180495_p(pos.func_177984_a()).func_177230_c() instanceof AirBlock);
        BlockState current = this.ctx.world().func_180495_p(pos);
        for (Direction facing : Movement.HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP) {
            if (!MovementHelper.canPlaceAgainst(this.ctx, pos.func_177972_a(facing)) || !this.placementPlausible(pos, bcc.getSchematic(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), current))) continue;
            return new GoalAdjacent(pos, pos.func_177972_a(facing), allowSameLevel);
        }
        return new GoalPlace(pos);
    }

    private Goal breakGoal(BlockPos pos, BuilderCalculationContext bcc) {
        if (((Boolean)Baritone.settings().goalBreakFromAbove.value).booleanValue() && bcc.bsi.get0(pos.func_177984_a()).func_177230_c() instanceof AirBlock && bcc.bsi.get0(pos.func_177981_b(2)).func_177230_c() instanceof AirBlock) {
            return new JankyGoalComposite(new GoalBreak(pos), new GoalGetToBlock(pos.func_177984_a()){

                @Override
                public boolean isInGoal(int x, int y, int z) {
                    if (y > this.y || x == this.x && y == this.y && z == this.z) {
                        return false;
                    }
                    return super.isInGoal(x, y, z);
                }
            });
        }
        return new GoalBreak(pos);
    }

    @Override
    public void onLostControl() {
        this.incorrectPositions = null;
        this.name = null;
        this.schematic = null;
        this.realSchematic = null;
        this.layer = (Integer)Baritone.settings().startAtLayer.value;
        this.numRepeats = 0;
        this.paused = false;
        this.observedCompleted = null;
    }

    @Override
    public String displayName0() {
        return this.paused ? "Builder Paused" : "Building " + this.name;
    }

    private List<BlockState> approxPlaceable(int size) {
        ArrayList<BlockState> result = new ArrayList<BlockState>();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = (ItemStack)this.ctx.player().field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
                result.add(Blocks.field_150350_a.func_176223_P());
                continue;
            }
            result.add(((BlockItem)stack.func_77973_b()).func_179223_d().func_196258_a(new BlockItemUseContext(new ItemUseContext(this.ctx.world(), (PlayerEntity)this.ctx.player(), Hand.MAIN_HAND, stack, new BlockRayTraceResult(new Vector3d(this.ctx.player().func_213303_ch().field_72450_a, this.ctx.player().func_213303_ch().field_72448_b, this.ctx.player().func_213303_ch().field_72449_c), Direction.UP, (BlockPos)this.ctx.playerFeet(), false)){})));
        }
        return result;
    }

    private boolean valid(BlockState current, BlockState desired, boolean itemVerify) {
        if (desired == null) {
            return true;
        }
        if (current.func_177230_c() instanceof FlowingFluidBlock && ((Boolean)Baritone.settings().okIfWater.value).booleanValue()) {
            return true;
        }
        if (current.func_177230_c() instanceof AirBlock && ((List)Baritone.settings().okIfAir.value).contains(desired.func_177230_c())) {
            return true;
        }
        if (desired.func_177230_c() instanceof AirBlock && ((List)Baritone.settings().buildIgnoreBlocks.value).contains(current.func_177230_c())) {
            return true;
        }
        if (desired.func_177230_c() instanceof AirBlock && ((List)Baritone.settings().buildIgnoreBlocks.value).contains(current.func_177230_c())) {
            return true;
        }
        if (!(current.func_177230_c() instanceof AirBlock) && ((Boolean)Baritone.settings().buildIgnoreExisting.value).booleanValue() && !itemVerify) {
            return true;
        }
        return current.equals(desired);
    }

    public class BuilderCalculationContext
    extends CalculationContext {
        private final List<BlockState> placeable;
        private final ISchematic schematic;
        private final int originX;
        private final int originY;
        private final int originZ;

        public BuilderCalculationContext() {
            super(BuilderProcess.this.baritone, true);
            this.placeable = BuilderProcess.this.approxPlaceable(9);
            this.schematic = BuilderProcess.this.schematic;
            this.originX = BuilderProcess.this.origin.func_177958_n();
            this.originY = BuilderProcess.this.origin.func_177956_o();
            this.originZ = BuilderProcess.this.origin.func_177952_p();
            this.jumpPenalty += 10.0;
            this.backtrackCostFavoringCoefficient = 1.0;
        }

        private BlockState getSchematic(int x, int y, int z, BlockState current) {
            if (this.schematic.inSchematic(x - this.originX, y - this.originY, z - this.originZ, current)) {
                return this.schematic.desiredState(x - this.originX, y - this.originY, z - this.originZ, current, BuilderProcess.this.approxPlaceable);
            }
            return null;
        }

        @Override
        public double costOfPlacingAt(int x, int y, int z, BlockState current) {
            if (this.isPossiblyProtected(x, y, z) || !this.worldBorder.canPlaceAt(x, z)) {
                return 1000000.0;
            }
            BlockState sch = this.getSchematic(x, y, z, current);
            if (sch != null) {
                if (sch.func_177230_c() instanceof AirBlock) {
                    return this.placeBlockCost * 2.0;
                }
                if (this.placeable.contains(sch)) {
                    return 0.0;
                }
                if (!this.hasThrowaway) {
                    return 1000000.0;
                }
                return this.placeBlockCost * 3.0;
            }
            if (this.hasThrowaway) {
                return this.placeBlockCost;
            }
            return 1000000.0;
        }

        @Override
        public double breakCostMultiplierAt(int x, int y, int z, BlockState current) {
            if (!this.allowBreak || this.isPossiblyProtected(x, y, z)) {
                return 1000000.0;
            }
            BlockState sch = this.getSchematic(x, y, z, current);
            if (sch != null) {
                if (sch.func_177230_c() instanceof AirBlock) {
                    return 1.0;
                }
                if (BuilderProcess.this.valid(this.bsi.get0(x, y, z), sch, false)) {
                    return (Double)Baritone.settings().breakCorrectBlockPenaltyMultiplier.value;
                }
                return 1.0;
            }
            return 1.0;
        }
    }

    public static class GoalPlace
    extends GoalBlock {
        public GoalPlace(BlockPos placeAt) {
            super(placeAt.func_177984_a());
        }

        @Override
        public double heuristic(int x, int y, int z) {
            return (double)(this.y * 100) + super.heuristic(x, y, z);
        }
    }

    public static class GoalAdjacent
    extends GoalGetToBlock {
        private boolean allowSameLevel;
        private BlockPos no;

        public GoalAdjacent(BlockPos pos, BlockPos no, boolean allowSameLevel) {
            super(pos);
            this.no = no;
            this.allowSameLevel = allowSameLevel;
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            if (x == this.x && y == this.y && z == this.z) {
                return false;
            }
            if (x == this.no.func_177958_n() && y == this.no.func_177956_o() && z == this.no.func_177952_p()) {
                return false;
            }
            if (!this.allowSameLevel && y == this.y - 1) {
                return false;
            }
            if (y < this.y - 1) {
                return false;
            }
            return super.isInGoal(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            return (double)(this.y * 100) + super.heuristic(x, y, z);
        }
    }

    public static class GoalBreak
    extends GoalGetToBlock {
        public GoalBreak(BlockPos pos) {
            super(pos);
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            if (y > this.y) {
                return false;
            }
            return super.isInGoal(x, y, z);
        }
    }

    public static class JankyGoalComposite
    implements Goal {
        private final Goal primary;
        private final Goal fallback;

        public JankyGoalComposite(Goal primary, Goal fallback) {
            this.primary = primary;
            this.fallback = fallback;
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return this.primary.isInGoal(x, y, z) || this.fallback.isInGoal(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            return this.primary.heuristic(x, y, z);
        }

        public String toString() {
            return "JankyComposite Primary: " + this.primary + " Fallback: " + this.fallback;
        }
    }

    public static class Placement {
        private final int hotbarSelection;
        private final BlockPos placeAgainst;
        private final Direction side;
        private final Rotation rot;

        public Placement(int hotbarSelection, BlockPos placeAgainst, Direction side, Rotation rot) {
            this.hotbarSelection = hotbarSelection;
            this.placeAgainst = placeAgainst;
            this.side = side;
            this.rot = rot;
        }
    }
}

