/*
 * Decompiled with CFR 0.152.
 */
package baritone.process;

import baritone.Baritone;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.pathing.goals.GoalComposite;
import baritone.api.process.IFarmProcess;
import baritone.api.process.PathingCommand;
import baritone.api.process.PathingCommandType;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.input.Input;
import baritone.cache.WorldScanner;
import baritone.pathing.movement.MovementHelper;
import baritone.process.BuilderProcess;
import baritone.utils.BaritoneProcessHelper;
import baritone.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class FarmProcess
extends BaritoneProcessHelper
implements IFarmProcess {
    private boolean active;
    private List<BlockPos> locations;
    private int tickCount;
    private static final List<Item> FARMLAND_PLANTABLE = Arrays.asList(Items.field_185163_cU, Items.field_151081_bc, Items.field_151014_N, Items.field_151080_bb, Items.field_151174_bG, Items.field_151172_bF);
    private static final List<Item> PICKUP_DROPPED = Arrays.asList(Items.field_185163_cU, Items.field_185164_cV, Items.field_151081_bc, Items.field_151127_ba, Blocks.field_150440_ba.func_199767_j(), Items.field_151014_N, Items.field_151015_O, Items.field_151080_bb, Blocks.field_150423_aK.func_199767_j(), Items.field_151174_bG, Items.field_151172_bF, Items.field_151075_bm, Blocks.field_196608_cF.func_199767_j(), Blocks.field_150434_aF.func_199767_j());

    public FarmProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void farm() {
        this.active = true;
        this.locations = null;
    }

    private boolean readyForHarvest(World world, BlockPos pos, BlockState state) {
        for (Harvest harvest : Harvest.values()) {
            if (harvest.block != state.func_177230_c()) continue;
            return harvest.readyToHarvest(world, pos, state);
        }
        return false;
    }

    private boolean isPlantable(ItemStack stack) {
        return FARMLAND_PLANTABLE.contains(stack.func_77973_b());
    }

    private boolean isBoneMeal(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().equals(Items.field_196106_bc);
    }

    private boolean isNetherWart(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().equals(Items.field_151075_bm);
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        ArrayList<Block> scan = new ArrayList<Block>();
        for (Harvest harvest : Harvest.values()) {
            scan.add(harvest.block);
        }
        if (((Boolean)Baritone.settings().replantCrops.value).booleanValue()) {
            scan.add(Blocks.field_150458_ak);
            if (((Boolean)Baritone.settings().replantNetherWart.value).booleanValue()) {
                scan.add(Blocks.field_150425_aM);
            }
        }
        if ((Integer)Baritone.settings().mineGoalUpdateInterval.value != 0 && this.tickCount++ % (Integer)Baritone.settings().mineGoalUpdateInterval.value == 0) {
            Baritone.getExecutor().execute(() -> {
                this.locations = WorldScanner.INSTANCE.scanChunkRadius(this.ctx, scan, 256, 10, 10);
            });
        }
        if (this.locations == null) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<BlockPos> toBreak = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openFarmland = new ArrayList<BlockPos>();
        ArrayList<BlockPos> bonemealable = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openSoulsand = new ArrayList<BlockPos>();
        for (BlockPos blockPos : this.locations) {
            IGrowable ig;
            BlockState blockState = this.ctx.world().func_180495_p(blockPos);
            boolean bl = this.ctx.world().func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof AirBlock;
            if (blockState.func_177230_c() == Blocks.field_150458_ak) {
                if (!bl) continue;
                openFarmland.add(blockPos);
                continue;
            }
            if (blockState.func_177230_c() == Blocks.field_150425_aM) {
                if (!bl) continue;
                openSoulsand.add(blockPos);
                continue;
            }
            if (this.readyForHarvest(this.ctx.world(), blockPos, blockState)) {
                toBreak.add(blockPos);
                continue;
            }
            if (!(blockState.func_177230_c() instanceof IGrowable) || !(ig = (IGrowable)blockState.func_177230_c()).func_176473_a((IBlockReader)this.ctx.world(), blockPos, blockState, true) || !ig.func_180670_a(this.ctx.world(), this.ctx.world().field_73012_v, blockPos, blockState)) continue;
            bonemealable.add(blockPos);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        for (BlockPos blockPos : toBreak) {
            Optional<Rotation> optional = RotationUtils.reachable(this.ctx, blockPos);
            if (!optional.isPresent() || !isSafeToCancel) continue;
            this.baritone.getLookBehavior().updateTarget(optional.get(), true);
            MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().func_180495_p(blockPos));
            if (this.ctx.isLookingAt(blockPos)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<BlockPos> both = new ArrayList<BlockPos>(openFarmland);
        both.addAll(openSoulsand);
        for (BlockPos blockPos : both) {
            RayTraceResult result;
            boolean bl = openSoulsand.contains(blockPos);
            Optional<Rotation> rot = RotationUtils.reachableOffset((Entity)this.ctx.player(), blockPos, new Vector3d((double)blockPos.func_177958_n() + 0.5, (double)(blockPos.func_177956_o() + 1), (double)blockPos.func_177952_p() + 0.5), this.ctx.playerController().getBlockReachDistance(), false);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, bl ? this::isNetherWart : this::isPlantable) || !((result = RayTraceUtils.rayTraceTowards((Entity)this.ctx.player(), rot.get(), this.ctx.playerController().getBlockReachDistance())) instanceof BlockRayTraceResult) || ((BlockRayTraceResult)result).func_216354_b() != Direction.UP) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(blockPos)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        for (BlockPos blockPos : bonemealable) {
            Optional<Rotation> optional = RotationUtils.reachable(this.ctx, blockPos);
            if (!optional.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, this::isBoneMeal)) continue;
            this.baritone.getLookBehavior().updateTarget(optional.get(), true);
            if (this.ctx.isLookingAt(blockPos)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        if (calcFailed) {
            this.logDirect("Farm failed");
            if (((Boolean)Baritone.settings().desktopNotifications.value).booleanValue() && ((Boolean)Baritone.settings().notificationOnFarmFail.value).booleanValue()) {
                NotificationHelper.notify("Farm failed", true);
            }
            this.onLostControl();
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<Goal> arrayList = new ArrayList<Goal>();
        for (BlockPos blockPos : toBreak) {
            arrayList.add(new BuilderProcess.GoalBreak(blockPos));
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isPlantable)) {
            for (BlockPos blockPos : openFarmland) {
                arrayList.add(new GoalBlock(blockPos.func_177984_a()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isNetherWart)) {
            for (BlockPos blockPos : openSoulsand) {
                arrayList.add(new GoalBlock(blockPos.func_177984_a()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isBoneMeal)) {
            for (BlockPos blockPos : bonemealable) {
                arrayList.add(new GoalBlock(blockPos));
            }
        }
        for (Entity entity : this.ctx.entities()) {
            ItemEntity ei;
            if (!(entity instanceof ItemEntity) || !entity.func_233570_aj_() || !PICKUP_DROPPED.contains((ei = (ItemEntity)entity).func_92059_d().func_77973_b())) continue;
            arrayList.add(new GoalBlock(new BlockPos(entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b + 0.1, entity.func_213303_ch().field_72449_c)));
        }
        return new PathingCommand(new GoalComposite(arrayList.toArray(new Goal[0])), PathingCommandType.SET_GOAL_AND_PATH);
    }

    @Override
    public void onLostControl() {
        this.active = false;
    }

    @Override
    public String displayName0() {
        return "Farming";
    }

    private static enum Harvest {
        WHEAT((CropsBlock)Blocks.field_150464_aj),
        CARROTS((CropsBlock)Blocks.field_150459_bM),
        POTATOES((CropsBlock)Blocks.field_150469_bN),
        BEETROOT((CropsBlock)Blocks.field_185773_cZ),
        PUMPKIN(Blocks.field_150423_aK, state -> true),
        MELON(Blocks.field_150440_ba, state -> true),
        NETHERWART(Blocks.field_150388_bm, state -> (Integer)state.func_177229_b((Property)NetherWartBlock.field_176486_a) >= 3),
        SUGARCANE(Blocks.field_196608_cF, null){

            @Override
            public boolean readyToHarvest(World world, BlockPos pos, BlockState state) {
                if (((Boolean)Baritone.settings().replantCrops.value).booleanValue()) {
                    return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof SugarCaneBlock;
                }
                return true;
            }
        }
        ,
        CACTUS(Blocks.field_150434_aF, null){

            @Override
            public boolean readyToHarvest(World world, BlockPos pos, BlockState state) {
                if (((Boolean)Baritone.settings().replantCrops.value).booleanValue()) {
                    return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof CactusBlock;
                }
                return true;
            }
        };

        public final Block block;
        public final Predicate<BlockState> readyToHarvest;

        private Harvest(CropsBlock blockCrops) {
            this((Block)blockCrops, arg_0 -> ((CropsBlock)blockCrops).func_185525_y(arg_0));
        }

        private Harvest(Block block, Predicate<BlockState> readyToHarvest) {
            this.block = block;
            this.readyToHarvest = readyToHarvest;
        }

        public boolean readyToHarvest(World world, BlockPos pos, BlockState state) {
            return this.readyToHarvest.test(state);
        }
    }
}

