/*
 * Decompiled with CFR 0.152.
 */
package baritone.selection;

import baritone.api.selection.ISelection;
import baritone.api.utils.BetterBlockPos;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class Selection
implements ISelection {
    private final BetterBlockPos pos1;
    private final BetterBlockPos pos2;
    private final BetterBlockPos min;
    private final BetterBlockPos max;
    private final Vector3i size;
    private final AxisAlignedBB aabb;

    public Selection(BetterBlockPos pos1, BetterBlockPos pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.min = new BetterBlockPos(Math.min(pos1.field_177962_a, pos2.field_177962_a), Math.min(pos1.field_177960_b, pos2.field_177960_b), Math.min(pos1.field_177961_c, pos2.field_177961_c));
        this.max = new BetterBlockPos(Math.max(pos1.field_177962_a, pos2.field_177962_a), Math.max(pos1.field_177960_b, pos2.field_177960_b), Math.max(pos1.field_177961_c, pos2.field_177961_c));
        this.size = new Vector3i(this.max.field_177962_a - this.min.field_177962_a + 1, this.max.field_177960_b - this.min.field_177960_b + 1, this.max.field_177961_c - this.min.field_177961_c + 1);
        this.aabb = new AxisAlignedBB((BlockPos)this.min, this.max.func_177982_a(1, 1, 1));
    }

    @Override
    public BetterBlockPos pos1() {
        return this.pos1;
    }

    @Override
    public BetterBlockPos pos2() {
        return this.pos2;
    }

    @Override
    public BetterBlockPos min() {
        return this.min;
    }

    @Override
    public BetterBlockPos max() {
        return this.max;
    }

    @Override
    public Vector3i size() {
        return this.size;
    }

    @Override
    public AxisAlignedBB aabb() {
        return this.aabb;
    }

    public int hashCode() {
        return this.pos1.hashCode() ^ this.pos2.hashCode();
    }

    public String toString() {
        return String.format("Selection{pos1=%s,pos2=%s}", new Object[]{this.pos1, this.pos2});
    }

    private boolean isPos2(Direction facing) {
        boolean negative = facing.func_176743_c().func_179524_a() < 0;
        switch (facing.func_176740_k()) {
            case X: {
                return this.pos2.field_177962_a > this.pos1.field_177962_a ^ negative;
            }
            case Y: {
                return this.pos2.field_177960_b > this.pos1.field_177960_b ^ negative;
            }
            case Z: {
                return this.pos2.field_177961_c > this.pos1.field_177961_c ^ negative;
            }
        }
        throw new IllegalStateException("Bad Direction.Axis");
    }

    @Override
    public ISelection expand(Direction direction, int blocks) {
        if (this.isPos2(direction)) {
            return new Selection(this.pos1, this.pos2.offset(direction, blocks));
        }
        return new Selection(this.pos1.offset(direction, blocks), this.pos2);
    }

    @Override
    public ISelection contract(Direction direction, int blocks) {
        if (this.isPos2(direction)) {
            return new Selection(this.pos1.offset(direction, blocks), this.pos2);
        }
        return new Selection(this.pos1, this.pos2.offset(direction, blocks));
    }

    @Override
    public ISelection shift(Direction direction, int blocks) {
        return new Selection(this.pos1.offset(direction, blocks), this.pos2.offset(direction, blocks));
    }
}

