/*
 * Decompiled with CFR 0.152.
 */
package baritone.utils;

import baritone.Baritone;
import baritone.api.utils.IPlayerContext;
import baritone.cache.CachedRegion;
import baritone.cache.WorldData;
import baritone.utils.BlockStateInterfaceAccessWrapper;
import baritone.utils.accessor.IClientChunkProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;

public class BlockStateInterface {
    private final ClientChunkProvider provider;
    private final WorldData worldData;
    protected final IBlockReader world;
    public final BlockPos.Mutable isPassableBlockPos;
    public final IBlockReader access;
    private Chunk prev = null;
    private CachedRegion prevCached = null;
    private final boolean useTheRealWorld;
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();

    public BlockStateInterface(IPlayerContext ctx) {
        this(ctx, false);
    }

    public BlockStateInterface(IPlayerContext ctx, boolean copyLoadedChunks) {
        this(ctx.world(), (WorldData)ctx.worldData(), copyLoadedChunks);
    }

    public BlockStateInterface(World world, WorldData worldData, boolean copyLoadedChunks) {
        this.world = world;
        this.worldData = worldData;
        this.provider = copyLoadedChunks ? ((IClientChunkProvider)world.func_72863_F()).createThreadSafeCopy() : (ClientChunkProvider)world.func_72863_F();
        boolean bl = this.useTheRealWorld = (Boolean)Baritone.settings().pathThroughCachedOnly.value == false;
        if (!Minecraft.func_71410_x().func_213162_bc()) {
            throw new IllegalStateException();
        }
        this.isPassableBlockPos = new BlockPos.Mutable();
        this.access = new BlockStateInterfaceAccessWrapper(this);
    }

    public boolean worldContainsLoadedChunk(int blockX, int blockZ) {
        return this.provider.func_73149_a(blockX >> 4, blockZ >> 4);
    }

    public static Block getBlock(IPlayerContext ctx, BlockPos pos) {
        return BlockStateInterface.get(ctx, pos).func_177230_c();
    }

    public static BlockState get(IPlayerContext ctx, BlockPos pos) {
        return new BlockStateInterface(ctx).get0(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockState get0(BlockPos pos) {
        return this.get0(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockState get0(int x, int y, int z) {
        BlockState type;
        Object cached;
        if (y < 0 || y >= 256) {
            return AIR;
        }
        if (this.useTheRealWorld) {
            cached = this.prev;
            if (cached != null && cached.func_76632_l().field_77276_a == x >> 4 && cached.func_76632_l().field_77275_b == z >> 4) {
                return BlockStateInterface.getFromChunk((Chunk)cached, x, y, z);
            }
            Chunk chunk = this.provider.func_212849_a_(x >> 4, z >> 4, ChunkStatus.field_222617_m, false);
            if (chunk != null && !chunk.func_76621_g()) {
                this.prev = chunk;
                return BlockStateInterface.getFromChunk(chunk, x, y, z);
            }
        }
        if ((cached = this.prevCached) == null || ((CachedRegion)cached).getX() != x >> 9 || ((CachedRegion)cached).getZ() != z >> 9) {
            if (this.worldData == null) {
                return AIR;
            }
            CachedRegion region = this.worldData.cache.getRegion(x >> 9, z >> 9);
            if (region == null) {
                return AIR;
            }
            this.prevCached = region;
            cached = region;
        }
        if ((type = ((CachedRegion)cached).getBlock(x & 0x1FF, y, z & 0x1FF)) == null) {
            return AIR;
        }
        return type;
    }

    public boolean isLoaded(int x, int z) {
        Chunk prevChunk = this.prev;
        if (prevChunk != null && prevChunk.func_76632_l().field_77276_a == x >> 4 && prevChunk.func_76632_l().field_77275_b == z >> 4) {
            return true;
        }
        prevChunk = this.provider.func_212849_a_(x >> 4, z >> 4, ChunkStatus.field_222617_m, false);
        if (prevChunk != null && !prevChunk.func_76621_g()) {
            this.prev = prevChunk;
            return true;
        }
        CachedRegion prevRegion = this.prevCached;
        if (prevRegion != null && prevRegion.getX() == x >> 9 && prevRegion.getZ() == z >> 9) {
            return prevRegion.isCached(x & 0x1FF, z & 0x1FF);
        }
        if (this.worldData == null) {
            return false;
        }
        prevRegion = this.worldData.cache.getRegion(x >> 9, z >> 9);
        if (prevRegion == null) {
            return false;
        }
        this.prevCached = prevRegion;
        return prevRegion.isCached(x & 0x1FF, z & 0x1FF);
    }

    public static BlockState getFromChunk(Chunk chunk, int x, int y, int z) {
        ChunkSection section = chunk.func_76587_i()[y >> 4];
        if (ChunkSection.func_222628_a((ChunkSection)section)) {
            return AIR;
        }
        return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
    }
}

