/*
 * Decompiled with CFR 0.152.
 */
package baritone.utils.schematic.format.defaults;

import baritone.utils.schematic.StaticSchematic;
import baritone.utils.type.VarInt;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public final class SpongeSchematic
extends StaticSchematic {
    public SpongeSchematic(CompoundNBT nbt) {
        this.x = nbt.func_74762_e("Width");
        this.y = nbt.func_74762_e("Height");
        this.z = nbt.func_74762_e("Length");
        this.states = new BlockState[this.x][this.z][this.y];
        Int2ObjectArrayMap palette = new Int2ObjectArrayMap();
        CompoundNBT paletteTag = nbt.func_74775_l("Palette");
        for (String tag : paletteTag.func_150296_c()) {
            int index = paletteTag.func_74762_e(tag);
            SerializedBlockState serializedState = SerializedBlockState.getFromString(tag);
            if (serializedState == null) {
                throw new IllegalArgumentException("Unable to parse palette tag");
            }
            BlockState state = serializedState.deserialize();
            if (state == null) {
                throw new IllegalArgumentException("Unable to deserialize palette tag");
            }
            palette.put(index, (Object)state);
        }
        byte[] rawBlockData = nbt.func_74770_j("BlockData");
        int[] blockData = new int[this.x * this.y * this.z];
        int offset = 0;
        for (int i = 0; i < blockData.length; ++i) {
            if (offset >= rawBlockData.length) {
                throw new IllegalArgumentException("No remaining bytes in BlockData for complete schematic");
            }
            VarInt varInt = VarInt.read(rawBlockData, offset);
            blockData[i] = varInt.getValue();
            offset += varInt.getSize();
        }
        for (int y = 0; y < this.y; ++y) {
            for (int z = 0; z < this.z; ++z) {
                for (int x = 0; x < this.x; ++x) {
                    int index = (y * this.z + z) * this.x + x;
                    BlockState state = (BlockState)palette.get(blockData[index]);
                    if (state == null) {
                        throw new IllegalArgumentException("Invalid Palette Index " + index);
                    }
                    this.states[x][z][y] = state;
                }
            }
        }
    }

    private static final class SerializedBlockState {
        private static final Pattern REGEX = Pattern.compile("(?<location>(\\w+:)?\\w+)(\\[(?<properties>(\\w+=\\w+,?)+)])?");
        private final ResourceLocation resourceLocation;
        private final Map<String, String> properties;
        private BlockState blockState;

        private SerializedBlockState(ResourceLocation resourceLocation, Map<String, String> properties) {
            this.resourceLocation = resourceLocation;
            this.properties = properties;
        }

        private BlockState deserialize() {
            if (this.blockState == null) {
                Block block = (Block)Registry.field_212618_g.func_82594_a(this.resourceLocation);
                this.blockState = block.func_176223_P();
                this.properties.keySet().stream().sorted(String::compareTo).forEachOrdered(key -> {
                    Property property = block.func_176194_O().func_185920_a(key);
                    if (property != null) {
                        this.blockState = SerializedBlockState.setPropertyValue(this.blockState, property, this.properties.get(key));
                    }
                });
            }
            return this.blockState;
        }

        private static SerializedBlockState getFromString(String s) {
            Matcher m = REGEX.matcher(s);
            if (!m.matches()) {
                return null;
            }
            try {
                String location = m.group("location");
                String properties = m.group("properties");
                ResourceLocation resourceLocation = new ResourceLocation(location);
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                if (properties != null) {
                    for (String property : properties.split(",")) {
                        String[] split = property.split("=");
                        propertiesMap.put(split[0], split[1]);
                    }
                }
                return new SerializedBlockState(resourceLocation, propertiesMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private static <T extends Comparable<T>> BlockState setPropertyValue(BlockState state, Property<T> property, String value) {
            Optional parsed = property.func_185929_b(value);
            if (parsed.isPresent()) {
                return (BlockState)state.func_206870_a(property, (Comparable)parsed.get());
            }
            throw new IllegalArgumentException("Invalid value for property " + property);
        }
    }
}

