/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockOptionalMeta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;

public class BlockOptionalMetaLookup {
    private final BlockOptionalMeta[] boms;

    public BlockOptionalMetaLookup(BlockOptionalMeta ... blockOptionalMetaArray) {
        this.boms = blockOptionalMetaArray;
    }

    public BlockOptionalMetaLookup(Block ... blockArray) {
        this.boms = (BlockOptionalMeta[])Stream.of(blockArray).map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new);
    }

    public BlockOptionalMetaLookup(List<Block> list) {
        this.boms = (BlockOptionalMeta[])list.stream().map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new);
    }

    public BlockOptionalMetaLookup(String ... stringArray) {
        this.boms = (BlockOptionalMeta[])Stream.of(stringArray).map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new);
    }

    public boolean has(Block block) {
        BlockOptionalMeta[] blockOptionalMetaArray = this.boms;
        int n2 = this.boms.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (blockOptionalMetaArray[i2].getBlock() != block) continue;
            return true;
        }
        return false;
    }

    public boolean has(BlockState blockState) {
        BlockOptionalMeta[] blockOptionalMetaArray = this.boms;
        int n2 = this.boms.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blockOptionalMetaArray[i2].matches(blockState)) continue;
            return true;
        }
        return false;
    }

    public boolean has(ItemStack itemStack) {
        BlockOptionalMeta[] blockOptionalMetaArray = this.boms;
        int n2 = this.boms.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blockOptionalMetaArray[i2].matches(itemStack)) continue;
            return true;
        }
        return false;
    }

    public List<BlockOptionalMeta> blocks() {
        return Arrays.asList(this.boms);
    }

    public String toString() {
        return String.format("BlockOptionalMetaLookup{%s}", Arrays.toString(this.boms));
    }
}

