/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.VecUtils;
import java.util.Optional;
import net.minecraft.block.FireBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final Vector3d[] BLOCK_SIDE_MULTIPLIERS = new Vector3d[]{new Vector3d(0.5, 0.0, 0.5), new Vector3d(0.5, 1.0, 0.5), new Vector3d(0.5, 0.5, 0.0), new Vector3d(0.5, 0.5, 1.0), new Vector3d(0.0, 0.5, 0.5), new Vector3d(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(BlockPos blockPos, BlockPos blockPos2) {
        return RotationUtils.calcRotationFromVec3d(new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), new Vector3d((double)blockPos2.func_177958_n(), (double)blockPos2.func_177956_o(), (double)blockPos2.func_177952_p()));
    }

    public static Rotation wrapAnglesToRelative(Rotation rotation, Rotation rotation2) {
        if (rotation.yawIsReallyClose(rotation2)) {
            return new Rotation(rotation.getYaw(), rotation2.getPitch());
        }
        return rotation2.subtract(rotation).normalize().add(rotation);
    }

    public static Rotation calcRotationFromVec3d(Vector3d vector3d, Vector3d vector3d2, Rotation rotation) {
        return RotationUtils.wrapAnglesToRelative(rotation, RotationUtils.calcRotationFromVec3d(vector3d, vector3d2));
    }

    private static Rotation calcRotationFromVec3d(Vector3d object, Vector3d vector3d) {
        double[] dArray = new double[]{object.field_72450_a - vector3d.field_72450_a, object.field_72448_b - vector3d.field_72448_b, object.field_72449_c - vector3d.field_72449_c};
        object = dArray;
        double d2 = MathHelper.func_181159_b((double)dArray[0], (double)(-object[2]));
        double d3 = Math.sqrt((double)(object[0] * object[0] + object[2] * object[2]));
        double d4 = MathHelper.func_181159_b((double)object[1], (double)d3);
        return new Rotation((float)(d2 * 57.29577951308232), (float)(d4 * 57.29577951308232));
    }

    public static Vector3d calcVector3dFromRotation(Rotation rotation) {
        float f2 = MathHelper.func_76134_b((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new Vector3d((double)(f3 * f4), (double)f5, (double)(f2 * f4));
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, BlockPos blockPos) {
        return RotationUtils.reachable(iPlayerContext.player(), blockPos, iPlayerContext.playerController().getBlockReachDistance());
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, BlockPos blockPos, boolean bl2) {
        return RotationUtils.reachable(iPlayerContext.player(), blockPos, iPlayerContext.playerController().getBlockReachDistance(), bl2);
    }

    public static Optional<Rotation> reachable(ClientPlayerEntity clientPlayerEntity, BlockPos blockPos, double d2) {
        return RotationUtils.reachable(clientPlayerEntity, blockPos, d2, false);
    }

    public static Optional<Rotation> reachable(ClientPlayerEntity clientPlayerEntity, BlockPos blockPos, double d2, boolean bl2) {
        RayTraceResult rayTraceResult;
        Optional<Rotation> optional;
        if (BaritoneAPI.getProvider().getBaritoneForPlayer(clientPlayerEntity).getPlayerContext().isLookingAt(blockPos)) {
            optional = new Rotation(clientPlayerEntity.field_70177_z, clientPlayerEntity.field_70125_A + 1.0E-4f);
            if (bl2) {
                rayTraceResult = RayTraceUtils.rayTraceTowards((Entity)clientPlayerEntity, (Rotation)((Object)optional), d2, true);
                if (rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)rayTraceResult).func_216350_a().equals((Object)blockPos)) {
                    return Optional.of(optional);
                }
            } else {
                return Optional.of(optional);
            }
        }
        if ((optional = RotationUtils.reachableCenter((Entity)clientPlayerEntity, blockPos, d2, bl2)).isPresent()) {
            return optional;
        }
        rayTraceResult = clientPlayerEntity.field_70170_p.func_180495_p(blockPos).func_196954_c((IBlockReader)clientPlayerEntity.field_70170_p, blockPos);
        if (rayTraceResult.func_197766_b()) {
            rayTraceResult = VoxelShapes.func_197868_b();
        }
        Vector3d[] vector3dArray = BLOCK_SIDE_MULTIPLIERS;
        int n2 = BLOCK_SIDE_MULTIPLIERS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            optional = vector3dArray[i2];
            double d3 = rayTraceResult.func_197762_b(Direction.Axis.X) * ((Vector3d)optional).field_72450_a + rayTraceResult.func_197758_c(Direction.Axis.X) * (1.0 - ((Vector3d)optional).field_72450_a);
            double d4 = rayTraceResult.func_197762_b(Direction.Axis.Y) * ((Vector3d)optional).field_72448_b + rayTraceResult.func_197758_c(Direction.Axis.Y) * (1.0 - ((Vector3d)optional).field_72448_b);
            double d5 = rayTraceResult.func_197762_b(Direction.Axis.Z) * ((Vector3d)optional).field_72449_c + rayTraceResult.func_197758_c(Direction.Axis.Z) * (1.0 - ((Vector3d)optional).field_72449_c);
            optional = RotationUtils.reachableOffset((Entity)clientPlayerEntity, blockPos, new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()).func_72441_c(d3, d4, d5), d2, bl2);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(Entity entity, BlockPos blockPos, Vector3d object, double d2, boolean bl2) {
        object = RotationUtils.calcRotationFromVec3d(bl2 ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.func_174824_e(1.0f), object, new Rotation(entity.field_70177_z, entity.field_70125_A));
        RayTraceResult rayTraceResult = RayTraceUtils.rayTraceTowards(entity, (Rotation)object, d2, bl2);
        if (rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (((BlockRayTraceResult)rayTraceResult).func_216350_a().equals((Object)blockPos)) {
                return Optional.of(object);
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof FireBlock && ((BlockRayTraceResult)rayTraceResult).func_216350_a().equals((Object)blockPos.func_177977_b())) {
                return Optional.of(object);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(Entity entity, BlockPos blockPos, double d2, boolean bl2) {
        return RotationUtils.reachableOffset(entity, blockPos, VecUtils.calculateBlockCenter(entity.field_70170_p, blockPos), d2, bl2);
    }
}

