/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.pathing.goals;

import baritone.api.pathing.goals.Goal;
import baritone.api.utils.SettingsUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class GoalStrictDirection
implements Goal {
    public final int x;
    public final int y;
    public final int z;
    public final int dx;
    public final int dz;

    public GoalStrictDirection(BlockPos origin, Direction direction) {
        this.x = origin.func_177958_n();
        this.y = origin.func_177956_o();
        this.z = origin.func_177952_p();
        this.dx = direction.func_82601_c();
        this.dz = direction.func_82599_e();
        if (this.dx == 0 && this.dz == 0) {
            throw new IllegalArgumentException(direction + "");
        }
    }

    @Override
    public boolean isInGoal(int x, int y, int z) {
        return false;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        int distanceFromStartInDesiredDirection = (x - this.x) * this.dx + (z - this.z) * this.dz;
        int distanceFromStartInIncorrectDirection = Math.abs((x - this.x) * this.dz) + Math.abs((z - this.z) * this.dx);
        int verticalDistanceFromStart = Math.abs(y - this.y);
        double heuristic = -distanceFromStartInDesiredDirection * 100;
        heuristic += (double)(distanceFromStartInIncorrectDirection * 1000);
        return heuristic += (double)(verticalDistanceFromStart * 1000);
    }

    public String toString() {
        return String.format("GoalStrictDirection{x=%s, y=%s, z=%s, dx=%s, dz=%s}", SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z), SettingsUtil.maybeCensor(this.dx), SettingsUtil.maybeCensor(this.dz));
    }
}

