/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.SettingsUtil;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public final class BetterBlockPos
extends BlockPos {
    public static final BetterBlockPos ORIGIN = new BetterBlockPos(0, 0, 0);
    public final int field_177962_a;
    public final int field_177960_b;
    public final int field_177961_c;

    public BetterBlockPos(int x, int y, int z) {
        super(x, y, z);
        this.field_177962_a = x;
        this.field_177960_b = y;
        this.field_177961_c = z;
    }

    public BetterBlockPos(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public BetterBlockPos(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static BetterBlockPos from(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new BetterBlockPos(pos);
    }

    public int hashCode() {
        return (int)BetterBlockPos.longHash(this.field_177962_a, this.field_177960_b, this.field_177961_c);
    }

    public static long longHash(BetterBlockPos pos) {
        return BetterBlockPos.longHash(pos.field_177962_a, pos.field_177960_b, pos.field_177961_c);
    }

    public static long longHash(int x, int y, int z) {
        long hash = 3241L;
        hash = 3457689L * hash + (long)x;
        hash = 8734625L * hash + (long)y;
        hash = 2873465L * hash + (long)z;
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof BetterBlockPos) {
            BetterBlockPos oth = (BetterBlockPos)((Object)o);
            return oth.field_177962_a == this.field_177962_a && oth.field_177960_b == this.field_177960_b && oth.field_177961_c == this.field_177961_c;
        }
        BlockPos oth = (BlockPos)o;
        return oth.func_177958_n() == this.field_177962_a && oth.func_177956_o() == this.field_177960_b && oth.func_177952_p() == this.field_177961_c;
    }

    public BetterBlockPos up() {
        return new BetterBlockPos(this.field_177962_a, this.field_177960_b + 1, this.field_177961_c);
    }

    public BetterBlockPos up(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.field_177962_a, this.field_177960_b + amt, this.field_177961_c);
    }

    public BetterBlockPos down() {
        return new BetterBlockPos(this.field_177962_a, this.field_177960_b - 1, this.field_177961_c);
    }

    public BetterBlockPos down(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.field_177962_a, this.field_177960_b - amt, this.field_177961_c);
    }

    public BetterBlockPos offset(Direction dir) {
        Vector3i vec = dir.func_176730_m();
        return new BetterBlockPos(this.field_177962_a + vec.func_177958_n(), this.field_177960_b + vec.func_177956_o(), this.field_177961_c + vec.func_177952_p());
    }

    public BetterBlockPos offset(Direction dir, int dist) {
        if (dist == 0) {
            return this;
        }
        Vector3i vec = dir.func_176730_m();
        return new BetterBlockPos(this.field_177962_a + vec.func_177958_n() * dist, this.field_177960_b + vec.func_177956_o() * dist, this.field_177961_c + vec.func_177952_p() * dist);
    }

    public BetterBlockPos north() {
        return new BetterBlockPos(this.field_177962_a, this.field_177960_b, this.field_177961_c - 1);
    }

    public BetterBlockPos north(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.field_177962_a, this.field_177960_b, this.field_177961_c - amt);
    }

    public BetterBlockPos south() {
        return new BetterBlockPos(this.field_177962_a, this.field_177960_b, this.field_177961_c + 1);
    }

    public BetterBlockPos south(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.field_177962_a, this.field_177960_b, this.field_177961_c + amt);
    }

    public BetterBlockPos east() {
        return new BetterBlockPos(this.field_177962_a + 1, this.field_177960_b, this.field_177961_c);
    }

    public BetterBlockPos east(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.field_177962_a + amt, this.field_177960_b, this.field_177961_c);
    }

    public BetterBlockPos west() {
        return new BetterBlockPos(this.field_177962_a - 1, this.field_177960_b, this.field_177961_c);
    }

    public BetterBlockPos west(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.field_177962_a - amt, this.field_177960_b, this.field_177961_c);
    }

    @Nonnull
    public String toString() {
        return String.format("BetterBlockPos{x=%s,y=%s,z=%s}", SettingsUtil.maybeCensor(this.field_177962_a), SettingsUtil.maybeCensor(this.field_177960_b), SettingsUtil.maybeCensor(this.field_177961_c));
    }
}

