/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockUtils {
    private static transient Map<String, Block> resourceCache = new HashMap<String, Block>();

    public static String blockToString(Block block) {
        ResourceLocation loc = Registry.field_212618_g.func_177774_c((Object)block);
        String name = loc.func_110623_a();
        if (!loc.func_110624_b().equals("minecraft")) {
            name = loc.toString();
        }
        return name;
    }

    public static Block stringToBlockRequired(String name) {
        Block block = BlockUtils.stringToBlockNullable(name);
        if (block == null) {
            throw new IllegalArgumentException(String.format("Invalid block name %s", name));
        }
        return block;
    }

    public static Block stringToBlockNullable(String name) {
        Block block = resourceCache.get(name);
        if (block != null) {
            return block;
        }
        if (resourceCache.containsKey(name)) {
            return null;
        }
        block = Registry.field_212618_g.func_241873_b(ResourceLocation.func_208304_a((String)(name.contains(":") ? name : "minecraft:" + name))).orElse(null);
        HashMap<String, Block> copy = new HashMap<String, Block>(resourceCache);
        copy.put(name, block);
        resourceCache = copy;
        return block;
    }

    private BlockUtils() {
    }
}

