/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.cache.IWorldData;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.IPlayerController;
import baritone.api.utils.Rotation;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.block.SlabBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public interface IPlayerContext {
    public ClientPlayerEntity player();

    public IPlayerController playerController();

    public World world();

    default public Iterable<Entity> entities() {
        return ((ClientWorld)this.world()).func_217416_b();
    }

    default public Stream<Entity> entitiesStream() {
        return StreamSupport.stream(this.entities().spliterator(), false);
    }

    public IWorldData worldData();

    public RayTraceResult objectMouseOver();

    default public BetterBlockPos playerFeet() {
        BetterBlockPos feet = new BetterBlockPos(this.player().func_213303_ch().field_72450_a, this.player().func_213303_ch().field_72448_b + 0.1251, this.player().func_213303_ch().field_72449_c);
        try {
            if (this.world().func_180495_p((BlockPos)feet).func_177230_c() instanceof SlabBlock) {
                return feet.up();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return feet;
    }

    default public Vector3d playerFeetAsVec() {
        return new Vector3d(this.player().func_213303_ch().field_72450_a, this.player().func_213303_ch().field_72448_b, this.player().func_213303_ch().field_72449_c);
    }

    default public Vector3d playerHead() {
        return new Vector3d(this.player().func_213303_ch().field_72450_a, this.player().func_213303_ch().field_72448_b + (double)this.player().func_70047_e(), this.player().func_213303_ch().field_72449_c);
    }

    default public Rotation playerRotations() {
        return new Rotation(this.player().field_70177_z, this.player().field_70125_A);
    }

    public static double eyeHeight(boolean ifSneaking) {
        return ifSneaking ? 1.27 : 1.62;
    }

    default public Optional<BlockPos> getSelectedBlock() {
        RayTraceResult result = this.objectMouseOver();
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return Optional.of(((BlockRayTraceResult)result).func_216350_a());
        }
        return Optional.empty();
    }

    default public boolean isLookingAt(BlockPos pos) {
        return this.getSelectedBlock().equals(Optional.of(pos));
    }
}

