/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.VecUtils;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final Vector3d[] BLOCK_SIDE_MULTIPLIERS = new Vector3d[]{new Vector3d(0.5, 0.0, 0.5), new Vector3d(0.5, 1.0, 0.5), new Vector3d(0.5, 0.5, 0.0), new Vector3d(0.5, 0.5, 1.0), new Vector3d(0.0, 0.5, 0.5), new Vector3d(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(BlockPos orig, BlockPos dest) {
        return RotationUtils.calcRotationFromVec3d(new Vector3d((double)orig.func_177958_n(), (double)orig.func_177956_o(), (double)orig.func_177952_p()), new Vector3d((double)dest.func_177958_n(), (double)dest.func_177956_o(), (double)dest.func_177952_p()));
    }

    public static Rotation wrapAnglesToRelative(Rotation current, Rotation target) {
        if (current.yawIsReallyClose(target)) {
            return new Rotation(current.getYaw(), target.getPitch());
        }
        return target.subtract(current).normalize().add(current);
    }

    public static Rotation calcRotationFromVec3d(Vector3d orig, Vector3d dest, Rotation current) {
        return RotationUtils.wrapAnglesToRelative(current, RotationUtils.calcRotationFromVec3d(orig, dest));
    }

    private static Rotation calcRotationFromVec3d(Vector3d orig, Vector3d dest) {
        double[] delta = new double[]{orig.field_72450_a - dest.field_72450_a, orig.field_72448_b - dest.field_72448_b, orig.field_72449_c - dest.field_72449_c};
        double yaw = MathHelper.func_181159_b((double)delta[0], (double)(-delta[2]));
        double dist = Math.sqrt(delta[0] * delta[0] + delta[2] * delta[2]);
        double pitch = MathHelper.func_181159_b((double)delta[1], (double)dist);
        return new Rotation((float)(yaw * 57.29577951308232), (float)(pitch * 57.29577951308232));
    }

    public static Vector3d calcVector3dFromRotation(Rotation rotation) {
        float f = MathHelper.func_76134_b((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Optional<Rotation> reachable(IPlayerContext ctx, BlockPos pos) {
        return RotationUtils.reachable(ctx.player(), pos, ctx.playerController().getBlockReachDistance());
    }

    public static Optional<Rotation> reachable(IPlayerContext ctx, BlockPos pos, boolean wouldSneak) {
        return RotationUtils.reachable(ctx.player(), pos, ctx.playerController().getBlockReachDistance(), wouldSneak);
    }

    public static Optional<Rotation> reachable(ClientPlayerEntity entity, BlockPos pos, double blockReachDistance) {
        return RotationUtils.reachable(entity, pos, blockReachDistance, false);
    }

    public static Optional<Rotation> reachable(ClientPlayerEntity entity, BlockPos pos, double blockReachDistance, boolean wouldSneak) {
        Optional<Rotation> possibleRotation;
        IBaritone baritone = BaritoneAPI.getProvider().getBaritoneForPlayer(entity);
        if (baritone.getPlayerContext().isLookingAt(pos)) {
            Rotation hypothetical = new Rotation(entity.field_70177_z, entity.field_70125_A + 1.0E-4f);
            if (wouldSneak) {
                RayTraceResult result = RayTraceUtils.rayTraceTowards((Entity)entity, hypothetical, blockReachDistance, true);
                if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
                    return Optional.of(hypothetical);
                }
            } else {
                return Optional.of(hypothetical);
            }
        }
        if ((possibleRotation = RotationUtils.reachableCenter((Entity)entity, pos, blockReachDistance, wouldSneak)).isPresent()) {
            return possibleRotation;
        }
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        VoxelShape shape = state.func_196954_c((IBlockReader)entity.field_70170_p, pos);
        if (shape.func_197766_b()) {
            shape = VoxelShapes.func_197868_b();
        }
        for (Vector3d sideOffset : BLOCK_SIDE_MULTIPLIERS) {
            double xDiff = shape.func_197762_b(Direction.Axis.X) * sideOffset.field_72450_a + shape.func_197758_c(Direction.Axis.X) * (1.0 - sideOffset.field_72450_a);
            double yDiff = shape.func_197762_b(Direction.Axis.Y) * sideOffset.field_72448_b + shape.func_197758_c(Direction.Axis.Y) * (1.0 - sideOffset.field_72448_b);
            double zDiff = shape.func_197762_b(Direction.Axis.Z) * sideOffset.field_72449_c + shape.func_197758_c(Direction.Axis.Z) * (1.0 - sideOffset.field_72449_c);
            possibleRotation = RotationUtils.reachableOffset((Entity)entity, pos, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c(xDiff, yDiff, zDiff), blockReachDistance, wouldSneak);
            if (!possibleRotation.isPresent()) continue;
            return possibleRotation;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(Entity entity, BlockPos pos, Vector3d offsetPos, double blockReachDistance, boolean wouldSneak) {
        Vector3d eyes = wouldSneak ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.func_174824_e(1.0f);
        Rotation rotation = RotationUtils.calcRotationFromVec3d(eyes, offsetPos, new Rotation(entity.field_70177_z, entity.field_70125_A));
        RayTraceResult result = RayTraceUtils.rayTraceTowards(entity, rotation, blockReachDistance, wouldSneak);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
                return Optional.of(rotation);
            }
            if (entity.field_70170_p.func_180495_p(pos).func_177230_c() instanceof FireBlock && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos.func_177977_b())) {
                return Optional.of(rotation);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(Entity entity, BlockPos pos, double blockReachDistance, boolean wouldSneak) {
        return RotationUtils.reachableOffset(entity, pos, VecUtils.calculateBlockCenter(entity.field_70170_p, pos), blockReachDistance, wouldSneak);
    }
}

