/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class VecUtils {
    private VecUtils() {
    }

    public static Vector3d calculateBlockCenter(World world, BlockPos pos) {
        BlockState b = world.func_180495_p(pos);
        VoxelShape shape = b.func_196952_d((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return VecUtils.getBlockPosCenter(pos);
        }
        double xDiff = (shape.func_197762_b(Direction.Axis.X) + shape.func_197758_c(Direction.Axis.X)) / 2.0;
        double yDiff = (shape.func_197762_b(Direction.Axis.Y) + shape.func_197758_c(Direction.Axis.Y)) / 2.0;
        double zDiff = (shape.func_197762_b(Direction.Axis.Z) + shape.func_197758_c(Direction.Axis.Z)) / 2.0;
        if (Double.isNaN(xDiff) || Double.isNaN(yDiff) || Double.isNaN(zDiff)) {
            throw new IllegalStateException(b + " " + pos + " " + shape);
        }
        if (b.func_177230_c() instanceof FireBlock) {
            yDiff = 0.0;
        }
        return new Vector3d((double)pos.func_177958_n() + xDiff, (double)pos.func_177956_o() + yDiff, (double)pos.func_177952_p() + zDiff);
    }

    public static Vector3d getBlockPosCenter(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static double distanceToCenter(BlockPos pos, double x, double y, double z) {
        double xdiff = (double)pos.func_177958_n() + 0.5 - x;
        double ydiff = (double)pos.func_177956_o() + 0.5 - y;
        double zdiff = (double)pos.func_177952_p() + 0.5 - z;
        return Math.sqrt(xdiff * xdiff + ydiff * ydiff + zdiff * zdiff);
    }

    public static double entityDistanceToCenter(Entity entity, BlockPos pos) {
        return VecUtils.distanceToCenter(pos, entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c);
    }

    public static double entityFlatDistanceToCenter(Entity entity, BlockPos pos) {
        return VecUtils.distanceToCenter(pos, entity.func_213303_ch().field_72450_a, (double)pos.func_177956_o() + 0.5, entity.func_213303_ch().field_72449_c);
    }
}

