/*
 * Decompiled with CFR 0.152.
 */
package baritone.behavior;

import baritone.Baritone;
import baritone.api.event.events.TickEvent;
import baritone.behavior.Behavior;
import baritone.utils.ToolSet;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public final class InventoryBehavior
extends Behavior {
    public InventoryBehavior(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void onTick(TickEvent event) {
        int pick;
        if (!((Boolean)Baritone.settings().allowInventory.value).booleanValue()) {
            return;
        }
        if (event.getType() == TickEvent.Type.OUT) {
            return;
        }
        if (this.ctx.player().field_71070_bA != this.ctx.player().field_71069_bz) {
            return;
        }
        if (this.firstValidThrowaway() >= 9) {
            this.swapWithHotBar(this.firstValidThrowaway(), 8);
        }
        if ((pick = this.bestToolAgainst(Blocks.field_150348_b, PickaxeItem.class)) >= 9) {
            this.swapWithHotBar(pick, 0);
        }
    }

    public void attemptToPutOnHotbar(int inMainInvy, Predicate<Integer> disallowedHotbar) {
        OptionalInt destination = this.getTempHotbarSlot(disallowedHotbar);
        if (destination.isPresent()) {
            this.swapWithHotBar(inMainInvy, destination.getAsInt());
        }
    }

    public OptionalInt getTempHotbarSlot(Predicate<Integer> disallowedHotbar) {
        int i;
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (i = 1; i < 8; ++i) {
            if (!((ItemStack)this.ctx.player().field_71071_by.field_70462_a.get(i)).func_190926_b() || disallowedHotbar.test(i)) continue;
            candidates.add(i);
        }
        if (candidates.isEmpty()) {
            for (i = 1; i < 8; ++i) {
                if (disallowedHotbar.test(i)) continue;
                candidates.add(i);
            }
        }
        if (candidates.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((Integer)candidates.get(new Random().nextInt(candidates.size())));
    }

    private void swapWithHotBar(int inInventory, int inHotbar) {
        this.ctx.playerController().windowClick(this.ctx.player().field_71069_bz.field_75152_c, inInventory < 9 ? inInventory + 36 : inInventory, inHotbar, ClickType.SWAP, (PlayerEntity)this.ctx.player());
    }

    private int firstValidThrowaway() {
        NonNullList invy = this.ctx.player().field_71071_by.field_70462_a;
        for (int i = 0; i < invy.size(); ++i) {
            if (!((List)Baritone.settings().acceptableThrowawayItems.value).contains(((ItemStack)invy.get(i)).func_77973_b())) continue;
            return i;
        }
        return -1;
    }

    private int bestToolAgainst(Block against, Class<? extends ToolItem> cla$$) {
        NonNullList invy = this.ctx.player().field_71071_by.field_70462_a;
        int bestInd = -1;
        double bestSpeed = -1.0;
        for (int i = 0; i < invy.size(); ++i) {
            double speed;
            ItemStack stack = (ItemStack)invy.get(i);
            if (stack.func_190926_b() || !cla$$.isInstance(stack.func_77973_b()) || !((speed = ToolSet.calculateSpeedVsBlock(stack, against.func_176223_P())) > bestSpeed)) continue;
            bestSpeed = speed;
            bestInd = i;
        }
        return bestInd;
    }

    public boolean hasGenericThrowaway() {
        for (Item item : (List)Baritone.settings().acceptableThrowawayItems.value) {
            if (!this.throwaway(false, stack -> item.equals(stack.func_77973_b()))) continue;
            return true;
        }
        return false;
    }

    public boolean selectThrowawayForLocation(boolean select, int x, int y, int z) {
        BlockState maybe = this.baritone.getBuilderProcess().placeAt(x, y, z, this.baritone.bsi.get0(x, y, z));
        if (maybe != null && this.throwaway(select, stack -> stack.func_77973_b() instanceof BlockItem && maybe.equals(((BlockItem)stack.func_77973_b()).func_179223_d().func_196258_a(new BlockItemUseContext(new ItemUseContext(this.ctx.world(), (PlayerEntity)this.ctx.player(), Hand.MAIN_HAND, (ItemStack)stack, new BlockRayTraceResult(new Vector3d(this.ctx.player().func_213303_ch().field_72450_a, this.ctx.player().func_213303_ch().field_72448_b, this.ctx.player().func_213303_ch().field_72449_c), Direction.UP, (BlockPos)this.ctx.playerFeet(), false)){}))))) {
            return true;
        }
        if (maybe != null && this.throwaway(select, stack -> stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d().equals(maybe.func_177230_c()))) {
            return true;
        }
        for (Item item : (List)Baritone.settings().acceptableThrowawayItems.value) {
            if (!this.throwaway(select, stack -> item.equals(stack.func_77973_b()))) continue;
            return true;
        }
        return false;
    }

    public boolean throwaway(boolean select, Predicate<? super ItemStack> desired) {
        ItemStack item;
        int i;
        ClientPlayerEntity p = this.ctx.player();
        NonNullList inv = p.field_71071_by.field_70462_a;
        for (i = 0; i < 9; ++i) {
            item = (ItemStack)inv.get(i);
            if (!desired.test((ItemStack)item)) continue;
            if (select) {
                p.field_71071_by.field_70461_c = i;
            }
            return true;
        }
        if (desired.test((ItemStack)p.field_71071_by.field_184439_c.get(0))) {
            for (i = 0; i < 9; ++i) {
                item = (ItemStack)inv.get(i);
                if (!item.func_190926_b() && !(item.func_77973_b() instanceof PickaxeItem)) continue;
                if (select) {
                    p.field_71071_by.field_70461_c = i;
                }
                return true;
            }
        }
        return false;
    }
}

