/*
 * Decompiled with CFR 0.152.
 */
package baritone.cache;

import baritone.Baritone;
import baritone.api.cache.IWorldProvider;
import baritone.api.utils.Helper;
import baritone.cache.WorldData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import org.apache.commons.lang3.SystemUtils;

public class WorldProvider
implements IWorldProvider,
Helper {
    private static final Map<Path, WorldData> worldCache = new HashMap<Path, WorldData>();
    private WorldData currentWorld;

    @Override
    public final WorldData getCurrentWorld() {
        return this.currentWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initWorld(RegistryKey<World> world) {
        Object object;
        File readme;
        File directory;
        IntegratedServer integratedServer = mc.func_71401_C();
        if (mc.func_71356_B()) {
            directory = DimensionType.func_236031_a_(world, (File)integratedServer.func_240776_a_(FolderName.field_237253_i_).toFile());
            if (directory.toPath().relativize(WorldProvider.mc.field_71412_D.toPath()).getNameCount() != 2) {
                directory = directory.getParentFile();
            }
            readme = directory = new File(directory, "baritone");
        } else {
            String folderName;
            String string = folderName = mc.func_181540_al() ? "realms" : WorldProvider.mc.func_147104_D().field_78845_b;
            if (SystemUtils.IS_OS_WINDOWS) {
                folderName = folderName.replace(":", "_");
            }
            directory = new File(Baritone.getDir(), folderName);
            readme = Baritone.getDir();
        }
        try {
            FileOutputStream out = new FileOutputStream(new File(readme, "readme.txt"));
            object = null;
            try {
                out.write("https://github.com/cabaletta/baritone\n".getBytes());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException out) {
            // empty catch block
        }
        Path dir = DimensionType.func_236031_a_(world, (File)directory).toPath();
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("Baritone world data dir: " + dir);
        object = worldCache;
        synchronized (object) {
            this.currentWorld = worldCache.computeIfAbsent(dir, d -> new WorldData((Path)d, world));
        }
    }

    public final void closeWorld() {
        WorldData world = this.currentWorld;
        this.currentWorld = null;
        if (world == null) {
            return;
        }
        world.onClose();
    }

    public final void ifWorldLoaded(Consumer<WorldData> currentWorldConsumer) {
        if (this.currentWorld != null) {
            currentWorldConsumer.accept(this.currentWorld);
        }
    }
}

