/*
 * Decompiled with CFR 0.152.
 */
package baritone.launch;

import com.google.common.base.Strings;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.Agent;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.io.File;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;

public class LaunchTesting {
    public static void main(String[] args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        LaunchTesting.hackNatives();
        arguments.put("version", "BaritownedDeveloperEnvironment");
        arguments.put("assetIndex", System.getenv("assetIndex"));
        arguments.put("assetsDir", System.getenv().getOrDefault("assetDirectory", "assets"));
        arguments.put("accessToken", "FML");
        arguments.put("userProperties", "{}");
        arguments.put("tweakClass", System.getenv("tweakClass"));
        String password = System.getenv("password");
        if (password != null && !password.isEmpty()) {
            LaunchTesting.attemptLogin(arguments, System.getenv("username"), System.getenv("password"));
        }
        ArrayList argsArray = new ArrayList();
        arguments.forEach((k, v) -> {
            argsArray.add("--" + k);
            argsArray.add(v);
        });
        Launch.main((String[])argsArray.toArray(new String[0]));
    }

    private static void hackNatives() {
        String paths = System.getProperty("java.library.path");
        String nativesDir = System.getenv().get("nativesDirectory");
        paths = Strings.isNullOrEmpty((String)paths) ? nativesDir : paths + File.pathSeparator + nativesDir;
        System.setProperty("java.library.path", paths);
        try {
            Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void attemptLogin(Map<String, String> argMap, String username, String password) {
        YggdrasilUserAuthentication auth = (YggdrasilUserAuthentication)new YggdrasilAuthenticationService(Proxy.NO_PROXY, "1").createUserAuthentication(Agent.MINECRAFT);
        auth.setUsername(username);
        auth.setPassword(password);
        try {
            auth.logIn();
        }
        catch (AuthenticationException var4) {
            throw new RuntimeException(var4);
        }
        argMap.put("accessToken", auth.getAuthenticatedToken());
        argMap.put("uuid", auth.getSelectedProfile().getId().toString().replace("-", ""));
        argMap.put("username", auth.getSelectedProfile().getName());
        argMap.put("userType", auth.getUserType().getName());
        argMap.put("userProperties", new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create().toJson((Object)auth.getUserProperties()));
    }
}

