/*
 * Decompiled with CFR 0.152.
 */
package baritone.launch.mixins;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.TickEvent;
import baritone.api.event.events.WorldEvent;
import baritone.api.event.events.type.EventState;
import baritone.utils.BaritoneAutoTest;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Shadow
    public ClientPlayerEntity field_71439_g;
    @Shadow
    public ClientWorld field_71441_e;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(CallbackInfo ci) {
        BaritoneAPI.getProvider().getPrimaryBaritone();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void preInit(CallbackInfo ci) {
        BaritoneAutoTest.INSTANCE.onPreInit();
    }

    @Inject(method={"runTick"}, at={@At(value="FIELD", opcode=180, target="net/minecraft/client/Minecraft.currentScreen:Lnet/minecraft/client/gui/screen/Screen;", ordinal=5, shift=At.Shift.BY, by=-3)})
    private void runTick(CallbackInfo ci) {
        BiFunction<EventState, TickEvent.Type, TickEvent> tickProvider = TickEvent.createNextProvider();
        for (IBaritone baritone : BaritoneAPI.getProvider().getAllBaritones()) {
            TickEvent.Type type = baritone.getPlayerContext().player() != null && baritone.getPlayerContext().world() != null ? TickEvent.Type.IN : TickEvent.Type.OUT;
            baritone.getGameEventHandler().onTick(tickProvider.apply(EventState.PRE, type));
        }
    }

    @Inject(method={"loadWorld(Lnet/minecraft/client/world/ClientWorld;)V"}, at={@At(value="HEAD")})
    private void preLoadWorld(ClientWorld world, CallbackInfo ci) {
        if (this.field_71441_e == null && world == null) {
            return;
        }
        BaritoneAPI.getProvider().getPrimaryBaritone().getGameEventHandler().onWorldEvent(new WorldEvent(world, EventState.PRE));
    }

    @Inject(method={"loadWorld(Lnet/minecraft/client/world/ClientWorld;)V"}, at={@At(value="RETURN")})
    private void postLoadWorld(ClientWorld world, CallbackInfo ci) {
        BaritoneAPI.getProvider().getPrimaryBaritone().getGameEventHandler().onWorldEvent(new WorldEvent(world, EventState.POST));
    }

    @Redirect(method={"runTick"}, at=@At(value="FIELD", opcode=180, target="net/minecraft/client/gui/screen/Screen.passEvents:Z"))
    private boolean passEvents(Screen screen) {
        return BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().isPathing() && this.field_71439_g != null || screen.field_230711_n_;
    }
}

