/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.cache.WorldData;
import baritone.utils.BlockStateInterface;
import baritone.utils.ToolSet;
import baritone.utils.pathing.BetterWorldBorder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CalculationContext {
    private static final ItemStack STACK_BUCKET_WATER = new ItemStack((IItemProvider)Items.field_151131_as);
    public final boolean safeForThreadedUse;
    public final IBaritone baritone;
    public final World world;
    public final WorldData worldData;
    public final BlockStateInterface bsi;
    public final ToolSet toolSet;
    public final boolean hasWaterBucket;
    public final boolean hasThrowaway;
    public final boolean canSprint;
    protected final double placeBlockCost;
    public final boolean allowBreak;
    public final boolean allowParkour;
    public final boolean allowParkourPlace;
    public final boolean allowJumpAt256;
    public final boolean allowParkourAscend;
    public final boolean assumeWalkOnWater;
    public final boolean allowDiagonalDescend;
    public final boolean allowDiagonalAscend;
    public final boolean allowDownward;
    public final int maxFallHeightNoWater;
    public final int maxFallHeightBucket;
    public final double waterWalkSpeed;
    public final double breakBlockAdditionalCost;
    public double backtrackCostFavoringCoefficient;
    public double jumpPenalty;
    public final double walkOnWaterOnePenalty;
    public final BetterWorldBorder worldBorder;

    public CalculationContext(IBaritone baritone) {
        this(baritone, false);
    }

    public CalculationContext(IBaritone baritone, boolean forUseOnAnotherThread) {
        this.safeForThreadedUse = forUseOnAnotherThread;
        this.baritone = baritone;
        ClientPlayerEntity player = baritone.getPlayerContext().player();
        this.world = baritone.getPlayerContext().world();
        this.worldData = (WorldData)baritone.getWorldProvider().getCurrentWorld();
        this.bsi = new BlockStateInterface(this.world, this.worldData, forUseOnAnotherThread);
        this.toolSet = new ToolSet(player);
        this.hasThrowaway = (Boolean)Baritone.settings().allowPlace.value != false && ((Baritone)baritone).getInventoryBehavior().hasGenericThrowaway();
        this.hasWaterBucket = (Boolean)Baritone.settings().allowWaterBucketFall.value != false && PlayerInventory.func_184435_e((int)player.field_71071_by.func_184429_b(STACK_BUCKET_WATER)) && this.world.func_234923_W_() != World.field_234919_h_;
        this.canSprint = (Boolean)Baritone.settings().allowSprint.value != false && player.func_71024_bL().func_75116_a() > 6;
        this.placeBlockCost = (Double)Baritone.settings().blockPlacementPenalty.value;
        this.allowBreak = (Boolean)Baritone.settings().allowBreak.value;
        this.allowParkour = (Boolean)Baritone.settings().allowParkour.value;
        this.allowParkourPlace = (Boolean)Baritone.settings().allowParkourPlace.value;
        this.allowJumpAt256 = (Boolean)Baritone.settings().allowJumpAt256.value;
        this.allowParkourAscend = (Boolean)Baritone.settings().allowParkourAscend.value;
        this.assumeWalkOnWater = (Boolean)Baritone.settings().assumeWalkOnWater.value;
        this.allowDiagonalDescend = (Boolean)Baritone.settings().allowDiagonalDescend.value;
        this.allowDiagonalAscend = (Boolean)Baritone.settings().allowDiagonalAscend.value;
        this.allowDownward = (Boolean)Baritone.settings().allowDownward.value;
        this.maxFallHeightNoWater = (Integer)Baritone.settings().maxFallHeightNoWater.value;
        this.maxFallHeightBucket = (Integer)Baritone.settings().maxFallHeightBucket.value;
        int depth = EnchantmentHelper.func_185294_d((LivingEntity)player);
        if (depth > 3) {
            depth = 3;
        }
        float mult = (float)depth / 3.0f;
        this.waterWalkSpeed = 9.09090909090909 * (double)(1.0f - mult) + 4.63284688441047 * (double)mult;
        this.breakBlockAdditionalCost = (Double)Baritone.settings().blockBreakAdditionalPenalty.value;
        this.backtrackCostFavoringCoefficient = (Double)Baritone.settings().backtrackCostFavoringCoefficient.value;
        this.jumpPenalty = (Double)Baritone.settings().jumpPenalty.value;
        this.walkOnWaterOnePenalty = (Double)Baritone.settings().walkOnWaterOnePenalty.value;
        this.worldBorder = new BetterWorldBorder(this.world.func_175723_af());
    }

    public final IBaritone getBaritone() {
        return this.baritone;
    }

    public BlockState get(int x, int y, int z) {
        return this.bsi.get0(x, y, z);
    }

    public boolean isLoaded(int x, int z) {
        return this.bsi.isLoaded(x, z);
    }

    public BlockState get(BlockPos pos) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Block getBlock(int x, int y, int z) {
        return this.get(x, y, z).func_177230_c();
    }

    public double costOfPlacingAt(int x, int y, int z, BlockState current) {
        if (!this.hasThrowaway) {
            return 1000000.0;
        }
        if (this.isPossiblyProtected(x, y, z)) {
            return 1000000.0;
        }
        if (!this.worldBorder.canPlaceAt(x, z)) {
            return 1000000.0;
        }
        return this.placeBlockCost;
    }

    public double breakCostMultiplierAt(int x, int y, int z, BlockState current) {
        if (!this.allowBreak) {
            return 1000000.0;
        }
        if (this.isPossiblyProtected(x, y, z)) {
            return 1000000.0;
        }
        return 1.0;
    }

    public double placeBucketCost() {
        return this.placeBlockCost;
    }

    public boolean isPossiblyProtected(int x, int y, int z) {
        return false;
    }
}

