/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import baritone.utils.BlockStateInterface;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;

public class MovementAscend
extends Movement {
    private int ticksWithoutPlacement = 0;

    public MovementAscend(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, new BetterBlockPos[]{dest, src.up(2), dest.up()}, dest.down());
    }

    @Override
    public void reset() {
        super.reset();
        this.ticksWithoutPlacement = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        return MovementAscend.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c, this.dest.field_177962_a, this.dest.field_177961_c);
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        BetterBlockPos prior = new BetterBlockPos(this.src.func_177973_b((Vector3i)this.getDirection()).func_177984_a());
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.src.up()), (Object)((Object)this.dest), (Object)((Object)prior), (Object)((Object)prior.up()));
    }

    public static double cost(CalculationContext context, int x, int y, int z, int destX, int destZ) {
        double walk;
        BlockState toPlace = context.get(destX, y, destZ);
        double additionalPlacementCost = 0.0;
        if (!MovementHelper.canWalkOn(context.bsi, destX, y, destZ, toPlace)) {
            additionalPlacementCost = context.costOfPlacingAt(destX, y, destZ, toPlace);
            if (additionalPlacementCost >= 1000000.0) {
                return 1000000.0;
            }
            if (!MovementHelper.isReplaceable(destX, y, destZ, toPlace, context.bsi)) {
                return 1000000.0;
            }
            boolean foundPlaceOption = false;
            for (int i = 0; i < 5; ++i) {
                int againstX = destX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].func_82601_c();
                int againstY = y + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].func_96559_d();
                int againstZ = destZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].func_82599_e();
                if (againstX == x && againstZ == z || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
                foundPlaceOption = true;
                break;
            }
            if (!foundPlaceOption) {
                return 1000000.0;
            }
        }
        BlockState srcUp2 = context.get(x, y + 2, z);
        if (context.get(x, y + 3, z).func_177230_c() instanceof FallingBlock && (MovementHelper.canWalkThrough(context.bsi, x, y + 1, z) || !(srcUp2.func_177230_c() instanceof FallingBlock))) {
            return 1000000.0;
        }
        BlockState srcDown = context.get(x, y - 1, z);
        if (srcDown.func_177230_c() == Blocks.field_150468_ap || srcDown.func_177230_c() == Blocks.field_150395_bd) {
            return 1000000.0;
        }
        boolean jumpingFromBottomSlab = MovementHelper.isBottomSlab(srcDown);
        boolean jumpingToBottomSlab = MovementHelper.isBottomSlab(toPlace);
        if (jumpingFromBottomSlab && !jumpingToBottomSlab) {
            return 1000000.0;
        }
        if (jumpingToBottomSlab) {
            if (jumpingFromBottomSlab) {
                walk = Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047);
                walk += context.jumpPenalty;
            } else {
                walk = 4.63284688441047;
            }
        } else {
            walk = toPlace.func_177230_c() == Blocks.field_150425_aM ? 9.26569376882094 : Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047);
            walk += context.jumpPenalty;
        }
        double totalCost = walk + additionalPlacementCost;
        totalCost += MovementHelper.getMiningDurationTicks(context, x, y + 2, z, srcUp2, false);
        if (totalCost >= 1000000.0) {
            return 1000000.0;
        }
        if ((totalCost += MovementHelper.getMiningDurationTicks(context, destX, y + 1, destZ, false)) >= 1000000.0) {
            return 1000000.0;
        }
        return totalCost += MovementHelper.getMiningDurationTicks(context, destX, y + 2, destZ, true);
    }

    @Override
    public MovementState updateState(MovementState state) {
        if (this.ctx.playerFeet().field_177960_b < this.src.field_177960_b) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.playerFeet().equals((Object)this.dest) || this.ctx.playerFeet().equals(this.dest.func_177971_a((Vector3i)this.getDirection().func_177977_b()))) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        BlockState jumpingOnto = BlockStateInterface.get(this.ctx, this.positionToPlace);
        if (!MovementHelper.canWalkOn(this.ctx, this.positionToPlace, jumpingOnto)) {
            ++this.ticksWithoutPlacement;
            if (MovementHelper.attemptToPlaceABlock(state, this.baritone, this.dest.down(), false, true) == MovementHelper.PlaceResult.READY_TO_PLACE) {
                state.setInput(Input.SNEAK, true);
                if (this.ctx.player().func_213453_ef()) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
            }
            if (this.ticksWithoutPlacement > 10) {
                state.setInput(Input.MOVE_BACK, true);
            }
            return state;
        }
        MovementHelper.moveTowards(this.ctx, state, this.dest);
        if (MovementHelper.isBottomSlab(jumpingOnto) && !MovementHelper.isBottomSlab(BlockStateInterface.get(this.ctx, this.src.down()))) {
            return state;
        }
        if (((Boolean)Baritone.settings().assumeStep.value).booleanValue() || this.ctx.playerFeet().equals((Object)this.src.up())) {
            return state;
        }
        int xAxis = Math.abs(this.src.func_177958_n() - this.dest.func_177958_n());
        int zAxis = Math.abs(this.src.func_177952_p() - this.dest.func_177952_p());
        double flatDistToNext = (double)xAxis * Math.abs((double)this.dest.func_177958_n() + 0.5 - this.ctx.player().func_213303_ch().field_72450_a) + (double)zAxis * Math.abs((double)this.dest.func_177952_p() + 0.5 - this.ctx.player().func_213303_ch().field_72449_c);
        double sideDist = (double)zAxis * Math.abs((double)this.dest.func_177958_n() + 0.5 - this.ctx.player().func_213303_ch().field_72450_a) + (double)xAxis * Math.abs((double)this.dest.func_177952_p() + 0.5 - this.ctx.player().func_213303_ch().field_72449_c);
        double lateralMotion = (double)xAxis * this.ctx.player().func_213322_ci().field_72449_c + (double)zAxis * this.ctx.player().func_213322_ci().field_72450_a;
        if (Math.abs(lateralMotion) > 0.1) {
            return state;
        }
        if (this.headBonkClear()) {
            return state.setInput(Input.JUMP, true);
        }
        if (flatDistToNext > 1.2 || sideDist > 0.2) {
            return state;
        }
        return state.setInput(Input.JUMP, true);
    }

    public boolean headBonkClear() {
        BetterBlockPos startUp = this.src.up(2);
        for (int i = 0; i < 4; ++i) {
            BetterBlockPos check = startUp.offset(Direction.func_176731_b((int)i));
            if (MovementHelper.canWalkThrough(this.ctx, check)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || this.ticksWithoutPlacement == 0;
    }
}

