/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.Rotation;
import baritone.api.utils.RotationUtils;
import baritone.api.utils.input.Input;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import baritone.utils.BlockStateInterface;
import baritone.utils.pathing.MutableMoveResult;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class MovementDescend
extends Movement {
    private int numTicks = 0;

    public MovementDescend(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, new BetterBlockPos[]{end.up(2), end.up(), end}, end.down());
    }

    @Override
    public void reset() {
        super.reset();
        this.numTicks = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c, this.dest.field_177962_a, this.dest.field_177961_c, result);
        if (result.y != this.dest.field_177960_b) {
            return 1000000.0;
        }
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest.up()), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult res) {
        double totalCost = 0.0;
        BlockState destDown = context.get(destX, y - 1, destZ);
        if ((totalCost += MovementHelper.getMiningDurationTicks(context, destX, y - 1, destZ, destDown, false)) >= 1000000.0) {
            return;
        }
        if ((totalCost += MovementHelper.getMiningDurationTicks(context, destX, y, destZ, false)) >= 1000000.0) {
            return;
        }
        if ((totalCost += MovementHelper.getMiningDurationTicks(context, destX, y + 1, destZ, true)) >= 1000000.0) {
            return;
        }
        Block fromDown = context.get(x, y - 1, z).func_177230_c();
        if (fromDown == Blocks.field_150468_ap || fromDown == Blocks.field_150395_bd) {
            return;
        }
        BlockState below = context.get(destX, y - 2, destZ);
        if (!MovementHelper.canWalkOn(context.bsi, destX, y - 2, destZ, below)) {
            MovementDescend.dynamicFallCost(context, x, y, z, destX, destZ, totalCost, below, res);
            return;
        }
        if (destDown.func_177230_c() == Blocks.field_150468_ap || destDown.func_177230_c() == Blocks.field_150395_bd) {
            return;
        }
        double walk = 3.7062775075283763;
        if (fromDown == Blocks.field_150425_aM) {
            walk *= 2.0;
        }
        res.x = destX;
        res.y = y - 1;
        res.z = destZ;
        res.cost = totalCost += walk + Math.max(FALL_N_BLOCKS_COST[1], 0.9265693768820937);
    }

    public static boolean dynamicFallCost(CalculationContext context, int x, int y, int z, int destX, int destZ, double frontBreak, BlockState below, MutableMoveResult res) {
        if (frontBreak != 0.0 && context.get(destX, y + 2, destZ).func_177230_c() instanceof FallingBlock) {
            return false;
        }
        if (!MovementHelper.canWalkThrough(context.bsi, destX, y - 2, destZ, below)) {
            return false;
        }
        double costSoFar = 0.0;
        int effectiveStartHeight = y;
        int fallHeight = 3;
        int newY;
        while ((newY = y - fallHeight) >= 0) {
            BlockState ontoBlock = context.get(destX, newY, destZ);
            int unprotectedFallHeight = fallHeight - (y - effectiveStartHeight);
            double tentativeCost = 3.7062775075283763 + FALL_N_BLOCKS_COST[unprotectedFallHeight] + frontBreak + costSoFar;
            if (MovementHelper.isWater(ontoBlock)) {
                if (!MovementHelper.canWalkThrough(context.bsi, destX, newY, destZ, ontoBlock)) {
                    return false;
                }
                if (context.assumeWalkOnWater) {
                    return false;
                }
                if (MovementHelper.isFlowing(destX, newY, destZ, ontoBlock, context.bsi)) {
                    return false;
                }
                if (!MovementHelper.canWalkOn(context.bsi, destX, newY - 1, destZ)) {
                    return false;
                }
                res.x = destX;
                res.y = newY;
                res.z = destZ;
                res.cost = tentativeCost;
                return false;
            }
            if (unprotectedFallHeight <= 11 && (ontoBlock.func_177230_c() == Blocks.field_150395_bd || ontoBlock.func_177230_c() == Blocks.field_150468_ap)) {
                costSoFar += FALL_N_BLOCKS_COST[unprotectedFallHeight - 1];
                costSoFar += 6.666666666666667;
                effectiveStartHeight = newY;
            } else if (!MovementHelper.canWalkThrough(context.bsi, destX, newY, destZ, ontoBlock)) {
                if (!MovementHelper.canWalkOn(context.bsi, destX, newY, destZ, ontoBlock)) {
                    return false;
                }
                if (MovementHelper.isBottomSlab(ontoBlock)) {
                    return false;
                }
                if (unprotectedFallHeight <= context.maxFallHeightNoWater + 1) {
                    res.x = destX;
                    res.y = newY + 1;
                    res.z = destZ;
                    res.cost = tentativeCost;
                    return false;
                }
                if (context.hasWaterBucket && unprotectedFallHeight <= context.maxFallHeightBucket + 1) {
                    res.x = destX;
                    res.y = newY + 1;
                    res.z = destZ;
                    res.cost = tentativeCost + context.placeBucketCost();
                    return true;
                }
                return false;
            }
            ++fallHeight;
        }
        return false;
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        BetterBlockPos playerFeet = this.ctx.playerFeet();
        BlockPos fakeDest = new BlockPos(this.dest.func_177958_n() * 2 - this.src.func_177958_n(), this.dest.func_177956_o(), this.dest.func_177952_p() * 2 - this.src.func_177952_p());
        if ((playerFeet.equals((Object)this.dest) || playerFeet.equals(fakeDest)) && (MovementHelper.isLiquid(this.ctx, this.dest) || this.ctx.player().func_213303_ch().field_72448_b - (double)this.dest.func_177956_o() < 0.5)) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        if (this.safeMode()) {
            double destX = ((double)this.src.func_177958_n() + 0.5) * 0.17 + ((double)this.dest.func_177958_n() + 0.5) * 0.83;
            double destZ = ((double)this.src.func_177952_p() + 0.5) * 0.17 + ((double)this.dest.func_177952_p() + 0.5) * 0.83;
            ClientPlayerEntity player = this.ctx.player();
            state.setTarget(new MovementState.MovementTarget(new Rotation(RotationUtils.calcRotationFromVec3d(this.ctx.playerHead(), new Vector3d(destX, (double)this.dest.func_177956_o(), destZ), new Rotation(player.field_70177_z, player.field_70125_A)).getYaw(), player.field_70125_A), false)).setInput(Input.MOVE_FORWARD, true);
            return state;
        }
        double diffX = this.ctx.player().func_213303_ch().field_72450_a - ((double)this.dest.func_177958_n() + 0.5);
        double diffZ = this.ctx.player().func_213303_ch().field_72449_c - ((double)this.dest.func_177952_p() + 0.5);
        double ab = Math.sqrt(diffX * diffX + diffZ * diffZ);
        double x = this.ctx.player().func_213303_ch().field_72450_a - ((double)this.src.func_177958_n() + 0.5);
        double z = this.ctx.player().func_213303_ch().field_72449_c - ((double)this.src.func_177952_p() + 0.5);
        double fromStart = Math.sqrt(x * x + z * z);
        if (!playerFeet.equals((Object)this.dest) || ab > 0.25) {
            if (this.numTicks++ < 20 && fromStart < 1.25) {
                MovementHelper.moveTowards(this.ctx, state, fakeDest);
            } else {
                MovementHelper.moveTowards(this.ctx, state, this.dest);
            }
        }
        return state;
    }

    public boolean safeMode() {
        BlockPos into = this.dest.func_177973_b((Vector3i)this.src.down()).func_177971_a((Vector3i)this.dest);
        if (this.skipToAscend()) {
            return true;
        }
        for (int y = 0; y <= 2; ++y) {
            if (!MovementHelper.avoidWalkingInto(BlockStateInterface.get(this.ctx, into.func_177981_b(y)))) continue;
            return true;
        }
        return false;
    }

    public boolean skipToAscend() {
        BlockPos into = this.dest.func_177973_b((Vector3i)this.src.down()).func_177971_a((Vector3i)this.dest);
        return !MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into)) && MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into).up()) && MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into).up(2));
    }
}

