/*
 * Decompiled with CFR 0.152.
 */
package baritone.pathing.movement.movements;

import baritone.api.IBaritone;
import baritone.api.pathing.movement.MovementStatus;
import baritone.api.utils.BetterBlockPos;
import baritone.pathing.movement.CalculationContext;
import baritone.pathing.movement.Movement;
import baritone.pathing.movement.MovementHelper;
import baritone.pathing.movement.MovementState;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;

public class MovementDownward
extends Movement {
    private int numTicks = 0;

    public MovementDownward(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, new BetterBlockPos[]{end});
    }

    @Override
    public void reset() {
        super.reset();
        this.numTicks = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        return MovementDownward.cost(context, this.src.field_177962_a, this.src.field_177960_b, this.src.field_177961_c);
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static double cost(CalculationContext context, int x, int y, int z) {
        if (!context.allowDownward) {
            return 1000000.0;
        }
        if (!MovementHelper.canWalkOn(context.bsi, x, y - 2, z)) {
            return 1000000.0;
        }
        BlockState down = context.get(x, y - 1, z);
        Block downBlock = down.func_177230_c();
        if (downBlock == Blocks.field_150468_ap || downBlock == Blocks.field_150395_bd) {
            return 6.666666666666667;
        }
        return FALL_N_BLOCKS_COST[1] + MovementHelper.getMiningDurationTicks(context, x, y - 1, z, down, false);
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.playerFeet().equals((Object)this.dest)) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        if (!this.playerInValidPosition()) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        double diffX = this.ctx.player().func_213303_ch().field_72450_a - ((double)this.dest.func_177958_n() + 0.5);
        double diffZ = this.ctx.player().func_213303_ch().field_72449_c - ((double)this.dest.func_177952_p() + 0.5);
        double ab = Math.sqrt(diffX * diffX + diffZ * diffZ);
        if (this.numTicks++ < 10 && ab < 0.2) {
            return state;
        }
        MovementHelper.moveTowards(this.ctx, state, this.positionsToBreak[0]);
        return state;
    }
}

