/*
 * Decompiled with CFR 0.152.
 */
package baritone.utils;

import baritone.api.BaritoneAPI;
import baritone.api.event.events.RenderEvent;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalComposite;
import baritone.api.pathing.goals.GoalGetToBlock;
import baritone.api.pathing.goals.GoalInverted;
import baritone.api.pathing.goals.GoalTwoBlocks;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.pathing.goals.GoalYLevel;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.Helper;
import baritone.api.utils.interfaces.IGoalRenderPos;
import baritone.behavior.PathingBehavior;
import baritone.pathing.path.PathExecutor;
import baritone.utils.BlockStateInterface;
import baritone.utils.GuiClick;
import baritone.utils.IRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import org.lwjgl.opengl.GL11;

public final class PathRenderer
implements IRenderer,
Helper {
    private static final ResourceLocation TEXTURE_BEACON_BEAM = new ResourceLocation("textures/entity/beacon_beam.png");

    private PathRenderer() {
    }

    public static double posX() {
        return renderManager.renderPosX();
    }

    public static double posY() {
        return renderManager.renderPosY();
    }

    public static double posZ() {
        return renderManager.renderPosZ();
    }

    public static void render(RenderEvent event, PathingBehavior behavior) {
        DimensionType currentRenderViewDimension;
        DimensionType thisPlayerDimension;
        float partialTicks = event.getPartialTicks();
        Goal goal = behavior.getGoal();
        if (Helper.mc.field_71462_r instanceof GuiClick) {
            ((GuiClick)Helper.mc.field_71462_r).onRender(event.getModelViewStack(), event.getProjectionMatrix());
        }
        if ((thisPlayerDimension = behavior.baritone.getPlayerContext().world().func_230315_m_()) != (currentRenderViewDimension = BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().world().func_230315_m_())) {
            return;
        }
        Entity renderView = Helper.mc.func_175606_aa();
        if (renderView.field_70170_p != BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().world()) {
            System.out.println("I have no idea what's going on");
            System.out.println("The primary baritone is in a different world than the render view entity");
            System.out.println("Not rendering the path");
            return;
        }
        if (goal != null && ((Boolean)PathRenderer.settings.renderGoal.value).booleanValue()) {
            PathRenderer.drawDankLitGoalBox(event.getModelViewStack(), renderView, goal, partialTicks, (Color)PathRenderer.settings.colorGoalBox.value);
        }
        if (!((Boolean)PathRenderer.settings.renderPath.value).booleanValue()) {
            return;
        }
        PathExecutor current = behavior.getCurrent();
        PathExecutor next = behavior.getNext();
        if (current != null && ((Boolean)PathRenderer.settings.renderSelectionBoxes.value).booleanValue()) {
            PathRenderer.drawManySelectionBoxes(event.getModelViewStack(), renderView, current.toBreak(), (Color)PathRenderer.settings.colorBlocksToBreak.value);
            PathRenderer.drawManySelectionBoxes(event.getModelViewStack(), renderView, current.toPlace(), (Color)PathRenderer.settings.colorBlocksToPlace.value);
            PathRenderer.drawManySelectionBoxes(event.getModelViewStack(), renderView, current.toWalkInto(), (Color)PathRenderer.settings.colorBlocksToWalkInto.value);
        }
        if (current != null && current.getPath() != null) {
            int renderBegin = Math.max(current.getPosition() - 3, 0);
            PathRenderer.drawPath(event.getModelViewStack(), current.getPath(), renderBegin, (Color)PathRenderer.settings.colorCurrentPath.value, (Boolean)PathRenderer.settings.fadePath.value, 10, 20);
        }
        if (next != null && next.getPath() != null) {
            PathRenderer.drawPath(event.getModelViewStack(), next.getPath(), 0, (Color)PathRenderer.settings.colorNextPath.value, (Boolean)PathRenderer.settings.fadePath.value, 10, 20);
        }
        behavior.getInProgress().ifPresent(currentlyRunning -> {
            currentlyRunning.bestPathSoFar().ifPresent(p -> PathRenderer.drawPath(event.getModelViewStack(), p, 0, (Color)PathRenderer.settings.colorBestPathSoFar.value, (Boolean)PathRenderer.settings.fadePath.value, 10, 20));
            currentlyRunning.pathToMostRecentNodeConsidered().ifPresent(mr -> {
                PathRenderer.drawPath(event.getModelViewStack(), mr, 0, (Color)PathRenderer.settings.colorMostRecentConsidered.value, (Boolean)PathRenderer.settings.fadePath.value, 10, 20);
                PathRenderer.drawManySelectionBoxes(event.getModelViewStack(), renderView, Collections.singletonList(mr.getDest()), (Color)PathRenderer.settings.colorMostRecentConsidered.value);
            });
        });
    }

    public static void drawPath(MatrixStack stack, IPath path, int startIndex, Color color, boolean fadeOut, int fadeStart0, int fadeEnd0) {
        IRenderer.startLines(color, ((Float)PathRenderer.settings.pathRenderLineWidthPixels.value).floatValue(), (Boolean)PathRenderer.settings.renderPathIgnoreDepth.value);
        int fadeStart = fadeStart0 + startIndex;
        int fadeEnd = fadeEnd0 + startIndex;
        List<BetterBlockPos> positions = path.positions();
        int i = startIndex;
        while (i < positions.size() - 1) {
            BetterBlockPos start = positions.get(i);
            int next = i + 1;
            BetterBlockPos end = positions.get(next);
            int dirX = end.field_177962_a - start.field_177962_a;
            int dirY = end.field_177960_b - start.field_177960_b;
            int dirZ = end.field_177961_c - start.field_177961_c;
            while (!(next + 1 >= positions.size() || fadeOut && next + 1 >= fadeStart || dirX != positions.get((int)(next + 1)).field_177962_a - end.field_177962_a || dirY != positions.get((int)(next + 1)).field_177960_b - end.field_177960_b || dirZ != positions.get((int)(next + 1)).field_177961_c - end.field_177961_c)) {
                end = positions.get(++next);
            }
            if (fadeOut) {
                float alpha;
                if (i <= fadeStart) {
                    alpha = 0.4f;
                } else {
                    if (i > fadeEnd) break;
                    alpha = 0.4f * (1.0f - (float)(i - fadeStart) / (float)(fadeEnd - fadeStart));
                }
                IRenderer.glColor(color, alpha);
            }
            PathRenderer.drawLine(stack, start.field_177962_a, start.field_177960_b, start.field_177961_c, end.field_177962_a, end.field_177960_b, end.field_177961_c);
            tessellator.func_78381_a();
            i = next;
        }
        IRenderer.endLines((Boolean)PathRenderer.settings.renderPathIgnoreDepth.value);
    }

    public static void drawLine(MatrixStack stack, double x1, double y1, double z1, double x2, double y2, double z2) {
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        double vpX = PathRenderer.posX();
        double vpY = PathRenderer.posY();
        double vpZ = PathRenderer.posZ();
        boolean renderPathAsFrickinThingy = (Boolean)PathRenderer.settings.renderPathAsLine.value == false;
        buffer.func_181668_a(renderPathAsFrickinThingy ? 3 : 1, DefaultVertexFormats.field_181705_e);
        buffer.func_227888_a_(matrix4f, (float)(x1 + 0.5 - vpX), (float)(y1 + 0.5 - vpY), (float)(z1 + 0.5 - vpZ)).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)(x2 + 0.5 - vpX), (float)(y2 + 0.5 - vpY), (float)(z2 + 0.5 - vpZ)).func_181675_d();
        if (renderPathAsFrickinThingy) {
            buffer.func_227888_a_(matrix4f, (float)(x2 + 0.5 - vpX), (float)(y2 + 0.53 - vpY), (float)(z2 + 0.5 - vpZ)).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)(x1 + 0.5 - vpX), (float)(y1 + 0.53 - vpY), (float)(z1 + 0.5 - vpZ)).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)(x1 + 0.5 - vpX), (float)(y1 + 0.5 - vpY), (float)(z1 + 0.5 - vpZ)).func_181675_d();
        }
    }

    public static void drawManySelectionBoxes(MatrixStack stack, Entity player, Collection<BlockPos> positions, Color color) {
        IRenderer.startLines(color, ((Float)PathRenderer.settings.pathRenderLineWidthPixels.value).floatValue(), (Boolean)PathRenderer.settings.renderSelectionBoxesIgnoreDepth.value);
        BlockStateInterface bsi = new BlockStateInterface(BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext());
        positions.forEach(pos -> {
            BlockState state = bsi.get0((BlockPos)pos);
            VoxelShape shape = state.func_196954_c((IBlockReader)player.field_70170_p, pos);
            AxisAlignedBB toDraw = shape.func_197766_b() ? VoxelShapes.func_197868_b().func_197752_a() : shape.func_197752_a();
            toDraw = toDraw.func_186670_a(pos);
            IRenderer.drawAABB(stack, toDraw, 0.002);
        });
        IRenderer.endLines((Boolean)PathRenderer.settings.renderSelectionBoxesIgnoreDepth.value);
    }

    public static void drawDankLitGoalBox(MatrixStack stack, Entity player, Goal goal, float partialTicks, Color color) {
        double maxY;
        double minY;
        double y2;
        double y1;
        double maxZ;
        double minZ;
        double maxX;
        double minX;
        Object goalPos;
        double renderPosX = PathRenderer.posX();
        double renderPosY = PathRenderer.posY();
        double renderPosZ = PathRenderer.posZ();
        double y = MathHelper.func_76134_b((float)((float)((double)((float)(System.nanoTime() / 100000L % 20000L) / 20000.0f) * Math.PI * 2.0)));
        if (goal instanceof IGoalRenderPos) {
            goalPos = ((IGoalRenderPos)((Object)goal)).getGoalPos();
            minX = (double)goalPos.func_177958_n() + 0.002 - renderPosX;
            maxX = (double)(goalPos.func_177958_n() + 1) - 0.002 - renderPosX;
            minZ = (double)goalPos.func_177952_p() + 0.002 - renderPosZ;
            maxZ = (double)(goalPos.func_177952_p() + 1) - 0.002 - renderPosZ;
            if (goal instanceof GoalGetToBlock || goal instanceof GoalTwoBlocks) {
                y /= 2.0;
            }
            y1 = 1.0 + y + (double)goalPos.func_177956_o() - renderPosY;
            y2 = 1.0 - y + (double)goalPos.func_177956_o() - renderPosY;
            minY = (double)goalPos.func_177956_o() - renderPosY;
            maxY = minY + 2.0;
            if (goal instanceof GoalGetToBlock || goal instanceof GoalTwoBlocks) {
                y1 -= 0.5;
                y2 -= 0.5;
                maxY -= 1.0;
            }
        } else if (goal instanceof GoalXZ) {
            goalPos = (GoalXZ)goal;
            if (((Boolean)PathRenderer.settings.renderGoalXZBeacon.value).booleanValue()) {
                GL11.glPushAttrib((int)64);
                Helper.mc.func_110434_K().func_110577_a(TEXTURE_BEACON_BEAM);
                if (((Boolean)PathRenderer.settings.renderGoalIgnoreDepth.value).booleanValue()) {
                    RenderSystem.disableDepthTest();
                }
                stack.func_227860_a_();
                stack.func_227861_a_((double)((GoalXZ)goalPos).getX() - renderPosX, -renderPosY, (double)((GoalXZ)goalPos).getZ() - renderPosZ);
                BeaconTileEntityRenderer.func_228842_a_((MatrixStack)stack, (IRenderTypeBuffer)mc.func_228019_au_().func_228487_b_(), (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)1.0f, (long)player.field_70170_p.func_82737_E(), (int)0, (int)256, (float[])color.getColorComponents(null), (float)0.2f, (float)0.25f);
                stack.func_227865_b_();
                if (((Boolean)PathRenderer.settings.renderGoalIgnoreDepth.value).booleanValue()) {
                    RenderSystem.enableDepthTest();
                }
                GL11.glPopAttrib();
                return;
            }
            minX = (double)((GoalXZ)goalPos).getX() + 0.002 - renderPosX;
            maxX = (double)(((GoalXZ)goalPos).getX() + 1) - 0.002 - renderPosX;
            minZ = (double)((GoalXZ)goalPos).getZ() + 0.002 - renderPosZ;
            maxZ = (double)(((GoalXZ)goalPos).getZ() + 1) - 0.002 - renderPosZ;
            y1 = 0.0;
            y2 = 0.0;
            minY = 0.0 - renderPosY;
            maxY = 256.0 - renderPosY;
        } else {
            if (goal instanceof GoalComposite) {
                for (Goal g : ((GoalComposite)goal).goals()) {
                    PathRenderer.drawDankLitGoalBox(stack, player, g, partialTicks, color);
                }
                return;
            }
            if (goal instanceof GoalInverted) {
                PathRenderer.drawDankLitGoalBox(stack, player, ((GoalInverted)goal).origin, partialTicks, (Color)PathRenderer.settings.colorInvertedGoalBox.value);
                return;
            }
            if (goal instanceof GoalYLevel) {
                GoalYLevel goalpos = (GoalYLevel)goal;
                minX = player.func_213303_ch().field_72450_a - (Double)PathRenderer.settings.yLevelBoxSize.value - renderPosX;
                minZ = player.func_213303_ch().field_72449_c - (Double)PathRenderer.settings.yLevelBoxSize.value - renderPosZ;
                maxX = player.func_213303_ch().field_72450_a + (Double)PathRenderer.settings.yLevelBoxSize.value - renderPosX;
                maxZ = player.func_213303_ch().field_72449_c + (Double)PathRenderer.settings.yLevelBoxSize.value - renderPosZ;
                minY = (double)((GoalYLevel)goal).level - renderPosY;
                maxY = minY + 2.0;
                y1 = 1.0 + y + (double)goalpos.level - renderPosY;
                y2 = 1.0 - y + (double)goalpos.level - renderPosY;
            } else {
                return;
            }
        }
        IRenderer.startLines(color, ((Float)PathRenderer.settings.goalRenderLineWidthPixels.value).floatValue(), (Boolean)PathRenderer.settings.renderGoalIgnoreDepth.value);
        PathRenderer.renderHorizontalQuad(stack, minX, maxX, minZ, maxZ, y1);
        PathRenderer.renderHorizontalQuad(stack, minX, maxX, minZ, maxZ, y2);
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        buffer.func_227888_a_(matrix4f, (float)minX, (float)minY, (float)minZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)maxY, (float)minZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)minY, (float)minZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)maxY, (float)minZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)minY, (float)maxZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)maxY, (float)maxZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)minY, (float)maxZ).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)maxY, (float)maxZ).func_181675_d();
        tessellator.func_78381_a();
        IRenderer.endLines((Boolean)PathRenderer.settings.renderGoalIgnoreDepth.value);
    }

    private static void renderHorizontalQuad(MatrixStack stack, double minX, double maxX, double minZ, double maxZ, double y) {
        if (y != 0.0) {
            Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            buffer.func_227888_a_(matrix4f, (float)minX, (float)y, (float)minZ).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)maxX, (float)y, (float)minZ).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)maxX, (float)y, (float)maxZ).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)minX, (float)y, (float)maxZ).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

