/*
 * Decompiled with CFR 0.152.
 */
package baritone.utils;

import baritone.Baritone;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.Effects;

public class ToolSet {
    private final Map<Block, Double> breakStrengthCache = new HashMap<Block, Double>();
    private final Function<Block, Double> backendCalculation;
    private final ClientPlayerEntity player;

    public ToolSet(ClientPlayerEntity player) {
        this.player = player;
        if (((Boolean)Baritone.settings().considerPotionEffects.value).booleanValue()) {
            double amplifier = this.potionAmplifier();
            Function<Double, Double> amplify = x -> amplifier * x;
            this.backendCalculation = amplify.compose(this::getBestDestructionTime);
        } else {
            this.backendCalculation = this::getBestDestructionTime;
        }
    }

    public double getStrVsBlock(BlockState state) {
        return this.breakStrengthCache.computeIfAbsent(state.func_177230_c(), this.backendCalculation);
    }

    private int getMaterialCost(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ToolItem ? 1 : -1;
    }

    public boolean hasSilkTouch(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
    }

    public int getBestSlot(Block b, boolean preferSilkTouch) {
        return this.getBestSlot(b, preferSilkTouch, false);
    }

    public int getBestSlot(Block b, boolean preferSilkTouch, boolean pathingCalculation) {
        if (((Boolean)Baritone.settings().disableAutoTool.value).booleanValue() && pathingCalculation) {
            return this.player.field_71071_by.field_70461_c;
        }
        int best = 0;
        double highestSpeed = Double.NEGATIVE_INFINITY;
        int lowestCost = Integer.MIN_VALUE;
        boolean bestSilkTouch = false;
        BlockState blockState = b.func_176223_P();
        for (int i = 0; i < 9; ++i) {
            int cost;
            ItemStack itemStack = this.player.field_71071_by.func_70301_a(i);
            if (itemStack.func_77952_i() >= itemStack.func_77958_k() - 1 && ((Boolean)Baritone.settings().itemSaver.value).booleanValue()) continue;
            double speed = ToolSet.calculateSpeedVsBlock(itemStack, blockState);
            boolean silkTouch = this.hasSilkTouch(itemStack);
            if (speed > highestSpeed) {
                highestSpeed = speed;
                best = i;
                lowestCost = this.getMaterialCost(itemStack);
                bestSilkTouch = silkTouch;
                continue;
            }
            if (speed != highestSpeed || ((cost = this.getMaterialCost(itemStack)) >= lowestCost || !silkTouch && bestSilkTouch) && (!preferSilkTouch || bestSilkTouch || !silkTouch)) continue;
            highestSpeed = speed;
            best = i;
            lowestCost = cost;
            bestSilkTouch = silkTouch;
        }
        return best;
    }

    private double getBestDestructionTime(Block b) {
        ItemStack stack = this.player.field_71071_by.func_70301_a(this.getBestSlot(b, false, true));
        return ToolSet.calculateSpeedVsBlock(stack, b.func_176223_P()) * this.avoidanceMultiplier(b);
    }

    private double avoidanceMultiplier(Block b) {
        return ((List)Baritone.settings().blocksToAvoidBreaking.value).contains(b) ? 0.1 : 1.0;
    }

    public static double calculateSpeedVsBlock(ItemStack item, BlockState state) {
        int effLevel;
        float hardness = state.func_185887_b(null, null);
        if (hardness < 0.0f) {
            return -1.0;
        }
        float speed = item.func_150997_a(state);
        if (speed > 1.0f && (effLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)item)) > 0 && !item.func_190926_b()) {
            speed += (float)(effLevel * effLevel + 1);
        }
        speed /= hardness;
        if (!state.func_235783_q_() || !item.func_190926_b() && item.func_150998_b(state)) {
            return speed / 30.0f;
        }
        return speed / 100.0f;
    }

    private double potionAmplifier() {
        double speed = 1.0;
        if (this.player.func_70644_a(Effects.field_76422_e)) {
            speed *= 1.0 + (double)(this.player.func_70660_b(Effects.field_76422_e).func_76458_c() + 1) * 0.2;
        }
        if (this.player.func_70644_a(Effects.field_76419_f)) {
            switch (this.player.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    speed *= 0.3;
                    break;
                }
                case 1: {
                    speed *= 0.09;
                    break;
                }
                case 2: {
                    speed *= 0.0027;
                    break;
                }
                default: {
                    speed *= 8.1E-4;
                }
            }
        }
        return speed;
    }
}

