/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class VecUtils {
    private VecUtils() {
    }

    public static Vector3d calculateBlockCenter(World world, BlockPos blockPos) {
        BlockState blockState = world.func_180495_p(blockPos);
        if ((world = blockState.func_196952_d((IBlockReader)world, blockPos)).func_197766_b()) {
            return VecUtils.getBlockPosCenter(blockPos);
        }
        double d2 = (world.func_197762_b(Direction.Axis.X) + world.func_197758_c(Direction.Axis.X)) / 2.0;
        double d3 = (world.func_197762_b(Direction.Axis.Y) + world.func_197758_c(Direction.Axis.Y)) / 2.0;
        double d4 = (world.func_197762_b(Direction.Axis.Z) + world.func_197758_c(Direction.Axis.Z)) / 2.0;
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            throw new IllegalStateException(blockState + " " + blockPos + " " + world);
        }
        if (blockState.func_177230_c() instanceof FireBlock) {
            d3 = 0.0;
        }
        return new Vector3d((double)blockPos.func_177958_n() + d2, (double)blockPos.func_177956_o() + d3, (double)blockPos.func_177952_p() + d4);
    }

    public static Vector3d getBlockPosCenter(BlockPos blockPos) {
        return new Vector3d((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
    }

    public static double distanceToCenter(BlockPos blockPos, double d2, double d3, double d4) {
        double d5 = (double)blockPos.func_177958_n() + 0.5 - d2;
        double d6 = (double)blockPos.func_177956_o() + 0.5 - d3;
        double d7 = (double)blockPos.func_177952_p() + 0.5 - d4;
        double d8 = d5;
        double d9 = d6;
        double d10 = d7;
        return Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
    }

    public static double entityDistanceToCenter(Entity entity, BlockPos blockPos) {
        return VecUtils.distanceToCenter(blockPos, entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c);
    }

    public static double entityFlatDistanceToCenter(Entity entity, BlockPos blockPos) {
        return VecUtils.distanceToCenter(blockPos, entity.func_213303_ch().field_72450_a, (double)blockPos.func_177956_o() + 0.5, entity.func_213303_ch().field_72449_c);
    }
}

