/*
 * Decompiled with CFR 0.152.
 */
package baritone.launch.mixins;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.ChatEvent;
import baritone.api.event.events.PlayerUpdateEvent;
import baritone.api.event.events.SprintStateEvent;
import baritone.api.event.events.type.Cancellable;
import baritone.api.event.events.type.EventState;
import baritone.f;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerAbilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayerEntity.class})
public class MixinClientPlayerEntity {
    @Inject(method={"sendChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendChatMessage(String object, CallbackInfo callbackInfo) {
        object = new ChatEvent((String)object);
        IBaritone iBaritone = BaritoneAPI.getProvider().getBaritoneForPlayer((ClientPlayerEntity)this);
        if (iBaritone == null) {
            return;
        }
        iBaritone.getGameEventHandler().onSendChatMessage((ChatEvent)object);
        if (((Cancellable)object).isCancelled()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="net/minecraft/client/entity/player/ClientPlayerEntity.isPassenger()Z", shift=At.Shift.BY, by=-3)})
    private void onPreUpdate(CallbackInfo object) {
        object = BaritoneAPI.getProvider().getBaritoneForPlayer((ClientPlayerEntity)this);
        if (object != null) {
            object.getGameEventHandler().onPlayerUpdate(new PlayerUpdateEvent(EventState.PRE));
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="net/minecraft/client/entity/player/ClientPlayerEntity.onUpdateWalkingPlayer()V", shift=At.Shift.BY, by=2)})
    private void onPostUpdate(CallbackInfo object) {
        object = BaritoneAPI.getProvider().getBaritoneForPlayer((ClientPlayerEntity)this);
        if (object != null) {
            object.getGameEventHandler().onPlayerUpdate(new PlayerUpdateEvent(EventState.POST));
        }
    }

    @Redirect(method={"livingTick"}, at=@At(value="FIELD", target="net/minecraft/entity/player/PlayerAbilities.allowFlying:Z"))
    private boolean isAllowFlying(PlayerAbilities playerAbilities) {
        IBaritone iBaritone = BaritoneAPI.getProvider().getBaritoneForPlayer((ClientPlayerEntity)this);
        if (iBaritone == null) {
            return playerAbilities.field_75101_c;
        }
        return !iBaritone.getPathingBehavior().isPathing() && playerAbilities.field_75101_c;
    }

    @Redirect(method={"livingTick"}, at=@At(value="INVOKE", target="net/minecraft/client/settings/KeyBinding.isKeyDown()Z"))
    private boolean isKeyDown(KeyBinding keyBinding) {
        IBaritone iBaritone = BaritoneAPI.getProvider().getBaritoneForPlayer((ClientPlayerEntity)this);
        if (iBaritone == null) {
            return keyBinding.func_151470_d();
        }
        SprintStateEvent sprintStateEvent = new SprintStateEvent();
        iBaritone.getGameEventHandler().onPlayerSprintState(sprintStateEvent);
        if (sprintStateEvent.getState() != null) {
            return sprintStateEvent.getState();
        }
        if (iBaritone != BaritoneAPI.getProvider().getPrimaryBaritone()) {
            return false;
        }
        return keyBinding.func_151470_d();
    }

    @Inject(method={"updateRidden"}, at={@At(value="HEAD")})
    private void updateRidden(CallbackInfo object) {
        object = BaritoneAPI.getProvider().getBaritoneForPlayer((ClientPlayerEntity)this);
        if (object != null) {
            object = (f)object.getLookBehavior();
            if (((f)object).a != null) {
                ((f)object).a.player().field_70177_z = ((f)object).a.getYaw();
            }
        }
    }
}

