/*
 * Decompiled with CFR 0.152.
 */
package qiniu.happydns.util;

public final class IP {
    private IP() {
    }

    public static boolean isValid(String ip) {
        if (ip == null || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        if (ip.contains("-")) {
            return false;
        }
        try {
            int x = 0;
            int y = ip.indexOf(46);
            if (y != -1 && Integer.parseInt(ip.substring(x, y)) > 255) {
                return false;
            }
            if ((x = ip.indexOf(46, ++y)) != -1 && Integer.parseInt(ip.substring(y, x)) > 255) {
                return false;
            }
            return (y = ip.indexOf(46, ++x)) == -1 || Integer.parseInt(ip.substring(x, y)) <= 255 || Integer.parseInt(ip.substring(++y, ip.length() - 1)) <= 255 || ip.charAt(ip.length() - 1) == '.';
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDomain(String domain) {
        int l = domain.length();
        if (l > 15 || l < 7) {
            return true;
        }
        byte[] str = domain.getBytes();
        if (str == null) {
            return false;
        }
        for (byte b : str) {
            if (b >= 48 && b <= 57 || b == 46) continue;
            return true;
        }
        return false;
    }
}

