/*
 * Decompiled with CFR 0.152.
 */
package img2md;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static Image getImageFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                return (Image)transferable.getTransferData(DataFlavor.imageFlavor);
            }
            return null;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return null;
    }

    public static BufferedImage scaleImage(BufferedImage sourceImage, int newWidth, int newHeight) {
        if (sourceImage == null) {
            return null;
        }
        if (newWidth == 0 || newHeight == 0) {
            return null;
        }
        AffineTransform at = AffineTransform.getScaleInstance((double)newWidth / (double)sourceImage.getWidth(null), (double)newHeight / (double)sourceImage.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(at, 2);
        return op.filter(sourceImage, null);
    }

    public static BufferedImage toBufferedImage(Image src) {
        if (src instanceof BufferedImage) {
            return (BufferedImage)src;
        }
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        if (w < 0 || h < 0) {
            return null;
        }
        int type = 2;
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static void save(BufferedImage image, File file, String format) {
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (Exception e) {
            System.out.println("Write error for " + file.getPath() + ": " + e.getMessage());
        }
    }

    public static BufferedImage loadImageFromFile(File cachedImageFile) {
        if (cachedImageFile == null || !cachedImageFile.isFile()) {
            return null;
        }
        try {
            for (int i = 0; i < 3; ++i) {
                BufferedImage read = null;
                try {
                    read = ImageIO.read(cachedImageFile);
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.print("*");
                    System.err.println("could not read" + cachedImageFile);
                    continue;
                }
                if (i > 0) {
                    System.err.println("");
                }
                return read;
            }
        }
        catch (Throwable e) {
            System.err.println("deleting " + cachedImageFile);
            cachedImageFile.delete();
            return null;
        }
        return null;
    }

    public static BufferedImage loadImageFromURL(String imageURL) {
        try {
            return ImageUtils.toBufferedImage(new ImageIcon(new URL(imageURL)).getImage());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        output.setRGB(3, 3, 123);
        return output;
    }

    public static void main(String[] args) {
        new ImageIcon("/Users/holger/Library/Application Support/Movito/covercache/backdrop/2f87c882b52b30a6.png");
    }

    public static BufferedImage removeAlpha(BufferedImage image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), Color.WHITE, null);
        g.dispose();
        return bufferedImage;
    }

    public static Image whiteToTransparent(BufferedImage image) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB = Color.WHITE.getRGB() | 0xFF000000;

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static ByteArrayInputStream bufferimagetobyteArray(BufferedImage bufferedImage) {
        byte[] array = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        return new ByteArrayInputStream(array);
    }

    public static byte[] imageToBytes(Image image, String format, BufferedImage bImage) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bImage, format, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }
}

